/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import com.google.inject.Inject;
import io.sarl.docs.doclet2.framework.ElementUtils;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.framework.TypeHierarchy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class TypeHierarchyImpl
implements TypeHierarchy {
    private final SortedSet<TypeElement> baseClasses = new TreeSet<TypeElement>((a, b) -> a.getQualifiedName().toString().compareTo(b.getQualifiedName().toString()));
    private final SortedSet<TypeElement> baseInterfaces = new TreeSet<TypeElement>((a, b) -> a.getQualifiedName().toString().compareTo(b.getQualifiedName().toString()));
    private final Map<TypeElement, SortedSet<TypeElement>> subTypes = new HashMap<TypeElement, SortedSet<TypeElement>>();
    private final Map<TypeElement, SortedSet<TypeElement>> implementingClasses = new HashMap<TypeElement, SortedSet<TypeElement>>();
    private ElementUtils elementUtils;

    @Inject
    public void setElementUtils(ElementUtils utils) {
        this.elementUtils = utils;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public void buildTree(Iterable<? extends TypeElement> typeElements, SarlDocletEnvironment environment) {
        this.baseClasses.clear();
        this.baseInterfaces.clear();
        this.implementingClasses.clear();
        this.subTypes.clear();
        for (TypeElement typeElement : typeElements) {
            ElementKind type = typeElement.getKind();
            if (type == ElementKind.CLASS) {
                this.processType(typeElement, this.baseClasses, true, environment);
                continue;
            }
            if (type != ElementKind.INTERFACE) continue;
            this.processType(typeElement, this.baseInterfaces, false, environment);
        }
    }

    @Override
    public SortedSet<TypeElement> getBaseClasses() {
        return Collections.unmodifiableSortedSet(this.baseClasses);
    }

    @Override
    public SortedSet<TypeElement> getBaseInterfaces() {
        return Collections.unmodifiableSortedSet(this.baseInterfaces);
    }

    private boolean add(Map<TypeElement, SortedSet<TypeElement>> map, TypeElement superclass, TypeElement typeElement) {
        SortedSet sset = map.computeIfAbsent(superclass, s -> new TreeSet((a, b) -> a.getQualifiedName().toString().compareTo(b.getQualifiedName().toString())));
        if (sset.contains(typeElement)) {
            return false;
        }
        sset.add(typeElement);
        return true;
    }

    protected void processType(TypeElement typeElement, Set<TypeElement> bases, boolean updateImplementingClasses, SarlDocletEnvironment environment) {
        TypeMirror superClass = this.getElementUtils().getFirstVisibleSuperType(typeElement, false, environment);
        if (superClass != null) {
            TypeElement superElement = this.getElementUtils().asTypeElement(superClass, environment.getTypeUtils());
            if (!this.add(this.subTypes, superElement, typeElement)) {
                return;
            }
            this.processType(superElement, bases, updateImplementingClasses, environment);
        } else {
            bases.add(typeElement);
        }
        if (updateImplementingClasses) {
            SortedSet<? extends TypeMirror> interfaces = this.getElementUtils().getAllInterfaces(typeElement, environment);
            for (TypeMirror typeMirror : interfaces) {
                TypeElement interf0 = this.getElementUtils().asTypeElement(typeMirror, environment.getTypeUtils());
                this.add(this.implementingClasses, interf0, typeElement);
            }
        }
    }

    @Override
    public SortedSet<? extends TypeElement> getDirectSubTypes(TypeElement typeElement) {
        SortedSet subtypes0 = this.subTypes.computeIfAbsent(typeElement, t -> new TreeSet((a, b) -> a.getQualifiedName().toString().compareTo(b.getQualifiedName().toString())));
        return Collections.unmodifiableSortedSet(subtypes0);
    }

    @Override
    public Set<TypeElement> getImplementingClasses(TypeElement typeElement) {
        SortedSet subtypes0 = this.implementingClasses.computeIfAbsent(typeElement, t -> new TreeSet((a, b) -> a.getQualifiedName().toString().compareTo(b.getQualifiedName().toString())));
        return Collections.unmodifiableSortedSet(subtypes0);
    }

    private void fillCandidates(SarlDocletEnvironment environment, boolean includeInterfaces, TypeElement type, Deque<TypeElement> candidates, Set<String> done) {
        Element superElement;
        TypeMirror superMirror = type.getSuperclass();
        if (superMirror != null && (superElement = environment.getTypeUtils().asElement(superMirror)) instanceof TypeElement) {
            String qn;
            TypeElement typeElement = (TypeElement)superElement;
            if (!environment.getApidocExcluder().isExcluded(superElement) && done.add(qn = this.getElementUtils().getLocalIdentifier(typeElement))) {
                candidates.add(typeElement);
            }
        }
        if (includeInterfaces) {
            for (TypeMirror typeMirror : type.getInterfaces()) {
                String qn;
                Element superElement2 = environment.getTypeUtils().asElement(typeMirror);
                if (!(superElement2 instanceof TypeElement)) continue;
                TypeElement te = (TypeElement)superElement2;
                if (!environment.isIncluded(superElement2) || !done.add(qn = this.getElementUtils().getLocalIdentifier(te))) continue;
                candidates.add(te);
            }
        }
    }

    @Override
    public Collection<? extends Element> getInheritedElements(TypeElement typeElement, boolean includeInterfaces, boolean includedElementsOnly, boolean includeDuplicates, boolean considerTypeElementMembers, SarlDocletEnvironment environment, Predicate<Element> selector) {
        ArrayList<Element> collection = new ArrayList<Element>();
        if (typeElement != null && selector != null) {
            LinkedList<TypeElement> candidates = new LinkedList<TypeElement>();
            TreeSet<String> memberDone = new TreeSet<String>();
            if (!includeDuplicates && considerTypeElementMembers) {
                for (Element element : typeElement.getEnclosedElements()) {
                    if (!selector.test(element)) continue;
                    String qn = this.getElementUtils().getLocalIdentifier(element);
                    memberDone.add(qn);
                }
            }
            TreeSet<String> done = new TreeSet<String>();
            this.fillCandidates(environment, includeInterfaces, typeElement, candidates, done);
            while (!candidates.isEmpty()) {
                TypeElement typeElement2 = candidates.removeFirst();
                for (Element element : typeElement2.getEnclosedElements()) {
                    if (includedElementsOnly && !environment.isIncluded(element)) continue;
                    String qn = this.getElementUtils().getLocalIdentifier(element);
                    if (!selector.test(element) || !includeDuplicates && !memberDone.add(qn)) continue;
                    collection.add(element);
                }
                this.fillCandidates(environment, includeInterfaces, typeElement2, candidates, done);
            }
        }
        return collection;
    }

    @Override
    public Collection<? extends Element> getDeclaredElements(TypeElement typeElement, boolean includeInterfaces, boolean includedElementsOnly, boolean includeDuplicates, SarlDocletEnvironment environment, Predicate<Element> selector) {
        ArrayList<Element> collection = new ArrayList<Element>();
        if (typeElement != null && selector != null) {
            LinkedList<TypeElement> candidates = new LinkedList<TypeElement>();
            TreeSet<String> memberDone = new TreeSet<String>();
            for (Element element : typeElement.getEnclosedElements()) {
                String qn = this.getElementUtils().getLocalIdentifier(element);
                if (!selector.test(element) || !includeDuplicates && !memberDone.add(qn)) continue;
                collection.add(element);
            }
            TreeSet<String> done = new TreeSet<String>();
            this.fillCandidates(environment, includeInterfaces, typeElement, candidates, done);
            while (!candidates.isEmpty()) {
                TypeElement typeElement2 = candidates.removeFirst();
                for (Element element : typeElement2.getEnclosedElements()) {
                    if (includedElementsOnly && !environment.isIncluded(element)) continue;
                    String qn = this.getElementUtils().getLocalIdentifier(element);
                    if (!selector.test(element) || !includeDuplicates && !memberDone.add(qn)) continue;
                    collection.add(element);
                }
                this.fillCandidates(environment, includeInterfaces, typeElement2, candidates, done);
            }
        }
        return collection;
    }
}

