/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.framework;

import com.google.inject.Inject;
import io.sarl.docs.doclet2.framework.ElementUtils;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.framework.TypeRepository;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

public class TypeRepositoryImpl
implements TypeRepository {
    private SortedSet<TypeElement> types;
    private Map<ModuleElement, SortedSet<TypeElement>> typesPerModule;
    private Map<PackageElement, SortedSet<TypeElement>> typesPerPackage;
    private Map<ModuleElement, SortedSet<PackageElement>> packagesPerModule;
    private SortedSet<TypeElement> deprecatedTypes;
    private SortedSet<VariableElement> deprecatedFields;
    private SortedSet<ExecutableElement> deprecatedExecutables;
    private ElementUtils elementUtils;

    @Inject
    public void setElementUtils(ElementUtils utils) {
        this.elementUtils = utils;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public void buildRepository(Iterable<? extends TypeElement> typeElements, SarlDocletEnvironment environment) {
        Comparator typeComparator = this.getElementUtils().getTypeElementComparator();
        Comparator packageComparator = this.getElementUtils().getPackageElementComparator();
        this.types = new TreeSet(typeComparator);
        this.typesPerModule = new TreeMap(this.getElementUtils().getModuleElementComparator());
        this.typesPerPackage = new TreeMap(packageComparator);
        this.packagesPerModule = new TreeMap(this.getElementUtils().getModuleElementComparator());
        this.deprecatedTypes = new TreeSet(typeComparator);
        this.deprecatedFields = new TreeSet(this.getElementUtils().getVariableElementComparator());
        this.deprecatedExecutables = new TreeSet(this.getElementUtils().getExecutableElementComparator());
        for (TypeElement typeElement : typeElements) {
            PackageElement packageElement;
            this.types.add(typeElement);
            ModuleElement moduleElement = environment.getElementUtils().getModuleOf(typeElement);
            if (moduleElement != null) {
                SortedSet list0 = this.typesPerModule.computeIfAbsent(moduleElement, it -> new TreeSet(typeComparator));
                list0.add(typeElement);
            }
            if ((packageElement = environment.getElementUtils().getPackageOf(typeElement)) != null) {
                SortedSet list0 = this.typesPerPackage.computeIfAbsent(packageElement, it -> new TreeSet(typeComparator));
                list0.add(typeElement);
                SortedSet list1 = this.packagesPerModule.computeIfAbsent(moduleElement, it -> new TreeSet(packageComparator));
                list1.add(packageElement);
            }
            if (environment.getElementUtils().isDeprecated(typeElement)) {
                if (!this.deprecatedTypes.add(typeElement)) continue;
                this.deprecate(typeElement.getEnclosedElements());
                continue;
            }
            this.discoverDeprecatedMembers(typeElement.getEnclosedElements(), environment.getElementUtils());
        }
    }

    private void deprecate(Iterable<? extends Element> elements) {
        for (Element element : elements) {
            switch (element.getKind()) {
                case FIELD: {
                    this.deprecatedFields.add((VariableElement)element);
                    break;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    this.deprecatedExecutables.add((ExecutableElement)element);
                    break;
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    if (!this.deprecatedTypes.add((TypeElement)element)) break;
                    this.deprecate(element.getEnclosedElements());
                    break;
                }
            }
        }
    }

    private void discoverDeprecatedMembers(Iterable<? extends Element> elements, Elements elementUtils) {
        for (Element element : elements) {
            if (!elementUtils.isDeprecated(element)) continue;
            switch (element.getKind()) {
                case FIELD: {
                    this.deprecatedFields.add((VariableElement)element);
                    break;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    this.deprecatedExecutables.add((ExecutableElement)element);
                    break;
                }
            }
        }
    }

    @Override
    public Set<ModuleElement> getModules() {
        return Collections.unmodifiableSet(this.typesPerModule.keySet());
    }

    @Override
    public Set<PackageElement> getPackages() {
        return Collections.unmodifiableSet(this.typesPerPackage.keySet());
    }

    @Override
    public SortedSet<TypeElement> getTypesInModule(ModuleElement moduleName) {
        SortedSet<TypeElement> data = this.typesPerModule.get(moduleName);
        if (data == null) {
            return Collections.emptySortedSet();
        }
        return Collections.unmodifiableSortedSet(data);
    }

    @Override
    public SortedSet<TypeElement> getTypesInPackage(PackageElement packageName) {
        SortedSet<TypeElement> data = this.typesPerPackage.get(packageName);
        if (data == null) {
            return Collections.emptySortedSet();
        }
        return Collections.unmodifiableSortedSet(data);
    }

    @Override
    public Iterable<PackageElement> getPackagesFor(ModuleElement moduleName) {
        SortedSet<PackageElement> data = this.packagesPerModule.get(moduleName);
        if (data == null) {
            return Collections.emptySortedSet();
        }
        return Collections.unmodifiableSortedSet(data);
    }

    @Override
    public SortedSet<TypeElement> getTypes() {
        if (this.types == null) {
            return Collections.emptySortedSet();
        }
        return Collections.unmodifiableSortedSet(this.types);
    }

    @Override
    public boolean hasDeprecatedFeatures() {
        return this.deprecatedTypes != null && !this.deprecatedTypes.isEmpty() || this.deprecatedFields != null && !this.deprecatedFields.isEmpty() || this.deprecatedExecutables != null && !this.deprecatedExecutables.isEmpty();
    }

    @Override
    public SortedSet<TypeElement> getDeprecatedTypes() {
        if (this.deprecatedTypes == null) {
            return Collections.emptySortedSet();
        }
        return Collections.unmodifiableSortedSet(this.deprecatedTypes);
    }

    @Override
    public SortedSet<VariableElement> getDeprecatedFields() {
        if (this.deprecatedFields == null) {
            return Collections.emptySortedSet();
        }
        return Collections.unmodifiableSortedSet(this.deprecatedFields);
    }

    @Override
    public SortedSet<ExecutableElement> getDeprecatedExecutables() {
        if (this.deprecatedExecutables == null) {
            return Collections.emptySortedSet();
        }
        return Collections.unmodifiableSortedSet(this.deprecatedExecutables);
    }
}

