/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html;

import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.sarl.docs.doclet2.framework.AbstractDoclet;
import io.sarl.docs.doclet2.framework.CustomTag;
import io.sarl.docs.doclet2.framework.CustomTagLocation;
import io.sarl.docs.doclet2.framework.CustomTagParser;
import io.sarl.docs.doclet2.framework.ElementFilter;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.framework.SarlTagletFactory;
import io.sarl.docs.doclet2.framework.TypeHierarchy;
import io.sarl.docs.doclet2.framework.TypeRepository;
import io.sarl.docs.doclet2.html.Messages;
import io.sarl.docs.doclet2.html.frames.AllTypesFrameGenerator;
import io.sarl.docs.doclet2.html.frames.HtmlIndexGenerator;
import io.sarl.docs.doclet2.html.frames.OverviewFrameGenerator;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.indexes.IndexGenerator;
import io.sarl.docs.doclet2.html.raw.RawModuleListGenerator;
import io.sarl.docs.doclet2.html.raw.RawPackageListGenerator;
import io.sarl.docs.doclet2.html.summaries.AllTypeSummaryGenerator;
import io.sarl.docs.doclet2.html.summaries.DeprecatedListGenerator;
import io.sarl.docs.doclet2.html.summaries.ModuleSummaryGenerator;
import io.sarl.docs.doclet2.html.summaries.OverviewSummaryGenerator;
import io.sarl.docs.doclet2.html.summaries.PackageSummaryGenerator;
import io.sarl.docs.doclet2.html.summaries.PackageTreeSummaryGenerator;
import io.sarl.docs.doclet2.html.summaries.TreeSummaryGenerator;
import io.sarl.docs.doclet2.html.taglets.block.CustomTaglet;
import io.sarl.docs.doclet2.html.types.TypeDocumentationGenerator;
import io.sarl.docs.doclet2.html.types.TypeDocumentationGeneratorSelector;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.doclet.Taglet;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.Strings;

public class SarlHtmlDoclet
extends AbstractDoclet {
    private static final String CSS_FOLDER_NAME = "css";
    private static final String JS_FOLDER_NAME = "js";
    private ElementFilter elementFilter;
    private TypeDocumentationGeneratorSelector typeGeneratorSelector;
    private IndexGenerator indexGenerator;
    private RawModuleListGenerator rawModuleListGenerator;
    private RawPackageListGenerator rawPackageListGenerator;
    private HtmlIndexGenerator htmlIndexGenerator;
    private OverviewFrameGenerator overviewFrameGenerator;
    private AllTypesFrameGenerator allTypesFrameGenerator;
    private OverviewSummaryGenerator overviewSummaryGenerator;
    private AllTypeSummaryGenerator allTypeSummaryGenerator;
    private ModuleSummaryGenerator moduleSummaryGenerator;
    private PackageSummaryGenerator packageSummaryGenerator;
    private DeprecatedListGenerator deprecatedListGenerator;
    private TreeSummaryGenerator treeSummaryGenerator;
    private PackageTreeSummaryGenerator packageTreeSummaryGenerator;
    private TypeHierarchy typeHierarchy;
    private TypeRepository typeRepository;
    private DocletOptions docletOptions;
    private SarlTagletFactory sarlTagletFactory;
    private MembersInjector<CustomTaglet> customTagletInjector;
    private Map<URL, Path> cssResources = null;
    private Map<URL, Path> jsResources = null;
    private Set<Provider<? extends Taglet>> registeredTaglets;
    private final Set<Option> options = Set.of(new Option("-author", Messages.SarlHtmlDoclet_32){

        @Override
        public boolean process(String option, List<String> arguments) {
            SarlHtmlDoclet.this.getDocletOptions().setAuthorTagsEnabled(true);
            return true;
        }
    }, new Option("-bottom", Messages.SarlHtmlDoclet_33, Messages.SarlHtmlDoclet_20){

        @Override
        public boolean process(String option, List<String> arguments) {
            if (arguments.size() >= 1) {
                SarlHtmlDoclet.this.getDocletOptions().setCopyrightText(arguments.get(0));
                return true;
            }
            return false;
        }
    }, new Option("-charset", Messages.SarlHtmlDoclet_34, Messages.SarlHtmlDoclet_35){

        @Override
        public boolean process(String option, List<String> arguments) {
            if (arguments.size() >= 1) {
                SarlHtmlDoclet.this.getDocletOptions().setCharset(arguments.get(0));
                return true;
            }
            return false;
        }
    }, new Option("-copyright", Messages.SarlHtmlDoclet_19, Messages.SarlHtmlDoclet_20){

        @Override
        public boolean process(String option, List<String> arguments) {
            if (arguments.size() >= 1) {
                SarlHtmlDoclet.this.getDocletOptions().setCopyrightText(arguments.get(0));
                return true;
            }
            return false;
        }
    }, new Option("-directory -d", Messages.SarlHtmlDoclet_0, Messages.SarlHtmlDoclet_1){

        @Override
        public boolean process(String option, List<String> arguments) {
            SarlHtmlDoclet.this.getDocletOptions().setOutputDirectory(new File(arguments.get(0)).toPath());
            return true;
        }
    }, new Option("-docencoding", Messages.SarlHtmlDoclet_36, Messages.SarlHtmlDoclet_35){

        @Override
        public boolean process(String option, List<String> arguments) {
            if (arguments.size() >= 1) {
                SarlHtmlDoclet.this.getDocletOptions().setCharset(arguments.get(0));
                return true;
            }
            return false;
        }
    }, new Option("-doctitle", Messages.SarlHtmlDoclet_37, Messages.SarlHtmlDoclet_23){

        @Override
        public boolean process(String option, List<String> arguments) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (String s : arguments) {
                if (first) {
                    first = false;
                } else {
                    b.append(" ");
                }
                b.append(s);
            }
            SarlHtmlDoclet.this.getDocletOptions().setTitle(b.toString());
            return true;
        }
    }, new Option("-fake", Messages.SarlHtmlDoclet_3){

        @Override
        public boolean process(String option, List<String> arguments) {
            SarlHtmlDoclet.this.getDocletOptions().setFakeOutput(true);
            return true;
        }
    }, new Option("-group", MessageFormat.format(Messages.SarlHtmlDoclet_24, "-group"), Messages.SarlHtmlDoclet_25, 2){

        @Override
        public boolean process(String option, List<String> arguments) {
            if (arguments.size() >= 2) {
                String heading = arguments.get(0);
                if (!Strings.isEmpty((String)heading)) {
                    String patterns = arguments.get(1);
                    if (!Strings.isEmpty((String)patterns)) {
                        String[] groupPatterns = patterns.split(Pattern.quote(":"));
                        if (groupPatterns != null && groupPatterns.length > 0) {
                            SarlHtmlDoclet.this.getDocletOptions().addGroup(heading, groupPatterns);
                            return true;
                        }
                        SarlHtmlDoclet.this.getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.SarlHtmlDoclet_28, heading, patterns));
                    } else {
                        SarlHtmlDoclet.this.getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.SarlHtmlDoclet_27, heading));
                    }
                } else {
                    SarlHtmlDoclet.this.getReporter().print(Diagnostic.Kind.ERROR, Messages.SarlHtmlDoclet_26);
                }
            }
            return false;
        }
    }, new Option("-htmlcomments", Messages.SarlHtmlDoclet_18){

        @Override
        public boolean process(String option, List<String> arguments) {
            SarlHtmlDoclet.this.getDocletOptions().setHtmlCommentsEnabled(true);
            return true;
        }
    }, new Option("-link", Messages.SarlHtmlDoclet_5, Messages.SarlHtmlDoclet_6){

        @Override
        public boolean process(String option, List<String> arguments) {
            try {
                URL url = new URI(arguments.get(0)).toURL();
                SarlHtmlDoclet.this.getExternalLinkManager().addExternalLink(url);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return true;
        }
    }, new Option("-nodeprecated", Messages.SarlHtmlDoclet_29){

        @Override
        public boolean process(String option, List<String> arguments) {
            SarlHtmlDoclet.this.getDocletOptions().setDeprecatedFeaturesEnabled(false);
            return true;
        }
    }, new Option("-nosince", Messages.SarlHtmlDoclet_30){

        @Override
        public boolean process(String option, List<String> arguments) {
            SarlHtmlDoclet.this.getDocletOptions().setSinceTagsEnabled(false);
            return true;
        }
    }, new Option("-tag", Messages.SarlHtmlDoclet_8, Messages.SarlHtmlDoclet_9){

        @Override
        public boolean process(String option, List<String> arguments) {
            String tagName = arguments.get(0);
            if (!Strings.isEmpty((String)tagName)) {
                SarlHtmlDoclet.this.getDocletOptions().addUserTag(tagName);
            }
            return true;
        }
    }, new Option("-taglet", Messages.SarlHtmlDoclet_13, Messages.SarlHtmlDoclet_14){

        @Override
        public boolean process(String option, List<String> arguments) {
            block7: {
                String classname = arguments.get(0);
                if (!Strings.isEmpty((String)classname)) {
                    try {
                        Class<?> tagletType = Class.forName(classname);
                        if (Taglet.class.isAssignableFrom(tagletType)) {
                            Class<Taglet> tagletTypeType = tagletType.asSubclass(Taglet.class);
                            Taglet taglet = SarlHtmlDoclet.this.getSarlTagletFactory().newTaglet(tagletTypeType);
                            if (taglet != null) {
                                SarlHtmlDoclet.this.getTagletManager().addTaglet(taglet, false);
                            } else {
                                SarlHtmlDoclet.this.getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.SarlHtmlDoclet_17, classname));
                            }
                            break block7;
                        }
                        SarlHtmlDoclet.this.getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.SarlHtmlDoclet_17, classname));
                    }
                    catch (Throwable ex) {
                        SarlHtmlDoclet.this.getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.SarlHtmlDoclet_15, classname, ex.getLocalizedMessage()));
                    }
                } else {
                    SarlHtmlDoclet.this.getReporter().print(Diagnostic.Kind.ERROR, Messages.SarlHtmlDoclet_16);
                }
            }
            return true;
        }
    }, new Option("-title", Messages.SarlHtmlDoclet_22, Messages.SarlHtmlDoclet_23){

        @Override
        public boolean process(String option, List<String> arguments) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (String s : arguments) {
                if (first) {
                    first = false;
                } else {
                    b.append(" ");
                }
                b.append(s);
            }
            SarlHtmlDoclet.this.getDocletOptions().setTitle(b.toString());
            return true;
        }
    }, new Option("-offline", Messages.SarlHtmlDoclet_12){

        @Override
        public boolean process(String option, List<String> arguments) {
            SarlHtmlDoclet.this.getDocletOptions().setOffline(true);
            return true;
        }
    }, new Option("-version", Messages.SarlHtmlDoclet_31){

        @Override
        public boolean process(String option, List<String> arguments) {
            SarlHtmlDoclet.this.getDocletOptions().setVersionTagsEnabled(true);
            return true;
        }
    }, new Option("-windowtitle", Messages.SarlHtmlDoclet_37, Messages.SarlHtmlDoclet_23){

        @Override
        public boolean process(String option, List<String> arguments) {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (String s : arguments) {
                if (first) {
                    first = false;
                } else {
                    b.append(" ");
                }
                b.append(s);
            }
            SarlHtmlDoclet.this.getDocletOptions().setTitle(b.toString());
            return true;
        }
    });

    @Inject
    public void setIndexGenerator(IndexGenerator generator) {
        this.indexGenerator = generator;
    }

    public IndexGenerator getIndexGenerator() {
        return this.indexGenerator;
    }

    @Inject
    public void setRawModuleListGenerator(RawModuleListGenerator generator) {
        this.rawModuleListGenerator = generator;
    }

    public RawModuleListGenerator getRawModuleListGenerator() {
        return this.rawModuleListGenerator;
    }

    @Inject
    public void setRawPackageListGenerator(RawPackageListGenerator generator) {
        this.rawPackageListGenerator = generator;
    }

    public RawPackageListGenerator getRawPackageListGenerator() {
        return this.rawPackageListGenerator;
    }

    @Inject
    public void setHtmlIndexGenerator(HtmlIndexGenerator generator) {
        this.htmlIndexGenerator = generator;
    }

    public HtmlIndexGenerator getHtmlIndexGenerator() {
        return this.htmlIndexGenerator;
    }

    @Inject
    public void setOverviewFrameGenerator(OverviewFrameGenerator generator) {
        this.overviewFrameGenerator = generator;
    }

    public OverviewFrameGenerator getOverviewFrameGenerator() {
        return this.overviewFrameGenerator;
    }

    @Inject
    public void setAllTypesFrameGenerator(AllTypesFrameGenerator generator) {
        this.allTypesFrameGenerator = generator;
    }

    public AllTypesFrameGenerator getAllTypesFrameGenerator() {
        return this.allTypesFrameGenerator;
    }

    @Inject
    public void setOverviewSummaryGenerator(OverviewSummaryGenerator generator) {
        this.overviewSummaryGenerator = generator;
    }

    public OverviewSummaryGenerator getOverviewSummaryGenerator() {
        return this.overviewSummaryGenerator;
    }

    @Inject
    public void setDeprecatedListGenerator(DeprecatedListGenerator generator) {
        this.deprecatedListGenerator = generator;
    }

    public DeprecatedListGenerator getDeprecatedListGenerator() {
        return this.deprecatedListGenerator;
    }

    @Inject
    public void setTreeSummaryGenerator(TreeSummaryGenerator generator) {
        this.treeSummaryGenerator = generator;
    }

    public TreeSummaryGenerator getTreeSummaryGenerator() {
        return this.treeSummaryGenerator;
    }

    @Inject
    public void setPackageTreeSummaryGenerator(PackageTreeSummaryGenerator generator) {
        this.packageTreeSummaryGenerator = generator;
    }

    public PackageTreeSummaryGenerator getPackageTreeSummaryGenerator() {
        return this.packageTreeSummaryGenerator;
    }

    @Inject
    public void setAllTypeSummaryGenerator(AllTypeSummaryGenerator generator) {
        this.allTypeSummaryGenerator = generator;
    }

    public AllTypeSummaryGenerator getAllTypeSummaryGenerator() {
        return this.allTypeSummaryGenerator;
    }

    @Inject
    public void setModuleSummaryGenerator(ModuleSummaryGenerator generator) {
        this.moduleSummaryGenerator = generator;
    }

    public ModuleSummaryGenerator getModuleSummaryGenerator() {
        return this.moduleSummaryGenerator;
    }

    @Inject
    public void setPackageSummaryGenerator(PackageSummaryGenerator generator) {
        this.packageSummaryGenerator = generator;
    }

    public PackageSummaryGenerator getPackageSummaryGenerator() {
        return this.packageSummaryGenerator;
    }

    @Inject
    public void setSarlTagletFactory(SarlTagletFactory factory) {
        this.sarlTagletFactory = factory;
    }

    public SarlTagletFactory getSarlTagletFactory() {
        return this.sarlTagletFactory;
    }

    @Inject
    public void setCustomTagletInjector(MembersInjector<CustomTaglet> injector) {
        this.customTagletInjector = injector;
    }

    public MembersInjector<CustomTaglet> getCustomTagletInjector() {
        return this.customTagletInjector;
    }

    public SarlHtmlDoclet(Doclet parent) {
        super(parent);
    }

    @Inject
    public void setDocletOptions(DocletOptions options) {
        this.docletOptions = options;
    }

    public DocletOptions getDocletOptions() {
        return this.docletOptions;
    }

    @Inject
    public void setRegisteredTaglets(@Named(value="registered-taglets") Set<Provider<? extends Taglet>> taglets) {
        this.registeredTaglets = taglets;
    }

    public Set<Provider<? extends Taglet>> getRegisteredTaglets() {
        if (this.registeredTaglets == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.registeredTaglets);
    }

    @Inject
    public void setTypeHierarchy(TypeHierarchy manager) {
        this.typeHierarchy = manager;
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.typeHierarchy;
    }

    @Inject
    public void setTypeRepository(TypeRepository manager) {
        this.typeRepository = manager;
    }

    public TypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    @Inject
    public void setElementFilter(ElementFilter filter) {
        this.elementFilter = filter;
    }

    public ElementFilter getElementFilter() {
        return this.elementFilter;
    }

    @Inject
    public void setTypeDocumentationGeneratorSelector(TypeDocumentationGeneratorSelector selector) {
        this.typeGeneratorSelector = selector;
    }

    public TypeDocumentationGeneratorSelector getTypeDocumentationGeneratorSelector() {
        return this.typeGeneratorSelector;
    }

    public Path getOutputDirectory() {
        return this.getDocletOptions().getOutputDirectory();
    }

    public void setOutputDirectory(Path output) {
        this.getDocletOptions().setOutputDirectory(output);
    }

    public Set<? extends Option> getSupportedOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    protected void registerTagletsToTagletManager() {
        for (Provider<? extends Taglet> tagletProvider : this.getRegisteredTaglets()) {
            Taglet taglet = (Taglet)tagletProvider.get();
            this.getTagletManager().addTaglet(taglet, false);
        }
    }

    protected void registerCustomTagsToTagletManager() {
        CustomTagParser parser = this.getCustomTagParser();
        for (String userTag : this.getDocletOptions().getUserTags()) {
            CustomTag ctag = parser.parse(userTag, CustomTagLocation.EVERYWHERE, null);
            if (ctag == null) continue;
            CustomTaglet ctaglet = new CustomTaglet(ctag);
            this.getCustomTagletInjector().injectMembers((Object)ctaglet);
            this.getTagletManager().addTaglet(ctaglet, false);
        }
    }

    @Override
    public void init(Locale locale, Reporter reporter) {
        super.init(locale, reporter);
        this.registerTagletsToTagletManager();
        this.registerCustomTagsToTagletManager();
    }

    @Override
    protected boolean generate(SarlDocletEnvironment environment) throws Exception {
        if (!this.getDocletOptions().isFakeOutput()) {
            Path outputDir = this.getOutputDirectory();
            this.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.SarlHtmlDoclet_4, outputDir.toString()));
            Files.cleanFolder((File)outputDir.toFile(), null, (boolean)false, (boolean)false);
        }
        Iterable<? extends TypeElement> typeElements = this.getElementFilter().extractTypeElements(environment);
        this.buildTypeRepository(typeElements, environment);
        this.buildTypeHierarchy(typeElements, environment);
        this.generateTypeDocumentation(typeElements, environment);
        this.generateOverviewSummary(typeElements, environment);
        this.generateAllTypesSummary(typeElements, environment);
        this.generateModuleSummary(this.getTypeRepository().getModules(), environment);
        this.generatePackageSummary(this.getTypeRepository().getPackages(), environment);
        this.generateDeprecatedList(environment);
        this.generateTreeSummary(environment);
        this.generatePackageTreeSummary(this.getTypeRepository().getPackages(), environment);
        this.generateIndex(typeElements, environment);
        this.generateHtmlIndex(environment);
        this.generateOverviewFrame(environment);
        this.generateAllTypesFrame(environment);
        this.generateRawModuleList(environment);
        this.generateRawPackageList(environment);
        this.copyResourceFiles(environment);
        return true;
    }

    protected void generateIndex(Iterable<? extends TypeElement> typeElements, SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        this.getIndexGenerator().generate(this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
    }

    protected void generateRawModuleList(SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        this.getRawModuleListGenerator().generate(environment, opts, this.getReporter());
    }

    protected void generateRawPackageList(SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        this.getRawPackageListGenerator().generate(environment, opts, this.getReporter());
    }

    protected void generateHtmlIndex(SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        this.getHtmlIndexGenerator().generate(this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
    }

    protected void generateOverviewFrame(SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        this.getOverviewFrameGenerator().generate(this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
    }

    protected void generateAllTypesFrame(SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        this.getAllTypesFrameGenerator().generate(this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
    }

    protected void generateOverviewSummary(Iterable<? extends TypeElement> typeElements, SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        this.getOverviewSummaryGenerator().generate(this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
    }

    protected void generateDeprecatedList(SarlDocletEnvironment environment) throws Exception {
        if (this.getDocletOptions().isDeprecatedFeaturesEnabled()) {
            DocletOptions opts = this.getDocletOptions();
            this.getDeprecatedListGenerator().generate(this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
        }
    }

    protected void generateTreeSummary(SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        this.getTreeSummaryGenerator().generate(this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
    }

    protected void generatePackageTreeSummary(Iterable<? extends PackageElement> packageElements, SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        for (PackageElement packageElement : packageElements) {
            this.getPackageTreeSummaryGenerator().generate(packageElement, this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
        }
    }

    protected void generateAllTypesSummary(Iterable<? extends TypeElement> typeElements, SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        this.getAllTypeSummaryGenerator().generate(this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
    }

    protected void generateModuleSummary(Iterable<? extends ModuleElement> moduleElements, SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        for (ModuleElement moduleElement : moduleElements) {
            this.getModuleSummaryGenerator().generate(moduleElement, this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
        }
    }

    protected void generatePackageSummary(Iterable<? extends PackageElement> packageElements, SarlDocletEnvironment environment) throws Exception {
        DocletOptions opts = this.getDocletOptions();
        for (PackageElement packageElement : packageElements) {
            this.getPackageSummaryGenerator().generate(packageElement, this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
        }
    }

    protected void findLocalResource(String basename, Consumer<URL> resourceCallback) throws Exception {
        assert (resourceCallback != null);
        URL url = Resources.getResource(SarlHtmlDoclet.class, (String)basename);
        if (url == null) {
            throw new FileNotFoundException(basename);
        }
        resourceCallback.accept(url);
    }

    private static String basename(URL url) {
        String bn = url.getPath();
        int idx = bn.lastIndexOf(47);
        if (idx >= 0) {
            return bn.substring(idx + 1);
        }
        return bn;
    }

    protected Map<URL, Path> getMapOfCssSheets() throws Exception {
        if (this.cssResources == null) {
            this.cssResources = new LinkedHashMap<URL, Path>();
            Consumer<URL> consumer = it -> {
                String basename = SarlHtmlDoclet.basename(it);
                Path target = Path.of(CSS_FOLDER_NAME, basename);
                this.cssResources.put((URL)it, target);
            };
            for (String cssResource : CssStyles.CSS_RESOURCES) {
                this.findLocalResource(cssResource, consumer);
            }
        }
        return this.cssResources;
    }

    protected Map<URL, Path> getMapOfJsScripts() throws Exception {
        if (this.jsResources == null) {
            this.jsResources = new LinkedHashMap<URL, Path>();
            Consumer<URL> consumer = it -> {
                String basename = SarlHtmlDoclet.basename(it);
                Path target = Path.of(JS_FOLDER_NAME, basename);
                this.jsResources.put((URL)it, target);
            };
            for (String cssResource : CssStyles.JS_RESOURCES) {
                this.findLocalResource(cssResource, consumer);
            }
        }
        return this.jsResources;
    }

    protected void copyResourceFiles(SarlDocletEnvironment environment) throws Exception {
        Path outputDir = this.getOutputDirectory();
        this.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.SarlHtmlDoclet_10, outputDir.toString()));
        Iterable listOfResources = Iterables.concat(this.getMapOfCssSheets().entrySet(), this.getMapOfJsScripts().entrySet());
        for (Map.Entry copying : listOfResources) {
            URL source = (URL)copying.getKey();
            Path target = (Path)copying.getValue();
            Path rtarget = outputDir.resolve(target);
            try {
                java.nio.file.Files.createDirectories(rtarget.getParent(), new FileAttribute[0]);
                InputStream is = source.openStream();
                try {
                    java.nio.file.Files.copy(is, rtarget, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Throwable ex) {
                this.getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.SarlHtmlDoclet_11, source.toString(), ex.getLocalizedMessage()));
            }
        }
        Path optionsPath = this.getDocletOptions().getOutputDirectory().resolve("options");
        if (!java.nio.file.Files.exists(optionsPath, new LinkOption[0])) {
            BufferedWriter writer;
            if (!java.nio.file.Files.exists(optionsPath.getParent(), new LinkOption[0])) {
                java.nio.file.Files.createDirectories(optionsPath.getParent(), new FileAttribute[0]);
            }
            if ((writer = java.nio.file.Files.newBufferedWriter(optionsPath, new OpenOption[0])) != null) {
                writer.close();
            }
        }
        Path packagelistPath = this.getDocletOptions().getOutputDirectory().resolve("package-list");
        Path packagesPath = this.getDocletOptions().getOutputDirectory().resolve("packages");
        java.nio.file.Files.copy(packagelistPath, packagesPath, new CopyOption[0]);
    }

    protected void buildTypeHierarchy(Iterable<? extends TypeElement> typeElements, SarlDocletEnvironment environment) {
        this.getReporter().print(Diagnostic.Kind.NOTE, Messages.SarlHtmlDoclet_7);
        this.getTypeHierarchy().buildTree(typeElements, environment);
    }

    protected void buildTypeRepository(Iterable<? extends TypeElement> typeElements, SarlDocletEnvironment environment) {
        this.getReporter().print(Diagnostic.Kind.NOTE, Messages.SarlHtmlDoclet_21);
        this.getTypeRepository().buildRepository(typeElements, environment);
    }

    protected void generateTypeDocumentation(Iterable<? extends TypeElement> typeElements, SarlDocletEnvironment environment) throws Exception {
        TypeDocumentationGeneratorSelector selector = this.getTypeDocumentationGeneratorSelector();
        DocletOptions opts = this.getDocletOptions();
        for (TypeElement typeElement : typeElements) {
            TypeDocumentationGenerator generator = selector.getTypeGeneratorFor(typeElement, environment);
            if (generator == null) {
                throw new Exception(MessageFormat.format(Messages.SarlHtmlDoclet_2, typeElement.getQualifiedName().toString()));
            }
            generator.generate(typeElement, this.getMapOfCssSheets().values(), this.getMapOfJsScripts().values(), environment, opts, this.getReporter());
        }
    }

    public static abstract class Option
    implements Doclet.Option,
    Comparable<Option> {
        private final String[] names;
        private final String parameter;
        private final String description;
        private final int parameterCount;

        public Option(String name, String description, String parameter) {
            this(name, description, parameter, parameter != null ? 1 : 0);
        }

        public Option(String name, String description, String parameter, int parameterCount) {
            this.names = name.trim().split("\\s+");
            this.description = description;
            this.parameter = parameter;
            this.parameterCount = parameterCount;
        }

        public Option(String name, String description) {
            this(name, description, null);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.STANDARD;
        }

        @Override
        public List<String> getNames() {
            return Arrays.asList(this.names);
        }

        @Override
        public String getParameters() {
            return this.parameter;
        }

        public String toString() {
            return Arrays.toString(this.names);
        }

        @Override
        public int getArgumentCount() {
            return this.parameterCount;
        }

        @Override
        public int compareTo(Option that) {
            return this.getNames().get(0).compareTo(that.getNames().get(0));
        }
    }
}

