/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.frames;

import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.frames.AllTypesFrameGenerator;
import io.sarl.docs.doclet2.html.frames.Messages;
import io.sarl.docs.doclet2.html.framework.AbstractDocumentationGenerator;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Navigation;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class AllTypesFrameGeneratorImpl
extends AbstractDocumentationGenerator
implements AllTypesFrameGenerator {
    @Override
    protected String getDocumentTitleFor(String elementName) {
        return this.getDocumentationTitle();
    }

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.OVERVIEW);
    }

    @Override
    public void generate(Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.initGenerator(cssStylesheets, jsScripts, reporter, environment, cliOptions);
        this.getReporter().print(Diagnostic.Kind.NOTE, Messages.AllTypesFrameGeneratorImpl_0);
        this.computePaths(this.getPathBuilder().allTypesFrame(), true);
        Path outputPath = this.getDocletOptions().getOutputDirectory().resolve(this.getRelativePath());
        Document document = this.getHtmlFactory().createDocument(cliOptions.getCharset(), this);
        String title = this.getDocumentTitleFor(null);
        this.setLastTitle(title);
        Element htmlTag = this.getHtmlAccessor().getRootElement(document);
        this.generateContentHead(htmlTag);
        this.generateContentBody(htmlTag);
        if (!this.getDocletOptions().isFakeOutput()) {
            this.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.AllTypesFrameGeneratorImpl_1, outputPath.toString()));
            AllTypesFrameGeneratorImpl.writeDocument(outputPath, document);
        }
    }

    protected void generateContentHead(Element content) {
        Element head = this.getHtmlFactory().createHeadTag(content);
        this.getHtmlFactory().createTitleTag(head, this.getDocumentationTitle());
        Path pathToRoot = this.getPathToRoot();
        for (Path cssStyle : this.getCssStylesheets()) {
            this.getHtmlFactory().createCssLinkTag(head, pathToRoot.resolve(cssStyle));
        }
        for (Path jsScript : this.getJsScripts()) {
            this.getHtmlFactory().createJsLinkTag(head, pathToRoot.resolve(jsScript));
        }
    }

    protected void generateContentBody(Element content) {
        Element body = this.getHtmlFactory().createBodyTag(content);
        body.addClass(CssStyles.FRAME.getCssClassname());
        Element typeListBlock = this.getHtmlFactory().createDivTag(body, null);
        Element typeListTitle = this.getHtmlFactory().createH2Tag(typeListBlock, CssStyles.HEADER_SMALL_TITLE);
        typeListTitle.appendText(Messages.AllTypesFrameGeneratorImpl_2);
        Element typeList = this.getHtmlFactory().createUlTag(typeListBlock, CssStyles.BULLET_LESS_LIST);
        TreeSet list = new TreeSet(this.getElementUtils().getTypeElementBasenameComparator());
        list.addAll(this.getTypeRepository().getTypes());
        for (TypeElement type : list) {
            Element typeLine = this.getHtmlFactory().createLiTag(typeList, CssStyles.BULLET_LESS_LIST);
            List<Node> link = this.getHtmlFactory().createTypeLink(type, true, null, (HtmlFactoryContext)this);
            this.getHtmlFactory().addLinkTargetFrame(link, "typeFrame");
            typeLine.appendChildren(link);
        }
    }
}

