/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.frames;

import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.frames.HtmlIndexGenerator;
import io.sarl.docs.doclet2.html.frames.Messages;
import io.sarl.docs.doclet2.html.framework.AbstractDocumentationGenerator;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.Navigation;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;

public class HtmlIndexGeneratorImpl
extends AbstractDocumentationGenerator
implements HtmlIndexGenerator {
    public static final String MAIN_PACKAGE_FRAME_NAME = "packageFrame";
    public static final String MAIN_TYPE_FRAME_NAME = "typeFrame";
    private static final String SCRIPT_0 = "    tmpTargetPage = \"\" + window.location.search;\n    if (tmpTargetPage != \"\" && tmpTargetPage != \"undefined\")\n        tmpTargetPage = tmpTargetPage.substring(1);\n    if (tmpTargetPage.indexOf(\":\") != -1 || (tmpTargetPage != \"\" && !validURL(tmpTargetPage)))\n        tmpTargetPage = \"undefined\";\n    targetPage = tmpTargetPage;\n    function validURL(url) {\n        try {\n            url = decodeURIComponent(url);\n        }\n        catch (error) {\n            return false;\n        }\n        var pos = url.indexOf(\".html\");\n        if (pos == -1 || pos != url.length - 5)\n            return false;\n        var allowNumber = false;\n        var allowSep = false;\n        var seenDot = false;\n        for (var i = 0; i < url.length - 5; i++) {\n            var ch = url.charAt(i);\n            if ('a' <= ch && ch <= 'z' ||\n                    'A' <= ch && ch <= 'Z' ||\n                    ch == '$' ||\n                    ch == '_' ||\n                    ch.charCodeAt(0) > 127) {\n                allowNumber = true;\n                allowSep = true;\n            } else if ('0' <= ch && ch <= '9'\n                    || ch == '-') {\n                if (!allowNumber)\n                     return false;\n            } else if (ch == '/' || ch == '.') {\n                if (!allowSep)\n                    return false;\n                allowNumber = false;\n                allowSep = false;\n                if (ch == '.')\n                     seenDot = true;\n                if (ch == '/' && seenDot)\n                     return false;\n            } else {\n                return false;\n            }\n        }\n        return true;\n    }\n    function loadFrames() {\n        if (targetPage != \"\" && targetPage != \"undefined\")\n             top.classFrame.location = top.targetPage;\n    }";

    @Override
    protected String getDocumentTitleFor(String elementName) {
        return this.getDocumentationTitle();
    }

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.OVERVIEW);
    }

    @Override
    public void generate(Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.initGenerator(cssStylesheets, jsScripts, reporter, environment, cliOptions);
        this.getReporter().print(Diagnostic.Kind.NOTE, Messages.HtmlIndexGeneratorImpl_0);
        this.computePaths(this.getPathBuilder().htmlIndexFile(), true);
        Path outputPath = this.getDocletOptions().getOutputDirectory().resolve(this.getRelativePath());
        DocumentType docType = this.getHtmlFactory().createDocumentType("html", "-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
        Document document = this.getHtmlFactory().createDocument(docType, cliOptions.getCharset(), this);
        String title = this.getDocumentTitleFor(null);
        this.setLastTitle(title);
        Element htmlTag = this.getHtmlAccessor().getRootElement(document);
        this.generateContentHead(htmlTag);
        this.generateContentBody(htmlTag);
        if (!this.getDocletOptions().isFakeOutput()) {
            this.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.HtmlIndexGeneratorImpl_1, outputPath.toString()));
            HtmlIndexGeneratorImpl.writeDocument(outputPath, document);
        }
    }

    protected void generateContentHead(Element content) {
        Element head = this.getHtmlFactory().createHeadTag(content);
        this.getHtmlFactory().createTitleTag(head, this.getDocumentationTitle());
        Element script = this.getHtmlFactory().createScriptTag(head, "text/javascript");
        script.append(SCRIPT_0);
    }

    protected void generateContentBody(Element content) {
        Element bodyTag = this.getHtmlFactory().createBodyTag(content);
        bodyTag.remove();
        Element docFrame = this.getHtmlFactory().createFramesetTag(content);
        docFrame.attr("cols", "20%,80%");
        docFrame.attr("title", Messages.HtmlIndexGeneratorImpl_2);
        docFrame.attr("onload", "top.loadFrames()");
        Element leftFrames = this.getHtmlFactory().createFramesetTag(docFrame);
        leftFrames.attr("rows", "30%,70%");
        leftFrames.attr("title", Messages.HtmlIndexGeneratorImpl_3);
        leftFrames.attr("onload", "top.loadFrames()");
        Element leftOverviewFrame = this.getHtmlFactory().createFrameTag(leftFrames);
        Path path = this.getPathToRoot().resolve(this.getPathBuilder().overviewFrame());
        leftOverviewFrame.attr("src", this.getHtmlFactory().path2UrlPath(path));
        leftOverviewFrame.attr("name", "packageListFrame");
        leftOverviewFrame.attr("title", Messages.HtmlIndexGeneratorImpl_7);
        Element allClassFrame = this.getHtmlFactory().createFrameTag(leftFrames);
        path = this.getPathToRoot().resolve(this.getPathBuilder().allTypesFrame());
        allClassFrame.attr("src", this.getHtmlFactory().path2UrlPath(path));
        allClassFrame.attr("name", MAIN_PACKAGE_FRAME_NAME);
        allClassFrame.attr("title", Messages.HtmlIndexGeneratorImpl_8);
        Element typeFrame = this.getHtmlFactory().createFrameTag(docFrame);
        path = this.getPathToRoot().resolve(this.getPathBuilder().overviewSummary());
        typeFrame.attr("src", this.getHtmlFactory().path2UrlPath(path));
        typeFrame.attr("name", MAIN_TYPE_FRAME_NAME);
        typeFrame.attr("title", Messages.HtmlIndexGeneratorImpl_9);
        typeFrame.attr("scrolling", "yes");
        Element noframes = this.getHtmlFactory().createNoFramesTag(docFrame);
        Element noscript = this.getHtmlFactory().createNoScriptTag(noframes);
        Element noscriptDiv = this.getHtmlFactory().createDivTag(noscript, null);
        noscriptDiv.appendText(Messages.HtmlIndexGeneratorImpl_4);
        Element title = this.getHtmlFactory().createDivTag(noframes, null);
        title.appendText(Messages.HtmlIndexGeneratorImpl_5);
        Element alert = this.getHtmlFactory().createDivTag(noframes, null);
        alert.append(Messages.HtmlIndexGeneratorImpl_6);
    }
}

