/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.frames;

import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.frames.Messages;
import io.sarl.docs.doclet2.html.frames.OverviewFrameGenerator;
import io.sarl.docs.doclet2.html.framework.AbstractDocumentationGenerator;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Navigation;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class OverviewFrameGeneratorImpl
extends AbstractDocumentationGenerator
implements OverviewFrameGenerator {
    @Override
    protected String getDocumentTitleFor(String elementName) {
        return this.getDocumentationTitle();
    }

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.OVERVIEW);
    }

    @Override
    public void generate(Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.initGenerator(cssStylesheets, jsScripts, reporter, environment, cliOptions);
        this.getReporter().print(Diagnostic.Kind.NOTE, Messages.OverviewFrameGeneratorImpl_0);
        this.computePaths(this.getPathBuilder().overviewFrame(), true);
        Path outputPath = this.getDocletOptions().getOutputDirectory().resolve(this.getRelativePath());
        Document document = this.getHtmlFactory().createDocument(cliOptions.getCharset(), this);
        String title = this.getDocumentTitleFor(null);
        this.setLastTitle(title);
        Element htmlTag = this.getHtmlAccessor().getRootElement(document);
        this.generateContentHead(htmlTag);
        this.generateContentBody(htmlTag);
        if (!this.getDocletOptions().isFakeOutput()) {
            this.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.OverviewFrameGeneratorImpl_3, outputPath.toString()));
            OverviewFrameGeneratorImpl.writeDocument(outputPath, document);
        }
    }

    protected void generateContentHead(Element content) {
        Element head = this.getHtmlFactory().createHeadTag(content);
        this.getHtmlFactory().createTitleTag(head, this.getDocumentationTitle());
        Path pathToRoot = this.getPathToRoot();
        for (Path cssStyle : this.getCssStylesheets()) {
            this.getHtmlFactory().createCssLinkTag(head, pathToRoot.resolve(cssStyle));
        }
        for (Path jsScript : this.getJsScripts()) {
            this.getHtmlFactory().createJsLinkTag(head, pathToRoot.resolve(jsScript));
        }
    }

    protected void generateContentBody(Element content) {
        Element body = this.getHtmlFactory().createBodyTag(content);
        body.addClass(CssStyles.FRAME.getCssClassname());
        Element allTypes = this.getHtmlFactory().createDivTag(body, null);
        Path path = this.getPathToRoot().resolve(this.getPathBuilder().allTypesFrame());
        List<Node> link = this.getHtmlFactory().createLink(path, Messages.OverviewFrameGeneratorImpl_1, null);
        this.getHtmlFactory().addLinkTargetFrame(link, "packageFrame");
        allTypes.appendChildren(link);
        Element packageListBlock = this.getHtmlFactory().createDivTag(body, null);
        Element packageListTitle = this.getHtmlFactory().createH2Tag(packageListBlock, CssStyles.HEADER_SMALL_TITLE);
        packageListTitle.appendText(Messages.OverviewFrameGeneratorImpl_2);
        Element packageList = this.getHtmlFactory().createUlTag(packageListBlock, CssStyles.BULLET_LESS_LIST);
        for (PackageElement pkg : this.getTypeRepository().getPackages()) {
            Element pkgLine = this.getHtmlFactory().createLiTag(packageList, CssStyles.BULLET_LESS_LIST);
            link = this.getHtmlFactory().createPackageLink(pkg, pkg.getQualifiedName().toString(), null, (HtmlFactoryContext)this);
            this.getHtmlFactory().addLinkTargetFrame(link, "packageFrame");
            pkgLine.appendChildren(link);
        }
    }
}

