/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.framework;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import io.sarl.docs.doclet2.framework.DocUtils;
import io.sarl.docs.doclet2.framework.DocumentationRepository;
import io.sarl.docs.doclet2.framework.ElementUtils;
import io.sarl.docs.doclet2.framework.QualifiedNameSetBuilder;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.framework.StandardQualifiedNameSetBuilder;
import io.sarl.docs.doclet2.framework.TagletManager;
import io.sarl.docs.doclet2.framework.TypeHierarchy;
import io.sarl.docs.doclet2.framework.TypeRepository;
import io.sarl.docs.doclet2.html.framework.BlockTagSorter;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.HtmlAccessor;
import io.sarl.docs.doclet2.html.framework.HtmlFactory;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContentExtractor;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Messages;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.framework.PathBuilder;
import io.sarl.docs.doclet2.html.taglets.SarlTaglet;
import io.sarl.docs.doclet2.html.taglets.block.ExcludeFromApidocTaglet;
import io.sarl.docs.doclet2.html.taglets.block.HiddenTaglet;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner9;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.doclet.Taglet;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public abstract class AbstractDocumentationGenerator
implements HtmlFactoryContext {
    private static final String PROPERTY_GETTER_PREFIX = "get";
    private static final String PROPERTY_SETTER_PREFIX = "set";
    private static final Pattern PROPERTY_GETTER_PATTERN = Pattern.compile("^get([A-Z][A-Za-z0-9_]*)$");
    private static final Pattern PROPERTY_SETTER_PATTERN = Pattern.compile("^set([A-Z][A-Za-z0-9_]*)$");
    private Reporter reporter;
    private String lastTitle;
    private SarlDocletEnvironment environment;
    private DocletOptions docletOptions;
    private String baseUri;
    private Path relativePath;
    private Path pathToRoot;
    private PathBuilder pathBuilder;
    private HtmlFactory htmlFactory;
    private HtmlAccessor htmlAccessor;
    private Provider<Navigation> navigationProvider;
    private Navigation navigation;
    private ElementUtils elementUtils;
    private TypeHierarchy typeHierarchy;
    private TypeRepository typeRepository;
    private DocUtils docUtils;
    private SARLGrammarKeywordAccess keywords;
    private TagletManager tagletManager;
    private BlockTagSorter blockTagSorter;
    private final List<Path> cssStylesheets = new ArrayList<Path>();
    private final List<Path> jsScripts = new ArrayList<Path>();
    private DocumentationRepository repository;

    protected void initGenerator(Collection<Path> cssStylesheets, Collection<Path> jsScripts, Reporter reporter, SarlDocletEnvironment environment, DocletOptions cliOptions) {
        this.setCssStylesheets(cssStylesheets);
        this.setJsScripts(jsScripts);
        this.setReporter(reporter);
        this.setEnvironment(environment);
        this.setDocletOptions(cliOptions);
    }

    @Inject
    public void setBlockTagSorter(BlockTagSorter sorter) {
        this.blockTagSorter = sorter;
    }

    public BlockTagSorter getBlockTagSorter() {
        return this.blockTagSorter;
    }

    @Inject
    public void setPathBuilder(PathBuilder builder) {
        this.pathBuilder = builder;
    }

    public PathBuilder getPathBuilder() {
        return this.pathBuilder;
    }

    @Inject
    public void setDocumentationRepository(DocumentationRepository repository) {
        this.repository = repository;
    }

    public DocumentationRepository getDocumentationRepository() {
        return this.repository;
    }

    @Inject
    public void setTagletManager(TagletManager manager) {
        this.tagletManager = manager;
    }

    @Override
    public TagletManager getTagletManager() {
        return this.tagletManager;
    }

    @Inject
    public void setSARLGrammarKeywordAccess(SARLGrammarKeywordAccess accessor) {
        this.keywords = accessor;
    }

    public SARLGrammarKeywordAccess getSARLGrammarKeywordAccess() {
        return this.keywords;
    }

    @Inject
    public void setTypeHierarchy(TypeHierarchy hierarchy) {
        this.typeHierarchy = hierarchy;
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.typeHierarchy;
    }

    @Inject
    public void setTypeRepository(TypeRepository repository) {
        this.typeRepository = repository;
    }

    public TypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    @Inject
    public void setDocUtils(DocUtils utils) {
        this.docUtils = utils;
    }

    @Override
    public DocUtils getDocUtils() {
        return this.docUtils;
    }

    @Inject
    public void setElementUtils(ElementUtils utils) {
        this.elementUtils = utils;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }

    @Inject
    public void setNavigationProvider(Provider<Navigation> navProvider) {
        this.navigationProvider = navProvider;
    }

    public Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = (Navigation)this.navigationProvider.get();
            this.initNavigation(this.navigation);
        }
        return this.navigation;
    }

    protected abstract void initNavigation(Navigation var1);

    @Inject
    public void setHtmlFactory(HtmlFactory factory) {
        this.htmlFactory = factory;
    }

    public HtmlFactory getHtmlFactory() {
        return this.htmlFactory;
    }

    @Inject
    public void setHtmlAccessor(HtmlAccessor accessor) {
        this.htmlAccessor = accessor;
    }

    public HtmlAccessor getHtmlAccessor() {
        return this.htmlAccessor;
    }

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    @Override
    public Path getPathToRoot() {
        return this.pathToRoot;
    }

    @Override
    public DocletOptions getDocletOptions() {
        return this.docletOptions;
    }

    protected void setDocletOptions(DocletOptions cliOptions) {
        this.docletOptions = cliOptions;
    }

    @Override
    public SarlDocletEnvironment getEnvironment() {
        return this.environment;
    }

    protected void setEnvironment(SarlDocletEnvironment environment) {
        this.environment = environment;
    }

    public String getLastTitle() {
        return this.lastTitle;
    }

    protected void setLastTitle(String title) {
        this.lastTitle = title;
    }

    @Override
    public Reporter getReporter() {
        return this.reporter;
    }

    protected void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    protected void computePaths(String element, boolean isTypeName) {
        String[] stringArray;
        if (isTypeName) {
            stringArray = element.split("[$.]");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = element;
        }
        String[] elements = stringArray;
        StringBuilder baseUri = new StringBuilder("file:");
        Path relativePath = null;
        Path pathToRoot = null;
        for (int i = 0; i < elements.length - 1; ++i) {
            baseUri.append(elements[i]);
            baseUri.append('/');
            Path currentPath = Path.of(elements[i], new String[0]);
            relativePath = relativePath == null ? currentPath : relativePath.resolve(currentPath);
            Path currentParent = Path.of("..", new String[0]);
            pathToRoot = pathToRoot == null ? currentParent : pathToRoot.resolve(currentParent);
        }
        this.pathToRoot = pathToRoot == null ? Path.of(".", new String[0]) : pathToRoot;
        Object basename = elements[elements.length - 1];
        if (!((String)basename).endsWith(".html")) {
            basename = (String)basename + ".html";
        }
        this.relativePath = relativePath == null ? Path.of((String)basename, new String[0]) : relativePath.resolve((String)basename);
        this.baseUri = baseUri.toString();
    }

    protected void computePaths(Path element, boolean addHtmlExtension) {
        int n = element.getNameCount();
        StringBuilder baseUri = new StringBuilder("file:");
        Path relativePath = null;
        Path pathToRoot = null;
        for (int i = 0; i < n - 1; ++i) {
            baseUri.append(element.getName(i));
            baseUri.append('/');
            Path currentPath = element.getName(i);
            relativePath = relativePath == null ? currentPath : relativePath.resolve(currentPath);
            Path currentParent = Path.of("..", new String[0]);
            pathToRoot = pathToRoot == null ? currentParent : pathToRoot.resolve(currentParent);
        }
        this.pathToRoot = pathToRoot == null ? Path.of(".", new String[0]) : pathToRoot;
        Object basename = element.getFileName().toString();
        if (addHtmlExtension && !((String)basename).endsWith(".html")) {
            basename = (String)basename + ".html";
        }
        this.relativePath = relativePath == null ? Path.of((String)basename, new String[0]) : relativePath.resolve((String)basename);
        this.baseUri = baseUri.toString();
    }

    protected static void mkdirs(Path filename) throws Exception {
        Path par = filename.getParent();
        if (!Files.exists(par, new LinkOption[0])) {
            Files.createDirectories(par, new FileAttribute[0]);
        }
    }

    protected static void writeDocument(Path filename, Document htmlDocument) throws Exception {
        AbstractDocumentationGenerator.mkdirs(filename);
        try (BufferedWriter writer = Files.newBufferedWriter(filename, new OpenOption[0]);){
            writer.write(htmlDocument.toString());
        }
    }

    protected static void writeDocument(Path filename, String htmlDocument) throws Exception {
        AbstractDocumentationGenerator.mkdirs(filename);
        try (BufferedWriter writer = Files.newBufferedWriter(filename, new OpenOption[0]);){
            writer.write(htmlDocument.toString());
        }
    }

    protected abstract String getDocumentTitleFor(String var1);

    public Iterable<Path> getCssStylesheets() {
        return this.cssStylesheets;
    }

    public void setCssStylesheets(Collection<Path> styles) {
        this.cssStylesheets.clear();
        if (styles != null) {
            this.cssStylesheets.addAll(styles);
        }
    }

    public Iterable<Path> getJsScripts() {
        return this.jsScripts;
    }

    public void setJsScripts(Collection<Path> scripts) {
        this.jsScripts.clear();
        if (scripts != null) {
            this.jsScripts.addAll(scripts);
        }
    }

    protected void createBlockTagStructure(Taglet.Location tagLocation, javax.lang.model.element.Element documentedElement, List<BlockTagTree> tagTrees, Element parent, CssStyles style, QualifiedNameSetBuilder defaultPackages) {
        if (!tagTrees.isEmpty()) {
            String tagName = tagTrees.get(0).getTagName();
            Taglet taglet = this.getTagletManager().getBlockTaglet(tagLocation, tagName);
            if (taglet != null) {
                Element dtTag = this.getHtmlFactory().createDtTag(parent, style);
                Element ddTag = this.getHtmlFactory().createDdTag(parent, style);
                if (taglet instanceof SarlTaglet) {
                    SarlTaglet staglet = (SarlTaglet)taglet;
                    if (staglet.isActiveTaglet(this.getDocletOptions())) {
                        dtTag.appendText(staglet.getTagBlockLabel());
                        TagContentExtractor extractor = new TagContentExtractor();
                        staglet.appendNode(ddTag, tagTrees, documentedElement, null, style, extractor);
                    }
                } else {
                    dtTag.appendText(SarlTaglet.buildBlockLabel(taglet.getName()));
                    boolean changed = false;
                    HtmlFactory.CommentTextMemory memory = this.getHtmlFactory().createCommentTextMemory(ddTag, documentedElement, this);
                    for (BlockTagTree tagTree : tagTrees) {
                        if (changed) {
                            ddTag.append(",");
                            this.getHtmlFactory().createSecableSpace(ddTag);
                        }
                        if (!this.getHtmlFactory().createCommentText(memory, tagTree, style)) continue;
                        changed = true;
                    }
                }
            } else {
                this.getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.AbstractDocumentationGenerator_0, new Object[]{tagName, tagLocation}));
            }
        }
    }

    @Override
    public QualifiedNameSetBuilder getQualifiedNameSetBuilder(javax.lang.model.element.Element element) {
        PackageElement defaultPackage = this.getEnvironment().getElementUtils().getPackageOf(element);
        QualifiedNameSetBuilder defaultPackages = this.buildCallbackForTypeFinding(defaultPackage, this.buildImportedPackageSet(element));
        return defaultPackages;
    }

    protected Set<String> buildImportedPackageSet(javax.lang.model.element.Element element) {
        ImportScanner importScanner = new ImportScanner();
        importScanner.build(element);
        Set<String> importedPackages = importScanner.getBaseSearchpath();
        return importedPackages;
    }

    protected QualifiedNameSetBuilder buildCallbackForTypeFinding(PackageElement currentPackage, Set<String> importedPackages) {
        return new StandardQualifiedNameSetBuilder(currentPackage, importedPackages);
    }

    protected boolean isPropertyGetterName(String name) {
        Matcher matcher;
        return !Strings.isEmpty((String)name) && (matcher = PROPERTY_GETTER_PATTERN.matcher(name)).matches();
    }

    protected boolean isPropertySetterName(String name) {
        Matcher matcher;
        return !Strings.isEmpty((String)name) && (matcher = PROPERTY_SETTER_PATTERN.matcher(name)).matches();
    }

    protected String getterName2property(String getterName) {
        String name;
        Matcher matcher;
        if (!Strings.isEmpty((String)getterName) && (matcher = PROPERTY_GETTER_PATTERN.matcher(getterName)).matches() && !Strings.isEmpty((String)(name = matcher.group(1)))) {
            return Strings.toFirstLower((String)name);
        }
        return null;
    }

    protected String setterName2property(String setterName) {
        String name;
        Matcher matcher;
        if (!Strings.isEmpty((String)setterName) && (matcher = PROPERTY_SETTER_PATTERN.matcher(setterName)).matches() && !Strings.isEmpty((String)(name = matcher.group(1)))) {
            return Strings.toFirstLower((String)name);
        }
        return null;
    }

    protected String property2getterName(String name) {
        if (!Strings.isEmpty((String)name)) {
            return PROPERTY_GETTER_PREFIX + Strings.toFirstUpper((String)name);
        }
        return null;
    }

    protected String property2setterName(String name) {
        if (!Strings.isEmpty((String)name)) {
            return PROPERTY_SETTER_PREFIX + Strings.toFirstUpper((String)name);
        }
        return null;
    }

    protected void createCopyrightBox(Element parent) {
        String copyrightText = this.getDocletOptions().getCopyrightText();
        if (!Strings.isEmpty((String)copyrightText)) {
            Element copyrightDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.COPYRIGHT_BOX);
            copyrightDiv.append(Messages.AbstractDocumentationGenerator_1);
            this.getHtmlFactory().createSecableSpace(copyrightDiv);
            copyrightDiv.appendText(copyrightText);
        }
    }

    protected <T extends javax.lang.model.element.Element> void createDetailBox(String boxTitle, String boxId, Element receiver, Iterable<? extends T> elements, Comparator<? super T> sorter, Functions.Function1<T, String> keyExtractor, Functions.Function1<T, Collection<? extends Node>> titleExtractor, Functions.Function1<T, Collection<? extends Node>> contentExtractor) {
        Iterable<T> theElements;
        Element rootBox = this.getHtmlFactory().createDivTag(null, CssStyles.DETAIL_BOX);
        if (!Strings.isEmpty((String)boxId)) {
            rootBox.id(boxId);
            this.getNavigation().addDetailBoxAnchor(boxId);
        }
        Element btitle = this.getHtmlFactory().createDivTag(rootBox, CssStyles.DETAIL_BOX_TITLE);
        btitle.appendText(boxTitle);
        if (sorter != null) {
            ArrayList<T> sortedList = new ArrayList<T>();
            for (javax.lang.model.element.Element element : elements) {
                sortedList.add(element);
            }
            Collections.sort(sortedList, sorter);
            theElements = sortedList;
        } else {
            theElements = elements;
        }
        Element elementsDiv = this.getHtmlFactory().createDlTag(null, CssStyles.DETAIL_BOX);
        boolean hasElements = false;
        for (javax.lang.model.element.Element element : theElements) {
            String id;
            hasElements = true;
            Element elementTitleDiv = this.getHtmlFactory().createDtTag(elementsDiv, CssStyles.DETAIL_BOX);
            if (keyExtractor != null && !Strings.isEmpty((String)(id = (String)keyExtractor.apply((Object)element)))) {
                elementTitleDiv.id(id);
            }
            Element elementDescriptionDiv = this.getHtmlFactory().createDdTag(elementsDiv, CssStyles.DETAIL_BOX);
            elementTitleDiv.appendChildren((Collection)titleExtractor.apply((Object)element));
            elementDescriptionDiv.appendChildren((Collection)contentExtractor.apply((Object)element));
        }
        if (hasElements) {
            rootBox.appendChild((Node)elementsDiv);
        }
        if (hasElements) {
            receiver.appendChild((Node)rootBox);
        }
    }

    protected <T extends javax.lang.model.element.Element> void createSummaryBox1(String boxTitle, String tableTitle, String tableColumn, String boxId, Element receiver, Iterable<? extends T> elements, Comparator<? super T> sorter, Functions.Function1<T, Collection<? extends Node>> contentExtractor) {
        this.createSummaryBox1(boxTitle, tableTitle, tableColumn, boxId, receiver, elements, sorter, contentExtractor, null);
    }

    protected <T extends javax.lang.model.element.Element> void createSummaryBox1(String boxTitle, String tableTitle, String tableColumn, String boxId, Element receiver, Iterable<? extends T> elements, Comparator<? super T> sorter, Functions.Function1<T, Collection<? extends Node>> contentExtractor, Functions.Function0<Collection<? extends Node>> inheritedExtractor) {
        this.createSummaryBox1(boxTitle, tableColumn, boxId, receiver, Collections.singletonMap(tableTitle, elements), sorter, contentExtractor, null);
    }

    protected <T extends javax.lang.model.element.Element> void createSummaryBox1(String boxTitle, String tableColumn, String boxId, Element receiver, Map<String, Iterable<? extends T>> elements, Comparator<? super T> sorter, Functions.Function1<T, Collection<? extends Node>> contentExtractor, Functions.Function0<Collection<? extends Node>> inheritedExtractor) {
        Collection inheritedNodes;
        Element rootBox = this.getHtmlFactory().createDivTag(null, CssStyles.SUMMARY_BOX);
        if (!Strings.isEmpty((String)boxId)) {
            rootBox.id(boxId);
            this.getNavigation().addSummaryBoxAnchor(boxId);
        }
        Element btitle = this.getHtmlFactory().createDivTag(rootBox, CssStyles.SUMMARY_BOX_TITLE);
        btitle.appendText(boxTitle);
        HtmlFactory.HtmlTabsFactory tabsFactory = this.getHtmlFactory().createTabBox(CssStyles.SUMMARY_BOX_TAB_TITLE, CssStyles.SUMMARY_BOX_TAB_CONTENT);
        boolean hasElements = false;
        for (Map.Entry<String, Iterable<T>> tabEntry : elements.entrySet()) {
            Iterable<T> theElements;
            tabsFactory.addTab(tabEntry.getKey());
            Element table = this.getHtmlFactory().createTableTag(tabsFactory.getLastContent(), CssStyles.SUMMARY_TABLE);
            Element tableHeader = this.getHtmlFactory().createTableHeaderTag(table, CssStyles.SUMMARY_TABLE);
            Element tableHeaderRow = this.getHtmlFactory().createTableRowTag(tableHeader, CssStyles.SUMMARY_TABLE);
            Element tableColumnHeader0 = this.getHtmlFactory().createTableColumnHeadTag(tableHeaderRow, CssStyles.SUMMARY_TABLE);
            tableColumnHeader0.appendText(tableColumn);
            Element tableBody = this.getHtmlFactory().createTableBodyTag(table, CssStyles.SUMMARY_TABLE);
            if (sorter != null) {
                ArrayList<T> sortedList = new ArrayList<T>();
                for (javax.lang.model.element.Element element : tabEntry.getValue()) {
                    sortedList.add(element);
                }
                Collections.sort(sortedList, sorter);
                theElements = sortedList;
            } else {
                theElements = tabEntry.getValue();
            }
            boolean hasTabElements = false;
            for (javax.lang.model.element.Element element : theElements) {
                hasElements = true;
                hasTabElements = true;
                Element tableRow = this.getHtmlFactory().createTableRowTag(tableBody, CssStyles.SUMMARY_TABLE);
                Element typeCell = this.getHtmlFactory().createTableCellTag(tableRow, CssStyles.SUMMARY_TABLE);
                Collection typeText = (Collection)contentExtractor.apply((Object)element);
                typeCell.appendChildren(typeText);
            }
            if (hasTabElements) continue;
            tabsFactory.removeLastTab();
        }
        if (hasElements) {
            tabsFactory.createSelectors(rootBox);
            tabsFactory.createContents(rootBox);
        }
        if (inheritedExtractor != null && (inheritedNodes = (Collection)inheritedExtractor.apply()) != null && !inheritedNodes.isEmpty()) {
            hasElements = true;
            Element inheritedDiv = this.getHtmlFactory().createDivTag(rootBox, CssStyles.SUMMARY_BOX_INHERITED);
            Element inheritedSpan = this.getHtmlFactory().createSpanTag(inheritedDiv, CssStyles.SUMMARY_BOX_INHERITED);
            inheritedSpan.appendText(Messages.AbstractDocumentationGenerator_2);
            this.getHtmlFactory().createSecableSpace(inheritedSpan);
            inheritedDiv.appendChildren(inheritedNodes);
        }
        if (hasElements) {
            receiver.appendChild((Node)rootBox);
        }
    }

    protected <T extends javax.lang.model.element.Element> void createSummaryBox2(String boxTitle, String tableTitle, String tableTypeColumn, String tableDescriptionColumn, String boxId, Element receiver, Iterable<? extends T> elements, Comparator<? super T> sorter, Functions.Function1<T, Collection<? extends Node>> typeExtractor, Functions.Function1<T, Collection<? extends Node>> descriptionExtractor) {
        this.createSummaryBox2(boxTitle, tableTitle, tableTypeColumn, tableDescriptionColumn, boxId, receiver, elements, sorter, typeExtractor, descriptionExtractor, null);
    }

    protected <T extends javax.lang.model.element.Element> void createSummaryBox2(String boxTitle, String tableTitle, String tableTypeColumn, String tableDescriptionColumn, String boxId, Element receiver, Iterable<? extends T> elements, Comparator<? super T> sorter, Functions.Function1<T, Collection<? extends Node>> typeExtractor, Functions.Function1<T, Collection<? extends Node>> descriptionExtractor, Functions.Function0<Collection<? extends Node>> inheritedExtractor) {
        Map<String, Iterable<? extends T>> tabElements = Collections.singletonMap(tableTitle, elements);
        this.createSummaryBox2(boxTitle, tableTypeColumn, tableDescriptionColumn, boxId, receiver, tabElements, sorter, typeExtractor, descriptionExtractor, inheritedExtractor);
    }

    protected <T extends javax.lang.model.element.Element> void createSummaryBox2(String boxTitle, String tableTypeColumn, String tableDescriptionColumn, String boxId, Element receiver, Map<String, Iterable<? extends T>> elements, Comparator<? super T> sorter, Functions.Function1<T, Collection<? extends Node>> typeExtractor, Functions.Function1<T, Collection<? extends Node>> descriptionExtractor, Functions.Function0<Collection<? extends Node>> inheritedExtractor) {
        Collection inheritedNodes;
        Element rootBox = this.getHtmlFactory().createDivTag(null, CssStyles.SUMMARY_BOX);
        if (!Strings.isEmpty((String)boxId)) {
            rootBox.id(boxId);
            this.getNavigation().addSummaryBoxAnchor(boxId);
        }
        Element btitle = this.getHtmlFactory().createDivTag(rootBox, CssStyles.SUMMARY_BOX_TITLE);
        btitle.appendText(boxTitle);
        HtmlFactory.HtmlTabsFactory tabsFactory = this.getHtmlFactory().createTabBox(CssStyles.SUMMARY_BOX_TAB_TITLE, CssStyles.SUMMARY_BOX_TAB_CONTENT);
        boolean hasElements = false;
        for (Map.Entry<String, Iterable<T>> tabEntry : elements.entrySet()) {
            Iterable<T> theElements;
            tabsFactory.addTab(tabEntry.getKey());
            Element table = this.getHtmlFactory().createTableTag(tabsFactory.getLastContent(), CssStyles.SUMMARY_TABLE);
            Element tableHeader = this.getHtmlFactory().createTableHeaderTag(table, CssStyles.SUMMARY_TABLE);
            Element tableHeaderRow = this.getHtmlFactory().createTableRowTag(tableHeader, CssStyles.SUMMARY_TABLE);
            Element tableColumnHeader0 = this.getHtmlFactory().createTableColumnHeadTag(tableHeaderRow, CssStyles.SUMMARY_TABLE);
            tableColumnHeader0.appendText(tableTypeColumn);
            Element tableColumnHeader1 = this.getHtmlFactory().createTableColumnHeadTag(tableHeaderRow, CssStyles.SUMMARY_TABLE);
            tableColumnHeader1.appendText(tableDescriptionColumn);
            Element tableBody = this.getHtmlFactory().createTableBodyTag(table, CssStyles.SUMMARY_TABLE);
            if (sorter != null) {
                ArrayList<T> sortedList = new ArrayList<T>();
                for (javax.lang.model.element.Element element : tabEntry.getValue()) {
                    sortedList.add(element);
                }
                Collections.sort(sortedList, sorter);
                theElements = sortedList;
            } else {
                theElements = tabEntry.getValue();
            }
            boolean hasTabElements = false;
            for (javax.lang.model.element.Element element : theElements) {
                hasElements = true;
                hasTabElements = true;
                Element tableRow = this.getHtmlFactory().createTableRowTag(tableBody, CssStyles.SUMMARY_TABLE);
                Element typeCell = this.getHtmlFactory().createTableCellTag(tableRow, CssStyles.SUMMARY_TABLE);
                Collection typeText = (Collection)typeExtractor.apply((Object)element);
                typeCell.appendChildren(typeText);
                Element descriptionCell = this.getHtmlFactory().createTableCellTag(tableRow, CssStyles.SUMMARY_TABLE);
                Collection descriptionText = (Collection)descriptionExtractor.apply((Object)element);
                descriptionCell.appendChildren(descriptionText);
            }
            if (hasTabElements) continue;
            tabsFactory.removeLastTab();
        }
        if (hasElements) {
            tabsFactory.createSelectors(rootBox);
            tabsFactory.createContents(rootBox);
        }
        if (inheritedExtractor != null && (inheritedNodes = (Collection)inheritedExtractor.apply()) != null && !inheritedNodes.isEmpty()) {
            hasElements = true;
            Element inheritedDiv = this.getHtmlFactory().createDivTag(rootBox, CssStyles.SUMMARY_BOX_INHERITED);
            Element inheritedSpan = this.getHtmlFactory().createSpanTag(inheritedDiv, CssStyles.SUMMARY_BOX_INHERITED);
            inheritedSpan.appendText(Messages.AbstractDocumentationGenerator_2);
            this.getHtmlFactory().createSecableSpace(inheritedSpan);
            boolean first = true;
            for (Node node : inheritedNodes) {
                if (first) {
                    first = false;
                } else {
                    inheritedDiv.appendText(", ");
                }
                inheritedDiv.appendChild(node);
            }
        }
        if (hasElements) {
            receiver.appendChild((Node)rootBox);
        }
    }

    protected String getDocumentationTitle() {
        String cli = this.getDocletOptions().getTitle();
        if (!Strings.isEmpty((String)cli)) {
            return cli;
        }
        return Messages.AbstractDocumentationGenerator_3;
    }

    protected void createShortDeprecationMessage(javax.lang.model.element.Element element, List<Node> nodes, boolean addTitle) {
        javax.lang.model.element.Element deprecatedElement = this.getElementUtils().getFirstEnclosingDeprecatedElement(element);
        if (deprecatedElement != null) {
            List<? extends BlockTagTree> deprs;
            Element deprecatedDiv = this.getHtmlFactory().createDivTag(null, CssStyles.DEPRECATION_INFO);
            boolean isForRemoval = this.getElementUtils().isDeprecatedForRemoval(deprecatedElement);
            String since = this.getElementUtils().getDeprecatedSince(deprecatedElement);
            if (addTitle) {
                Element prefix = this.getHtmlFactory().createSpanTag(null, CssStyles.DEPRECATION_INFO_TITLE);
                if (Strings.isEmpty((String)since)) {
                    if (isForRemoval) {
                        prefix.appendText(Messages.AbstractDocumentationGenerator_4);
                    } else {
                        prefix.appendText(Messages.AbstractDocumentationGenerator_5);
                    }
                } else if (isForRemoval) {
                    prefix.appendText(MessageFormat.format(Messages.AbstractDocumentationGenerator_6, since));
                } else {
                    prefix.appendText(MessageFormat.format(Messages.AbstractDocumentationGenerator_7, since));
                }
                deprecatedDiv.appendChild((Node)prefix);
                deprecatedDiv.appendChild(this.getHtmlFactory().createSecableSpace(null));
            }
            if (!(deprs = this.getDocUtils().getBlockTags(deprecatedElement, DocTree.Kind.DEPRECATED, this.getEnvironment())).isEmpty()) {
                for (BlockTagTree blockTagTree : deprs) {
                    List<? extends DocTree> text = this.getDocUtils().getCommentForDeprecatedTag(blockTagTree);
                    if (text.isEmpty()) continue;
                    HtmlFactory.CommentTextMemory memory = this.getHtmlFactory().createCommentTextMemory(deprecatedDiv, deprecatedElement, this);
                    for (DocTree docTree : text) {
                        this.getHtmlFactory().createCommentText(memory, docTree, CssStyles.DEPRECATION_INFO);
                    }
                }
            }
            if (!(addTitle || !isForRemoval && Strings.isEmpty((String)since))) {
                this.getHtmlFactory().createSecableSpace(deprecatedDiv);
                if (isForRemoval) {
                    if (Strings.isEmpty((String)since)) {
                        deprecatedDiv.appendText(Messages.AbstractDocumentationGenerator_8);
                    } else {
                        deprecatedDiv.appendText(MessageFormat.format(Messages.AbstractDocumentationGenerator_9, since));
                    }
                } else {
                    deprecatedDiv.appendText(MessageFormat.format(Messages.AbstractDocumentationGenerator_10, since));
                }
            }
            nodes.add((Node)deprecatedDiv);
        }
    }

    protected void createFirstSentence(javax.lang.model.element.Element element, List<Node> nodes, boolean newLine, boolean div) {
        List<? extends DocTree> description;
        SarlDocletEnvironment env = this.getEnvironment();
        DocCommentTree docTree = env.getDocTrees().getDocCommentTree(element);
        if (docTree != null && (description = docTree.getFirstSentence()) != null && !description.isEmpty()) {
            if (newLine) {
                nodes.add((Node)this.getHtmlFactory().createNewLineTag());
            }
            if (div) {
                Element container = this.getHtmlFactory().createDivTag(null, null);
                nodes.add((Node)container);
                HtmlFactory.CommentTextMemory memory = this.getHtmlFactory().createCommentTextMemory(container, element, this);
                for (DocTree docTree2 : description) {
                    this.getHtmlFactory().createCommentText(memory, docTree2, null);
                }
            } else {
                Element container = this.getHtmlFactory().createSpanTag(null, null);
                HtmlFactory.CommentTextMemory memory = this.getHtmlFactory().createCommentTextMemory(container, element, this);
                for (DocTree docTree3 : description) {
                    this.getHtmlFactory().createCommentText(memory, docTree3, null);
                }
                nodes.addAll(container.childNodes());
            }
        }
    }

    protected void createFullDescriptionBody(javax.lang.model.element.Element element, List<Node> nodes, boolean newLine, boolean div) {
        List<? extends DocTree> description;
        SarlDocletEnvironment env = this.getEnvironment();
        DocCommentTree docTree = env.getDocTrees().getDocCommentTree(element);
        if (docTree != null && (description = docTree.getFullBody()) != null && !description.isEmpty()) {
            if (newLine) {
                nodes.add((Node)this.getHtmlFactory().createNewLineTag());
            }
            if (div) {
                Element container = this.getHtmlFactory().createDivTag(null, null);
                nodes.add((Node)container);
                HtmlFactory.CommentTextMemory memory = this.getHtmlFactory().createCommentTextMemory(container, element, this);
                for (DocTree docTree2 : description) {
                    this.getHtmlFactory().createCommentText(memory, docTree2, null);
                }
            } else {
                Element container = this.getHtmlFactory().createSpanTag(null, null);
                HtmlFactory.CommentTextMemory memory = this.getHtmlFactory().createCommentTextMemory(container, element, this);
                for (DocTree docTree3 : description) {
                    this.getHtmlFactory().createCommentText(memory, docTree3, null);
                }
                nodes.addAll(container.childNodes());
            }
        }
    }

    protected void createBlockTagsFor(javax.lang.model.element.Element element, List<Node> nodes, Taglet.Location tagLocation, CssStyles style) {
        Element dlTag = this.getHtmlFactory().createDlTag(null, style);
        this.createTagInfo(dlTag, element, tagLocation, style);
        if (dlTag.childNodeSize() > 0) {
            nodes.add((Node)dlTag);
        }
    }

    protected void createTagInfo(Element dlTag, javax.lang.model.element.Element element, Taglet.Location tagLocation, CssStyles style) {
        List<? extends BlockTagTree> comments = this.getDocUtils().getBlockTags(element, this.getEnvironment());
        if (!comments.isEmpty()) {
            PackageElement currentPackage = this.getEnvironment().getElementUtils().getPackageOf(element);
            QualifiedNameSetBuilder defaultPackages = this.buildCallbackForTypeFinding(currentPackage, this.buildImportedPackageSet(element));
            TreeMap<String, List> groups = new TreeMap<String, List>(this.getBlockTagSorter());
            for (BlockTagTree blockTagTree : comments) {
                String tagName = blockTagTree.getTagName().toLowerCase();
                List list = groups.computeIfAbsent(tagName, it -> new ArrayList());
                if (ExcludeFromApidocTaglet.TAG_NAME.equalsIgnoreCase(tagName) || HiddenTaglet.TAG_NAME.equalsIgnoreCase(tagName)) continue;
                list.add(blockTagTree);
            }
            for (List list : groups.values()) {
                this.createBlockTagStructure(tagLocation, element, list, dlTag, style, defaultPackages);
            }
        }
    }

    protected class TagContentExtractor
    implements HtmlFactoryContentExtractor {
        protected TagContentExtractor() {
        }

        @Override
        public HtmlFactoryContext getContext() {
            return AbstractDocumentationGenerator.this;
        }

        @Override
        public javax.lang.model.element.Element extractReferencedElement(DocTree docNode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Node> extractReference(DocTree docNode, List<Node> label, boolean isplain) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element extractSimpleText(List<? extends DocTree> text) {
            throw new UnsupportedOperationException();
        }
    }

    protected class ImportScanner
    extends ElementScanner9<Void, Void> {
        private Set<String> searchpath = new TreeSet<String>();

        protected ImportScanner() {
        }

        private void addQN(String fullyQualifiedName) {
            int index;
            if (!Strings.isEmpty((String)fullyQualifiedName) && (index = fullyQualifiedName.lastIndexOf(46)) >= 1) {
                String pkg = fullyQualifiedName.substring(0, index);
                this.searchpath.add(pkg);
            }
        }

        private void add(TypeElement type) {
            if (type != null) {
                this.addQN(type.getQualifiedName().toString());
            }
        }

        private void add(TypeMirror mirror) {
            if (mirror != null) {
                this.add(AbstractDocumentationGenerator.this.getElementUtils().asTypeElement(mirror, AbstractDocumentationGenerator.this.getEnvironment().getTypeUtils()));
            }
        }

        public void build(javax.lang.model.element.Element element) {
            javax.lang.model.element.Element elt;
            TypeElement cvalue;
            TypeElement type = element instanceof TypeElement ? (cvalue = (TypeElement)element) : AbstractDocumentationGenerator.this.getElementUtils().getEnclosingTypeElement(element);
            this.add(type);
            if (type != null) {
                this.scan(type, null);
                elt = type.getEnclosingElement();
            } else {
                this.scan(element, null);
                elt = null;
            }
            while (elt != null) {
                if (elt instanceof TypeElement) {
                    TypeElement te = (TypeElement)elt;
                    this.addQN(te.getQualifiedName().toString());
                    elt = te.getEnclosingElement();
                    continue;
                }
                elt = null;
            }
        }

        public Set<String> getBaseSearchpath() {
            return this.searchpath;
        }

        @Override
        public Void visitType(TypeElement e, Void p) {
            for (TypeMirror typeMirror : e.getInterfaces()) {
                this.add(typeMirror);
            }
            this.add(e.getSuperclass());
            return (Void)super.visitType(e, p);
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Void p) {
            if (e.getReturnType().getKind() == TypeKind.DECLARED) {
                this.add(e.getReturnType());
            }
            for (TypeMirror typeMirror : e.getThrownTypes()) {
                if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                this.add(typeMirror);
            }
            return (Void)super.visitExecutable(e, p);
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, Void p) {
            if (e.asType().getKind() == TypeKind.DECLARED) {
                this.add(e.asType());
            }
            return (Void)super.visitTypeParameter(e, p);
        }

        @Override
        public Void visitVariable(VariableElement e, Void p) {
            if (e.asType().getKind() == TypeKind.DECLARED) {
                this.add(e.asType());
            }
            return (Void)super.visitVariable(e, p);
        }

        @Override
        public Void visitRecordComponent(RecordComponentElement e, Void p) {
            if (e.asType().getKind() == TypeKind.DECLARED) {
                this.add(e.asType());
            }
            return (Void)this.scan(e.getEnclosedElements(), p);
        }
    }
}

