/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.framework;

import com.google.common.base.Strings;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.xtext.xbase.lib.Pair;

public class DefaultDocletOptions
implements DocletOptions {
    public static final String EXCLUDEFROMAPIDOC_TAG = "excludefromapidoc";
    public static final String MAVENGROUPID_TAG = "mavengroupid";
    public static final String MAVENARTIFACTID_TAG = "mavenartifactid";
    public static final String PRIVATEAPI_TAG = "privateapi";
    private Path outputDirectory;
    private boolean fake;
    private boolean offline;
    private boolean enableHtmlComments;
    private boolean enableDeprecated = true;
    private boolean enableSinceTag = true;
    private boolean enableVersionTag;
    private boolean enableAuthorTag;
    private Set<String> additionalTags = new TreeSet<String>();
    private String copyrightText;
    private String title;
    private final List<Pair<String, Pattern>> groups = new ArrayList<Pair<String, Pattern>>();
    private String charset;

    public DefaultDocletOptions() {
        this.addDefaultUserTags();
    }

    protected void addDefaultUserTags() {
        this.addUserTag(EXCLUDEFROMAPIDOC_TAG);
        this.addUserTag(MAVENGROUPID_TAG);
        this.addUserTag(MAVENARTIFACTID_TAG);
        this.addUserTag(PRIVATEAPI_TAG);
    }

    @Override
    public Path getOutputDirectory() {
        if (this.outputDirectory == null) {
            return Path.of("", new String[0]).toAbsolutePath();
        }
        return this.outputDirectory;
    }

    @Override
    public void setOutputDirectory(Path output) {
        this.outputDirectory = output;
    }

    @Override
    public boolean isFakeOutput() {
        return this.fake;
    }

    @Override
    public void setFakeOutput(boolean fake) {
        this.fake = fake;
    }

    @Override
    public void addUserTag(String tagName) {
        this.additionalTags.add(tagName.toLowerCase().trim());
    }

    @Override
    public Set<String> getUserTags() {
        return Collections.unmodifiableSet(this.additionalTags);
    }

    @Override
    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public void setHtmlCommentsEnabled(boolean enable) {
        this.enableHtmlComments = enable;
    }

    @Override
    public boolean isHtmlCommentsEnabled() {
        return this.enableHtmlComments;
    }

    @Override
    public void setDeprecatedFeaturesEnabled(boolean enable) {
        this.enableDeprecated = enable;
    }

    @Override
    public boolean isDeprecatedFeaturesEnabled() {
        return this.enableDeprecated;
    }

    @Override
    public void setSinceTagsEnabled(boolean enable) {
        this.enableSinceTag = enable;
    }

    @Override
    public boolean isSinceTagsEnabled() {
        return this.enableSinceTag;
    }

    @Override
    public void setVersionTagsEnabled(boolean enable) {
        this.enableVersionTag = enable;
    }

    @Override
    public boolean isVersionTagsEnabled() {
        return this.enableVersionTag;
    }

    @Override
    public void setAuthorTagsEnabled(boolean enable) {
        this.enableAuthorTag = enable;
    }

    @Override
    public boolean isAuthorTagsEnabled() {
        return this.enableAuthorTag;
    }

    @Override
    public void setCopyrightText(String text) {
        this.copyrightText = text;
    }

    @Override
    public String getCopyrightText() {
        return this.copyrightText;
    }

    @Override
    public void setTitle(String text) {
        this.title = text;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void addGroup(String heading, String ... groupPatterns) {
        StringBuilder pat = new StringBuilder();
        for (String groupPattern : groupPatterns) {
            if (pat.length() > 0) {
                pat.append("|");
            }
            String p0 = "(?:" + groupPattern.replaceAll(Pattern.quote("."), "\\\\.").replaceAll(Pattern.quote("*"), ".*") + ")";
            pat.append(p0);
        }
        pat.insert(0, "^(?:");
        pat.append(")$");
        Pattern regex = Pattern.compile(pat.toString());
        this.groups.add((Pair<String, Pattern>)Pair.of((Object)heading, (Object)regex));
    }

    @Override
    public List<Pair<String, Pattern>> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    @Override
    public void setCharset(String name) {
        this.charset = name;
    }

    @Override
    public String getCharset() {
        if (Strings.isNullOrEmpty((String)this.charset)) {
            return Charset.defaultCharset().name();
        }
        return this.charset;
    }
}

