/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.framework;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTreeVisitor;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import io.sarl.docs.doclet2.framework.ElementUtils;
import io.sarl.docs.doclet2.framework.ExternalLinkManager;
import io.sarl.docs.doclet2.framework.TagletManager;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.HtmlAccessor;
import io.sarl.docs.doclet2.html.framework.HtmlFactory;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContentExtractor;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.HtmlTags;
import io.sarl.docs.doclet2.html.framework.Messages;
import io.sarl.docs.doclet2.html.framework.PathBuilder;
import io.sarl.docs.doclet2.html.taglets.SarlTaglet;
import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import jdk.javadoc.doclet.Taglet;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class HtmlFactoryImpl
implements HtmlFactory,
HtmlTags {
    private static final String SPACE = " ";
    private HtmlAccessor accessor;
    private PathBuilder pathBuilder;
    private ElementUtils elementUtils;
    private ExternalLinkManager externalLinkManager;
    private TagletManager tagletManager;
    private SARLGrammarKeywordAccess keywords;
    private long nextId = 1L;
    private long nextTabContentClass = 1L;
    private long nextTabButtonClass = 1L;

    protected String computeId() {
        long id = this.nextId++;
        return "ID" + id;
    }

    protected String computeTabContentClassname() {
        long id = this.nextTabContentClass++;
        return "doclet-tabs-content-instance-" + id;
    }

    protected String computeTabButtonClassname() {
        long id = this.nextTabButtonClass++;
        return "doclet-tabs-button-instance-" + id;
    }

    @Inject
    public void setTagletManager(TagletManager manager) {
        this.tagletManager = manager;
    }

    public TagletManager getTagletManager() {
        return this.tagletManager;
    }

    @Inject
    public void setSARLGrammarKeywordAccess(SARLGrammarKeywordAccess accessor) {
        this.keywords = accessor;
    }

    public SARLGrammarKeywordAccess getSARLGrammarKeywordAccess() {
        return this.keywords;
    }

    @Inject
    public void setExternalLinkManager(ExternalLinkManager manager) {
        this.externalLinkManager = manager;
    }

    public ExternalLinkManager getExternalLinkManager() {
        return this.externalLinkManager;
    }

    @Inject
    public void setElementUtils(ElementUtils utils) {
        this.elementUtils = utils;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }

    @Inject
    public void setHtmlAccessor(HtmlAccessor accessor) {
        this.accessor = accessor;
    }

    public HtmlAccessor getHtmlAccessor() {
        return this.accessor;
    }

    @Inject
    public void setPathBuilder(PathBuilder builder) {
        this.pathBuilder = builder;
    }

    public PathBuilder getPathBuilder() {
        return this.pathBuilder;
    }

    @Override
    public DocumentType createDocumentType(String name, String publicId, String systemId) {
        if (!(Strings.isNullOrEmpty((String)name) || Strings.isNullOrEmpty((String)publicId) || Strings.isNullOrEmpty((String)systemId))) {
            DocumentType type = new DocumentType(name, publicId, systemId);
            return type;
        }
        return null;
    }

    @Override
    public Document createDocument(DocumentType docType, String charset, HtmlFactoryContext context) {
        Element metaTag;
        Document doc = Document.createShell((String)context.getBaseUri());
        if (docType != null) {
            doc.insertChildren(0, new Node[]{docType});
        } else {
            doc.insertChildren(0, new Node[]{new DocumentType("html", "", "")});
        }
        Element htmlTag = this.getHtmlAccessor().getChildNode((Node)doc, "html");
        if (htmlTag == null) {
            htmlTag = doc.appendElement("html");
        }
        htmlTag.attr("lang", "en");
        Element headTag = this.getHtmlAccessor().getChildNode((Node)htmlTag, "head");
        if (headTag == null) {
            headTag = htmlTag.appendElement("head");
        }
        if ((metaTag = this.getHtmlAccessor().getChildNode((Node)headTag, "meta")) == null) {
            metaTag = headTag.appendElement("meta");
        }
        metaTag.attr("charset", Strings.isNullOrEmpty((String)charset) ? Charset.defaultCharset().name() : charset);
        return doc;
    }

    @Override
    public Element createHeadTag(Element parent) {
        if (parent == null) {
            return new Element("head");
        }
        Element child = this.getHtmlAccessor().getChildNode((Node)parent, "head");
        if (child == null) {
            child = parent.appendElement("head");
        }
        return child;
    }

    @Override
    public Element createTitleTag(Element parent, String title) {
        Element child;
        if (parent == null) {
            child = new Element("title");
        } else {
            child = this.getHtmlAccessor().getChildNode((Node)parent, "title");
            if (child == null) {
                child = parent.appendElement("title");
            }
        }
        child.appendText(title);
        return child;
    }

    @Override
    public String path2UrlPath(Path path, String anchor) {
        StringBuilder refPath = new StringBuilder();
        if (path != null) {
            for (Path elt : path) {
                if (refPath.length() > 0) {
                    refPath.append("/");
                }
                refPath.append(elt.toString());
            }
            if (path.isAbsolute()) {
                refPath.insert(0, "/");
            }
        }
        if (!Strings.isNullOrEmpty((String)anchor)) {
            refPath.append("#");
            refPath.append(anchor);
        }
        return refPath.toString();
    }

    @Override
    public Element createCssLinkTag(Element parent, Path cssStyle) {
        Element linkElement = parent == null ? new Element("link") : parent.appendElement("link");
        linkElement.attr("rel", "stylesheet");
        linkElement.attr("href", this.path2UrlPath(cssStyle));
        return linkElement;
    }

    @Override
    public Element createJsLinkTag(Element parent, Path jsScript) {
        Element scriptElement = parent == null ? new Element("script") : parent.appendElement("script");
        scriptElement.attr("src", this.path2UrlPath(jsScript));
        return scriptElement;
    }

    @Override
    public Element createBodyTag(Element parent) {
        Element child;
        if (parent == null) {
            child = new Element("body");
        } else {
            child = this.getHtmlAccessor().getChildNode((Node)parent, "body");
            if (child == null) {
                child = parent.appendElement("body");
            }
        }
        return child;
    }

    @Override
    public Element createFramesetTag(Element parent) {
        Element child = parent == null ? new Element("frameset") : parent.appendElement("frameset");
        return child;
    }

    @Override
    public Element createFrameTag(Element parent) {
        Element child = parent == null ? new Element("frame") : parent.appendElement("frame");
        return child;
    }

    @Override
    public Element createNoFramesTag(Element parent) {
        Element child = parent == null ? new Element("noframes") : parent.appendElement("noframes");
        return child;
    }

    @Override
    public Element createScriptTag(Element parent, String type) {
        Element child = parent == null ? new Element("script") : parent.appendElement("script");
        if (!Strings.isNullOrEmpty((String)type)) {
            child.attr("type", type);
        }
        return child;
    }

    @Override
    public Element createNoScriptTag(Element parent) {
        Element child = parent == null ? new Element("noscript") : parent.appendElement("noscript");
        return child;
    }

    @Override
    public Element createH2Tag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("h2") : parent.appendElement("h2");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createDivTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("div") : parent.appendElement("div");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createParagraphTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("p") : parent.appendElement("p");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createDlTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("dl") : parent.appendElement("dl");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createDtTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("dt") : parent.appendElement("dt");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createDdTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("dd") : parent.appendElement("dd");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createSpanTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("span") : parent.appendElement("span");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createPreTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("pre") : parent.appendElement("pre");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createUlTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("ul") : parent.appendElement("ul");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createLiTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("li") : parent.appendElement("li");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Node createUnsecableSpace(Element parent) {
        if (parent == null) {
            return new DataNode("&nbsp;");
        }
        return parent.append("&nbsp;");
    }

    @Override
    public Node createSecableSpace(Element parent) {
        if (parent == null) {
            return new TextNode(SPACE);
        }
        return parent.appendText(SPACE);
    }

    @Deprecated(since="0.15", forRemoval=true)
    protected final void appendChildren(Element parent, Node child) {
        this.appendChild(parent, child);
    }

    protected void appendChild(Element parent, Node child) {
        assert (parent != null) : "parent argument must not be null";
        assert (child != null) : "child argument must not be null";
        if (HtmlTags.isPseudoTag(child.nodeName()) && child instanceof Element) {
            for (Node chld : child.childNodes()) {
                parent.appendChild(chld.clone());
            }
        } else {
            parent.appendChild(child.clone());
        }
    }

    protected void appendChildren(Element parent, Iterable<? extends Node> children) {
        assert (parent != null) : "parent argument must not be null";
        assert (children != null) : "children argument must not be null";
        for (Node node : children) {
            if (node == null) continue;
            this.appendChild(parent, node);
        }
    }

    @Override
    public List<Node> createLink(Path path, String anchor, List<Node> label, CssStyles style) {
        Element tag = new Element("a");
        tag.attr("href", this.path2UrlPath(path, anchor));
        this.appendChildren(tag, label);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public List<Node> createLink(Path path, String anchor, String label, CssStyles style) {
        Element tag = new Element("a");
        tag.attr("href", this.path2UrlPath(path, anchor));
        tag.appendText(label);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public List<Node> createLink(URL path, List<Node> label, CssStyles style) {
        Element tag = new Element("a");
        tag.attr("href", path.toExternalForm());
        this.appendChildren(tag, label);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public List<Node> createLink(URL path, String label, CssStyles style) {
        Element tag = new Element("a");
        tag.attr("href", path.toExternalForm());
        tag.appendText(label);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public List<Node> createModuleLink(ModuleElement module, List<Node> label, CssStyles style, HtmlFactoryContext context) {
        boolean included = context.getEnvironment().isIncluded(module);
        if (included) {
            Path modulePath = this.getPathBuilder().moduleSummary(module);
            Path linkModulePath = context.getPathToRoot().resolve(modulePath);
            return this.createLink(linkModulePath, label, style);
        }
        return label;
    }

    @Override
    public List<Node> createModuleLink(ModuleElement module, String label, CssStyles style, HtmlFactoryContext context) {
        boolean included = context.getEnvironment().isIncluded(module);
        if (included) {
            String rlabel = label == null || label.isBlank() ? Messages.HtmlFactoryImpl_0 : label;
            Path modulePath = this.getPathBuilder().moduleSummary(module);
            Path linkModulePath = context.getPathToRoot().resolve(modulePath);
            return this.createLink(linkModulePath, rlabel, style);
        }
        return new ArrayList<Node>();
    }

    @Override
    public List<Node> createPackageLink(PackageElement pkg, List<Node> label, CssStyles style, HtmlFactoryContext context) {
        boolean included = context.getEnvironment().isIncluded(pkg);
        if (included) {
            Path packagePath = this.getPathBuilder().packageSummary(pkg);
            Path linkPackagePath = context.getPathToRoot().resolve(packagePath);
            return this.createLink(linkPackagePath, label, style);
        }
        return label;
    }

    @Override
    public List<Node> createPackageLink(PackageElement pkg, String label, CssStyles style, HtmlFactoryContext context) {
        boolean included = context.getEnvironment().isIncluded(pkg);
        if (included) {
            String rlabel = label == null || label.isBlank() ? Messages.HtmlFactoryImpl_1 : label;
            Path packagePath = this.getPathBuilder().packageSummary(pkg);
            Path linkPackagePath = context.getPathToRoot().resolve(packagePath);
            return this.createLink(linkPackagePath, rlabel, style);
        }
        return new ArrayList<Node>();
    }

    @Override
    public List<Node> createTypeLink(TypeElement element, String anchor, List<Node> label, CssStyles style, HtmlFactoryContext context) {
        if (this.getElementUtils().isExternal(element, context.getEnvironment())) {
            URL externalLink = this.getExternalLinkManager().getExternalURL(element, anchor, context);
            if (externalLink != null) {
                return this.createLink(externalLink, label, style);
            }
        } else {
            if (context.getEnvironment().isIncluded(element)) {
                Path typePath = this.getPathBuilder().typeIndex(element);
                Path linkTypePath = context.getPathToRoot().resolve(typePath);
                return this.createLink(linkTypePath, anchor, label, style);
            }
            context.getReporter().print(Diagnostic.Kind.MANDATORY_WARNING, MessageFormat.format(Messages.HtmlFactoryImpl_12, element.getQualifiedName().toString()));
        }
        Element tag = new Element("span");
        this.appendChildren(tag, label);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public List<Node> createTypeLink(TypeElement element, String anchor, List<Node> linkLabel, Node rawLabel, CssStyles style, HtmlFactoryContext context) {
        if (this.getElementUtils().isExternal(element, context.getEnvironment())) {
            URL externalLink = this.getExternalLinkManager().getExternalURL(element, anchor, context);
            if (externalLink != null) {
                return this.createLink(externalLink, linkLabel, style);
            }
        } else {
            if (context.getEnvironment().isIncluded(element)) {
                Path typePath = this.getPathBuilder().typeIndex(element);
                Path linkTypePath = context.getPathToRoot().resolve(typePath);
                return this.createLink(linkTypePath, anchor, linkLabel, style);
            }
            context.getReporter().print(Diagnostic.Kind.MANDATORY_WARNING, MessageFormat.format(Messages.HtmlFactoryImpl_12, element.getQualifiedName().toString()));
        }
        Element tag = new Element("span");
        this.appendChildren(tag, rawLabel);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public List<Node> createTypeLink(TypeElement element, String anchor, String linkLabel, String rawLabel, CssStyles style, HtmlFactoryContext context) {
        if (this.getElementUtils().isExternal(element, context.getEnvironment())) {
            URL externalLink = this.getExternalLinkManager().getExternalURL(element, anchor, context);
            if (externalLink != null) {
                return this.createLink(externalLink, linkLabel, style);
            }
        } else {
            if (context.getEnvironment().isIncluded(element)) {
                Path typePath = this.getPathBuilder().typeIndex(element);
                Path linkTypePath = context.getPathToRoot().resolve(typePath);
                return this.createLink(linkTypePath, anchor, linkLabel, style);
            }
            context.getReporter().print(Diagnostic.Kind.MANDATORY_WARNING, MessageFormat.format(Messages.HtmlFactoryImpl_12, element.getQualifiedName().toString()));
        }
        Element tag = new Element("span");
        tag.appendText(rawLabel);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public List<Node> createTypeLink(TypeMirror type, String anchor, List<Node> label, CssStyles style, HtmlFactoryContext context) {
        List<Node> baseType = this.filterType(type);
        if (baseType != null) {
            return baseType;
        }
        TypeElement element = this.getElementUtils().asTypeElement(type, context.getEnvironment().getTypeUtils());
        if (element == null) {
            ArrayList<Node> list = new ArrayList<Node>();
            list.add((Node)new TextNode(type.toString()));
            return list;
        }
        return this.createTypeLink(element, anchor, label, style, context);
    }

    @Override
    public List<Node> createTypeLink(TypeMirror type, String anchor, String label, CssStyles style, HtmlFactoryContext context) {
        List<Node> baseType = this.filterType(type);
        if (baseType != null) {
            return baseType;
        }
        TypeElement element = this.getElementUtils().asTypeElement(type, context.getEnvironment().getTypeUtils());
        if (element == null) {
            ArrayList<Node> list = new ArrayList<Node>();
            list.add((Node)new TextNode(type.toString()));
            return list;
        }
        return this.createTypeLink(element, anchor, label, label, style, context);
    }

    @Override
    public List<Node> createTypeLink(TypeElement element, String anchor, boolean addTypeParameters, CssStyles style, HtmlFactoryContext context) {
        List<Node> link = this.createTypeLink(element, anchor, element.getSimpleName().toString(), element.getQualifiedName().toString(), style, context);
        if (addTypeParameters) {
            this.addTypeParameters(element, link);
        }
        return link;
    }

    private void addTypeParameters(TypeElement element, List<? super Node> link) {
        if (!element.getTypeParameters().isEmpty()) {
            link.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getLessThanSignKeyword()));
            boolean first = true;
            for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
                if (first) {
                    first = false;
                } else {
                    link.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getCommaKeyword()));
                }
                link.add((Node)new TextNode(typeParameterElement.getSimpleName().toString()));
            }
            link.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getGreaterThanSignKeyword()));
        }
    }

    private static boolean isVoidType(TypeMirror type) {
        return type == null || type.getKind() == TypeKind.VOID || type.getKind() == TypeKind.NULL;
    }

    private List<Node> filterType(TypeMirror type) {
        if (HtmlFactoryImpl.isVoidType(type)) {
            ArrayList<Node> list = new ArrayList<Node>();
            list.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getVoidKeyword()));
            return list;
        }
        if (type.getKind().isPrimitive() || type.getKind() == TypeKind.TYPEVAR) {
            ArrayList<Node> list = new ArrayList<Node>();
            list.add((Node)new TextNode(type.toString()));
            return list;
        }
        return null;
    }

    @Override
    public List<Node> createTypeLink(TypeMirror type, String anchor, boolean addTypeParameters, CssStyles style, HtmlFactoryContext context) {
        List<Node> baseType = this.filterType(type);
        if (baseType != null) {
            return baseType;
        }
        TypeElement element = this.getElementUtils().asTypeElement(type, context.getEnvironment().getTypeUtils());
        if (element == null) {
            ArrayList<Node> list = new ArrayList<Node>();
            list.add((Node)new TextNode(type.toString()));
            return list;
        }
        return this.createTypeLink(element, anchor, addTypeParameters, style, context);
    }

    @Override
    public String toVariableAnchor(VariableElement element) {
        return element.getSimpleName().toString();
    }

    @Override
    public List<Node> createVariableLink(VariableElement variable, List<Node> label, CssStyles style, HtmlFactoryContext context) {
        String anchorName = this.toVariableAnchor(variable);
        if (this.getElementUtils().isExternal(variable, context.getEnvironment())) {
            URL externalLink = this.getExternalLinkManager().getExternalURL(variable.getEnclosingElement(), anchorName, context);
            if (externalLink != null) {
                return this.createLink(externalLink, label, style);
            }
        } else {
            if (context.getEnvironment().isIncluded(variable)) {
                Path typePath = this.getPathBuilder().typeIndex((TypeElement)variable.getEnclosingElement());
                Path linkTypePath = context.getPathToRoot().resolve(typePath);
                return this.createLink(linkTypePath, anchorName, label, style);
            }
            context.getReporter().print(Diagnostic.Kind.MANDATORY_WARNING, MessageFormat.format(Messages.HtmlFactoryImpl_12, this.getElementUtils().getFullyQualifiedName(variable, true)));
        }
        Element tag = new Element("span");
        tag.appendChildren(label);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public List<Node> createVariableLink(VariableElement variable, String label, CssStyles style, HtmlFactoryContext context) {
        String anchorName = this.toVariableAnchor(variable);
        if (this.getElementUtils().isExternal(variable, context.getEnvironment())) {
            URL externalLink = this.getExternalLinkManager().getExternalURL(variable.getEnclosingElement(), anchorName, context);
            if (externalLink != null) {
                return this.createLink(externalLink, label, style);
            }
        } else {
            if (context.getEnvironment().isIncluded(variable)) {
                Path typePath = this.getPathBuilder().typeIndex((TypeElement)variable.getEnclosingElement());
                Path linkTypePath = context.getPathToRoot().resolve(typePath);
                return this.createLink(linkTypePath, anchorName, label, style);
            }
            context.getReporter().print(Diagnostic.Kind.MANDATORY_WARNING, MessageFormat.format(Messages.HtmlFactoryImpl_12, this.getElementUtils().getFullyQualifiedName(variable, true)));
        }
        Element tag = new Element("span");
        tag.appendText(label);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public String toExecutableAnchor(ExecutableElement element) {
        String simpleName = element.getSimpleName().toString();
        String parameters = HtmlFactoryImpl.toFlatParameterList(element.getParameters());
        StringBuilder buf = new StringBuilder();
        buf.append(simpleName);
        buf.append("(");
        buf.append(parameters);
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String toEventHandlerAnchor(ExecutableElement element) {
        String simpleName = element.getSimpleName().toString();
        String parameters = HtmlFactoryImpl.toFlatParameterList(element.getParameters());
        StringBuilder buf = new StringBuilder();
        buf.append(simpleName);
        buf.append("(");
        buf.append(parameters);
        buf.append(")");
        return buf.toString();
    }

    private static String toFlatParameterList(List<? extends VariableElement> parameters) {
        StringBuilder buf = new StringBuilder();
        for (VariableElement variableElement : parameters) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(variableElement.asType().toString());
        }
        return buf.toString();
    }

    @Override
    public List<Node> createExecutableLink(ExecutableElement executable, List<Node> label, CssStyles style, HtmlFactoryContext context) {
        String anchorName = this.toExecutableAnchor(executable);
        if (this.getElementUtils().isExternal(executable, context.getEnvironment())) {
            URL externalLink = this.getExternalLinkManager().getExternalURL(executable.getEnclosingElement(), anchorName, context);
            if (externalLink != null) {
                return this.createLink(externalLink, label, style);
            }
        } else {
            if (context.getEnvironment().isIncluded(executable)) {
                Path typePath = this.getPathBuilder().typeIndex((TypeElement)executable.getEnclosingElement());
                Path linkTypePath = context.getPathToRoot().resolve(typePath);
                return this.createLink(linkTypePath, anchorName, label, style);
            }
            context.getReporter().print(Diagnostic.Kind.MANDATORY_WARNING, MessageFormat.format(Messages.HtmlFactoryImpl_12, this.getElementUtils().getFullyQualifiedName(executable, true)));
        }
        Element tag = new Element("span");
        tag.appendChildren(label);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public List<Node> createExecutableLink(ExecutableElement executable, String label, CssStyles style, HtmlFactoryContext context) {
        String anchorName = this.toExecutableAnchor(executable);
        if (this.getElementUtils().isExternal(executable, context.getEnvironment())) {
            URL externalLink = this.getExternalLinkManager().getExternalURL(executable.getEnclosingElement(), anchorName, context);
            if (externalLink != null) {
                return this.createLink(externalLink, label, style);
            }
        } else {
            if (context.getEnvironment().isIncluded(executable)) {
                Path typePath = this.getPathBuilder().typeIndex((TypeElement)executable.getEnclosingElement());
                Path linkTypePath = context.getPathToRoot().resolve(typePath);
                return this.createLink(linkTypePath, anchorName, label, style);
            }
            context.getReporter().print(Diagnostic.Kind.MANDATORY_WARNING, MessageFormat.format(Messages.HtmlFactoryImpl_12, this.getElementUtils().getFullyQualifiedName(executable, true)));
        }
        Element tag = new Element("span");
        tag.appendText(label);
        if (style != null) {
            tag.addClass(style.getCssClassname());
        }
        ArrayList<Node> list = new ArrayList<Node>();
        list.add((Node)tag);
        return list;
    }

    @Override
    public Element createTypeInheritanceTree(Element parent, TypeMirror type, CssStyles listStyle, CssStyles elementStyle, HtmlFactoryContext context) {
        assert (parent != null) : "parent argument must not be null";
        LinkedList<TypeMirror> sequence = new LinkedList<TypeMirror>();
        sequence.add(type);
        TypeMirror sup = type;
        do {
            TypeElement typeElement = this.getElementUtils().asTypeElement(sup, context.getEnvironment().getTypeUtils());
            sup = this.getElementUtils().getFirstVisibleSuperType(typeElement, typeElement.getKind() == ElementKind.CLASS, context.getEnvironment());
            if (sup == null) continue;
            sequence.addFirst(sup);
        } while (sup != null);
        Element supElement = parent;
        Element rootElement = null;
        for (TypeMirror type0 : sequence) {
            Element ulElement = this.createUlTag(supElement, listStyle);
            if (rootElement == null) {
                rootElement = ulElement;
            }
            Element liElement = this.createLiTag(ulElement, listStyle);
            this.appendChildren(liElement, this.createTypeLink(type0, false, elementStyle, context));
            supElement = liElement;
        }
        return rootElement;
    }

    @Override
    public List<Element> getAnnotationsFor(int indent, List<? extends AnnotationMirror> descList, boolean lineBreak, CssStyles style, CssStyles valueStyle, HtmlFactoryContext context) {
        ArrayList<Element> results = new ArrayList<Element>();
        for (AnnotationMirror annotationMirror : descList) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!this.getElementUtils().isDocumentedAnnotation(annotationElement)) continue;
            Element htmlElement = new Element("span");
            if (style != null) {
                htmlElement.addClass(style.getCssClassname());
            }
            List<Node> annotationLink = this.createTypeLink(annotationElement, false, style, context);
            Map<? extends ExecutableElement, ? extends AnnotationValue> pairs = annotationMirror.getElementValues();
            if (this.getElementUtils().isSynthetized(annotationMirror)) {
                for (final AnnotationValue annotationValue : pairs.values()) {
                    ArrayList annotationTypeValues = new ArrayList();
                    new SimpleAnnotationValueVisitor9<Void, List<AnnotationValue>>(this){

                        @Override
                        public Void visitArray(List<? extends AnnotationValue> vals, List<AnnotationValue> p) {
                            p.addAll(vals);
                            return null;
                        }

                        @Override
                        protected Void defaultAction(Object o, List<AnnotationValue> p) {
                            p.add(annotationValue);
                            return null;
                        }
                    }.visit(annotationValue, annotationTypeValues);
                    Element valueElement = this.createSpanTag(htmlElement, valueStyle);
                    boolean first = true;
                    for (AnnotationValue av : annotationTypeValues) {
                        if (first) {
                            first = false;
                        } else {
                            valueElement.appendText(SPACE);
                        }
                        this.annotationValueToContent(valueElement, av, valueStyle, context);
                    }
                }
            } else {
                boolean isArray = this.getElementUtils().isAnnotationArray(pairs);
                this.addAnnotations(annotationElement, annotationLink, htmlElement, pairs, indent, !isArray && lineBreak, valueStyle, context);
            }
            if (lineBreak) {
                this.appendChild(htmlElement, (Node)this.createNewLineTag());
            }
            results.add(htmlElement);
        }
        return results;
    }

    private void addAnnotations(TypeElement annotationElement, List<Node> annotationLink, Element annotation, Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValues, int indent, boolean lineBreak, CssStyles valueStyle, HtmlFactoryContext context) {
        annotation.appendText(this.getSARLGrammarKeywordAccess().getCommercialAtKeyword());
        this.appendChildren(annotation, annotationLink);
        if (!annotationValues.isEmpty()) {
            Element valueElement = this.createSpanTag(annotation, valueStyle);
            valueElement.appendText("(");
            boolean first = true;
            boolean multipleValues = annotationValues.size() > 1;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> valuePair : annotationValues.entrySet()) {
                boolean multipleTypeValues;
                if (first) {
                    first = false;
                } else {
                    valueElement.appendText(",");
                    if (lineBreak) {
                        this.appendChild(valueElement, (Node)this.createNewLineTag());
                        int spaces = annotationElement.getSimpleName().length() + 2;
                        for (int k = 0; k < spaces + indent; ++k) {
                            valueElement.appendText(SPACE);
                        }
                    }
                }
                String simpleName = valuePair.getKey().getSimpleName().toString();
                if (multipleValues || !"value".equals(simpleName)) {
                    valueElement.appendText(simpleName);
                    valueElement.appendText("=");
                }
                final ArrayList annotationTypeValues = new ArrayList();
                new SimpleAnnotationValueVisitor9<Void, AnnotationValue>(this){

                    @Override
                    public Void visitArray(List<? extends AnnotationValue> vals, AnnotationValue p) {
                        annotationTypeValues.addAll(vals);
                        return null;
                    }

                    @Override
                    protected Void defaultAction(Object o, AnnotationValue p) {
                        annotationTypeValues.add(p);
                        return null;
                    }
                }.visit(valuePair.getValue(), valuePair.getValue());
                boolean bl = multipleTypeValues = annotationTypeValues.size() > 1;
                if (multipleTypeValues) {
                    valueElement.appendText("{");
                }
                boolean first0 = true;
                for (AnnotationValue av : annotationTypeValues) {
                    if (first0) {
                        first0 = false;
                    } else {
                        valueElement.appendText(",");
                    }
                    this.annotationValueToContent(valueElement, av, valueStyle, context);
                }
                if (!multipleTypeValues) continue;
                valueElement.appendText("}");
            }
            valueElement.appendText(")");
        }
    }

    private void annotationValueToContent(final Element output, final AnnotationValue annotationValue, final CssStyles valueStyle, final HtmlFactoryContext context) {
        new SimpleAnnotationValueVisitor9<Void, Void>(){

            @Override
            public Void visitType(final TypeMirror t, Void p) {
                new SimpleTypeVisitor9<Void, Void>(){

                    @Override
                    public Void visitDeclared(DeclaredType t2, Void p) {
                        List<Node> linkElement = HtmlFactoryImpl.this.createTypeLink((TypeMirror)t2, false, valueStyle, context);
                        HtmlFactoryImpl.this.appendChildren(output, linkElement);
                        output.appendText(HtmlFactoryImpl.this.getElementUtils().getDimension(t2));
                        return null;
                    }

                    @Override
                    protected Void defaultAction(TypeMirror e, Void p) {
                        List<Node> linkElement = HtmlFactoryImpl.this.createTypeLink(t, false, valueStyle, context);
                        HtmlFactoryImpl.this.appendChildren(output, linkElement);
                        output.appendText(HtmlFactoryImpl.this.getElementUtils().getDimension(t));
                        return null;
                    }
                }.visit(t);
                return null;
            }

            @Override
            public Void visitAnnotation(AnnotationMirror a, Void p) {
                for (Element c : HtmlFactoryImpl.this.getAnnotationsFor(0, Collections.singletonList(a), false, valueStyle, valueStyle, context)) {
                    HtmlFactoryImpl.this.appendChild(output, (Node)c);
                }
                return null;
            }

            @Override
            public Void visitEnumConstant(VariableElement c, Void p) {
                output.appendText(c.getSimpleName().toString());
                return null;
            }

            @Override
            public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
                boolean first = true;
                for (AnnotationValue annotationValue2 : vals) {
                    if (first) {
                        first = false;
                    } else {
                        output.appendText(HtmlFactoryImpl.SPACE);
                    }
                    this.visit(annotationValue2);
                }
                return null;
            }

            @Override
            protected Void defaultAction(Object o, Void p) {
                output.appendText(annotationValue.toString());
                return null;
            }
        }.visit(annotationValue);
    }

    @Override
    public Element createNewLineTag() {
        return new Element("br");
    }

    @Override
    public HtmlFactory.CommentTextMemory createCommentTextMemory(Element parent, javax.lang.model.element.Element element, HtmlFactoryContext context) {
        assert (parent != null) : "parent argument must not be null";
        return new CommentTextMemoryImpl(parent, element, context);
    }

    @Override
    public boolean createCommentText(HtmlFactory.CommentTextMemory memory, DocTree documentationTree, CssStyles style) {
        TextContentExtractor visitor = new TextContentExtractor(memory, documentationTree, style);
        documentationTree.accept(visitor, null);
        memory.collapseStack();
        return memory.hasDocumentationText();
    }

    private static String normalizeNewlines(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int textLength = text.length();
        String NL = "br";
        int pos = 0;
        block4: for (int i = 0; i < textLength; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append(text, pos, i);
                    sb.append("br");
                    pos = i + 1;
                    continue block4;
                }
                case '\r': {
                    sb.append(text, pos, i);
                    sb.append("br");
                    if (i + 1 < textLength && text.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    pos = i + 1;
                    continue block4;
                }
            }
        }
        sb.append(text, pos, textLength);
        return sb.toString();
    }

    @Override
    public Element createCodeTag(Element parent, String content) {
        String ncontent = HtmlFactoryImpl.normalizeNewlines(content);
        Element elt = parent == null ? new Element("code") : parent.appendElement("code");
        elt.appendText(ncontent);
        return elt;
    }

    @Override
    public Element createTableTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("table") : parent.appendElement("table");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createTableHeaderTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("thead") : parent.appendElement("thead");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createTableBodyTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("tbody") : parent.appendElement("tbody");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createTableRowTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("tr") : parent.appendElement("tr");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createTableCellTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("td") : parent.appendElement("td");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Element createTableColumnHeadTag(Element parent, CssStyles style) {
        Element elt = parent == null ? new Element("th") : parent.appendElement("th");
        if (style != null) {
            elt.addClass(style.getCssClassname());
        }
        return elt;
    }

    @Override
    public Comment createHtmlComment(Element parent, String text) {
        Comment cmt = new Comment(Strings.nullToEmpty((String)text));
        if (parent != null) {
            parent.appendChild((Node)cmt);
        }
        return cmt;
    }

    @Override
    public HtmlFactory.HtmlTabsFactory createTabBox(CssStyles titleStyle, CssStyles contentStyle) {
        return new HtmlTabsFactoryImpl(titleStyle, contentStyle);
    }

    @Override
    public Element keyword(Element receiver, String keyword) {
        Element kw = this.createSpanTag(receiver, CssStyles.KEYWORD).appendText(keyword);
        if (receiver == null) {
            return kw;
        }
        return receiver;
    }

    @Override
    public List<Node> getExecutablePrototype(ExecutableElement element, String name, HtmlFactoryContext context) {
        List<TextNode> realName;
        if (Strings.isNullOrEmpty((String)name)) {
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                Element realName0 = this.keyword(null, this.getSARLGrammarKeywordAccess().getNewKeyword());
                realName = Collections.singletonList(realName0);
            } else {
                realName = Collections.singletonList(new TextNode(element.getSimpleName().toString()));
            }
        } else {
            realName = Collections.singletonList(new TextNode(name));
        }
        return this.getExecutablePrototype(element, realName, context);
    }

    @Override
    public List<Node> getExecutablePrototype(ExecutableElement element, List<Node> name, HtmlFactoryContext context) {
        ArrayList<Node> prototype = new ArrayList<Node>();
        prototype.addAll(name);
        List<? extends VariableElement> parameters = element.getParameters();
        if (!parameters.isEmpty()) {
            prototype.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getLeftParenthesisKeyword()));
            for (int i = 0; i < parameters.size(); ++i) {
                if (i > 0) {
                    prototype.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getCommaKeyword()));
                }
                boolean isVararg = element.isVarArgs() && i == parameters.size() - 1;
                boolean isOptional = !isVararg && parameters.get(i).getAnnotation(DefaultValue.class) != null;
                TypeMirror type = parameters.get(i).asType();
                if (isOptional) {
                    prototype.add((Node)new TextNode("["));
                }
                if (isVararg && type instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)type;
                    TypeMirror componentType = arrayType.getComponentType();
                    TypeElement componentTypeElement = this.getElementUtils().asTypeElement(componentType, context.getEnvironment().getTypeUtils());
                    prototype.add((Node)new TextNode(componentTypeElement.getSimpleName().toString()));
                    this.addTypeParameters(componentTypeElement, prototype);
                } else if (type.getKind().isPrimitive() || type.getKind() == TypeKind.TYPEVAR) {
                    prototype.add((Node)new TextNode(type.toString()));
                } else {
                    TypeElement typeElement = this.getElementUtils().asTypeElement(type, context.getEnvironment().getTypeUtils());
                    if (typeElement != null) {
                        prototype.add((Node)new TextNode(typeElement.getSimpleName().toString()));
                        this.addTypeParameters(typeElement, prototype);
                    } else {
                        prototype.add((Node)new TextNode(type.toString()));
                    }
                }
                if (isVararg) {
                    prototype.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getWildcardAsteriskKeyword()));
                    continue;
                }
                if (!isOptional) continue;
                prototype.add((Node)new TextNode("]"));
            }
            prototype.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getRightParenthesisKeyword()));
        }
        return prototype;
    }

    @Override
    public void addLinkTargetFrame(List<? extends Node> link, String target) {
        if (!Strings.isNullOrEmpty((String)target)) {
            for (Node node : link) {
                if (!"a".equalsIgnoreCase(node.nodeName()) || !(node instanceof Element)) continue;
                Element element = (Element)node;
                element.attr("target", target);
            }
        }
    }

    protected class CommentTextMemoryImpl
    implements HtmlFactory.CommentTextMemory {
        private final LinkedList<StackElement> stack = new LinkedList();
        private final AtomicBoolean changed = new AtomicBoolean();
        private final Element parent;
        private final HtmlFactoryContext context;
        private final javax.lang.model.element.Element element;

        public CommentTextMemoryImpl(Element parent, javax.lang.model.element.Element element, HtmlFactoryContext context) {
            this.parent = parent;
            this.element = element;
            this.context = context;
            this.pushElement(this.parent.tagName(), (Node)this.parent);
        }

        @Override
        public Element getRootParent() {
            return this.parent;
        }

        @Override
        public HtmlFactoryContext getContext() {
            return this.context;
        }

        @Override
        public javax.lang.model.element.Element getElement() {
            return this.element;
        }

        @Override
        public void pushElement(String name, Node element) {
            this.stack.addFirst(new StackElement(name, element));
        }

        @Override
        public void pushElement(String name, TypeElement element) {
            this.stack.addFirst(new StackElement(name, element));
        }

        @Override
        public void pushElement(String name, VariableElement element) {
            this.stack.addFirst(new StackElement(name, element));
        }

        @Override
        public void pushElement(String name, ExecutableElement element) {
            this.stack.addFirst(new StackElement(name, element));
        }

        @Override
        public Element getTop() {
            StackElement top = this.stack.getFirst();
            Node node = top.node;
            if (node instanceof Element) {
                Element cvalue = (Element)node;
                return cvalue;
            }
            return null;
        }

        public StackElement removeTo(String key) {
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                StackElement elt = (StackElement)iterator.next();
                iterator.remove();
                if (!key.equals(elt.name)) continue;
                return elt;
            }
            return null;
        }

        @Override
        public void removeTo(Node element) {
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                StackElement elt = (StackElement)iterator.next();
                iterator.remove();
                if (element != elt.node) continue;
                return;
            }
        }

        @Override
        public void removeUntil(String key) {
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                StackElement elt = (StackElement)iterator.next();
                if (key.equals(elt.name)) {
                    iterator.remove();
                    continue;
                }
                return;
            }
        }

        @Override
        public void changeDocumentationText() {
            this.changed.set(true);
        }

        @Override
        public boolean hasDocumentationText() {
            return this.changed.get();
        }

        @Override
        public void collapseStack() {
            StackElement stackElement;
            if (!this.stack.isEmpty() && (stackElement = this.stack.getFirst()) != null && HtmlTags.REFERENCE_PSEUDO_TAG.equals(stackElement.name)) {
                this.stack.removeFirst();
                Element top = this.getTop();
                if (top != null) {
                    String basename;
                    List<Node> label;
                    ExecutableElement executable;
                    List<Node> list;
                    if (stackElement.typeElement != null) {
                        List<Node> list2 = HtmlFactoryImpl.this.createTypeLink(stackElement.typeElement, true, null, this.context);
                        if (!list2.isEmpty()) {
                            this.changed.set(true);
                            top.appendChildren(list2);
                        }
                    } else if (stackElement.variableElement != null) {
                        VariableElement variable = stackElement.variableElement;
                        List<Node> list3 = HtmlFactoryImpl.this.createVariableLink(variable, variable.getSimpleName().toString(), null, this.context);
                        if (!list3.isEmpty()) {
                            this.changed.set(true);
                            top.appendChildren(list3);
                        }
                    } else if (stackElement.executableElement != null && !(list = HtmlFactoryImpl.this.createExecutableLink(executable = stackElement.executableElement, label = HtmlFactoryImpl.this.getExecutablePrototype(executable, basename = this.element.getKind() == ElementKind.CONSTRUCTOR ? HtmlFactoryImpl.this.getSARLGrammarKeywordAccess().getNewKeyword() : this.element.getSimpleName().toString(), this.context), null, this.context)).isEmpty()) {
                        this.changed.set(true);
                        top.appendChildren(list);
                    }
                }
            }
        }
    }

    protected class TextContentExtractor
    implements DocTreeVisitor<Void, Void>,
    HtmlFactoryContentExtractor {
        private final DocTree elementDocumentation;
        private final CssStyles cssStyle;
        private final HtmlFactory.CommentTextMemory memory;

        protected TextContentExtractor(HtmlFactory.CommentTextMemory memory, DocTree elementDocumentation, CssStyles style) {
            this.memory = memory;
            this.elementDocumentation = elementDocumentation;
            this.cssStyle = style;
        }

        @Override
        public HtmlFactoryContext getContext() {
            return this.memory.getContext();
        }

        @Override
        public Element extractSimpleText(List<? extends DocTree> text) {
            Element lblElement = new Element(HtmlTags.HIDDEN_PSEUDO_TAG);
            if (text != null) {
                this.memory.pushElement(HtmlTags.HIDDEN_PSEUDO_TAG, (Node)lblElement);
                this.groupAccept(text);
                this.memory.removeTo((Node)lblElement);
            }
            return lblElement;
        }

        @Override
        public javax.lang.model.element.Element extractReferencedElement(DocTree docNode) {
            StackElement stackElement = this.extractReferencedElement(docNode, () -> docNode.accept(this, null));
            if (stackElement != null) {
                if (stackElement.typeElement != null) {
                    return stackElement.typeElement;
                }
                if (stackElement.variableElement != null) {
                    return stackElement.variableElement;
                }
                if (stackElement.executableElement != null) {
                    return stackElement.executableElement;
                }
            }
            return null;
        }

        private StackElement extractReferencedElement(DocTree docNode, Procedures.Procedure0 callback) {
            Element defaultNode = new Element(HtmlTags.REFERENCE_PSEUDO_TAG);
            this.memory.pushElement(HtmlTags.REFERENCE_PSEUDO_TAG, (Node)defaultNode);
            callback.apply();
            StackElement stackElement = ((CommentTextMemoryImpl)this.memory).removeTo(HtmlTags.REFERENCE_PSEUDO_TAG);
            this.memory.removeUntil(HtmlTags.REFERENCE_PSEUDO_TAG);
            return stackElement;
        }

        @Override
        public List<Node> extractReference(DocTree docNode, List<Node> label, boolean isplain) {
            return this.extractReference(docNode, label, isplain, () -> docNode.accept(this, null));
        }

        private List<Node> extractReference(DocTree docNode, List<Node> label, boolean isplain, Procedures.Procedure0 callback) {
            StackElement stackElement = this.extractReferencedElement(docNode, callback);
            CssStyles theStyle = isplain ? null : this.cssStyle;
            String innerLabel = null;
            if (stackElement != null) {
                if (stackElement.typeElement != null) {
                    if (label == null) {
                        return HtmlFactoryImpl.this.createTypeLink(stackElement.typeElement, false, theStyle, this.getContext());
                    }
                    return HtmlFactoryImpl.this.createTypeLink(stackElement.typeElement, label, theStyle, this.getContext());
                }
                if (stackElement.variableElement != null) {
                    if (label == null) {
                        return HtmlFactoryImpl.this.createVariableLink(stackElement.variableElement, stackElement.variableElement.getSimpleName().toString(), theStyle, this.getContext());
                    }
                    return HtmlFactoryImpl.this.createVariableLink(stackElement.variableElement, label, theStyle, this.getContext());
                }
                if (stackElement.executableElement != null) {
                    if (label == null) {
                        List<Node> defaultLabel = HtmlFactoryImpl.this.getExecutablePrototype(stackElement.executableElement, this.getContext());
                        return HtmlFactoryImpl.this.createExecutableLink(stackElement.executableElement, defaultLabel, theStyle, this.getContext());
                    }
                    return HtmlFactoryImpl.this.createExecutableLink(stackElement.executableElement, label, theStyle, this.getContext());
                }
                if (stackElement.node != null) {
                    Node node = stackElement.node;
                    if (node instanceof TextNode) {
                        TextNode cvalue = (TextNode)node;
                        innerLabel = cvalue.getWholeText().trim();
                    } else {
                        Element elt;
                        node = stackElement.node;
                        innerLabel = node instanceof Element ? (HtmlTags.isPseudoTag((elt = (Element)node).tagName()) ? elt.wholeText().trim() : stackElement.node.toString().trim()) : stackElement.node.toString().trim();
                    }
                    if (innerLabel.startsWith("\"")) {
                        int index = innerLabel.lastIndexOf(34);
                        if (index >= 2 && !Strings.isNullOrEmpty((String)(innerLabel = innerLabel.substring(1, index)))) {
                            try {
                                URL url = new URI(innerLabel).toURL();
                                if (label == null) {
                                    return HtmlFactoryImpl.this.createLink(url, url.toString(), theStyle);
                                }
                                return HtmlFactoryImpl.this.createLink(url, label, theStyle);
                            }
                            catch (Throwable throwable) {}
                        }
                    } else {
                        ArrayList<Node> list;
                        if (innerLabel.startsWith("<")) {
                            list = new ArrayList<Node>();
                            list.add((Node)new TextNode(innerLabel));
                            return list;
                        }
                        list = new ArrayList();
                        list.add(stackElement.node);
                        return list;
                    }
                }
            }
            this.getContext().getReporter().print(Diagnostic.Kind.WARNING, MessageFormat.format(Messages.HtmlFactoryImpl_4, docNode.toString(), HtmlFactoryImpl.this.getElementUtils().getFullIdentifier(this.memory.getElement())));
            if (label != null) {
                return label;
            }
            if (innerLabel != null) {
                ArrayList<Node> list = new ArrayList<Node>();
                list.add((Node)new TextNode(innerLabel));
                return list;
            }
            ArrayList<Node> list = new ArrayList<Node>();
            list.add((Node)new TextNode(""));
            return list;
        }

        private void groupAccept(List<? extends DocTree> docContent) {
            for (DocTree docTree : docContent) {
                docTree.accept(this, null);
            }
        }

        private Void errorAction(String tagName, DocTree node) {
            this.memory.changeDocumentationText();
            Element top = this.memory.getTop();
            top.appendText(node.toString());
            this.getContext().getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.HtmlFactoryImpl_10, tagName));
            return null;
        }

        protected void invokeInlineTaglet(String name, Element top, List<? extends DocTree> children) {
            Taglet taglet = HtmlFactoryImpl.this.getTagletManager().getInlineTaglet(name);
            if (taglet instanceof SarlTaglet) {
                SarlTaglet staglet = (SarlTaglet)taglet;
                boolean chg = staglet.appendNode(top, children, this.memory.getElement(), this.elementDocumentation, this.cssStyle, this);
                if (chg) {
                    this.memory.changeDocumentationText();
                }
            } else if (taglet != null) {
                String content = taglet.toString(children, this.memory.getElement());
                if (!Strings.isNullOrEmpty((String)content)) {
                    this.memory.changeDocumentationText();
                    top.append(content);
                }
            } else {
                throw new NotFoundTagletException(name);
            }
        }

        @Override
        public Void visitOther(DocTree node, Void p) {
            return this.errorAction(node.toString(), node);
        }

        @Override
        public Void visitDocComment(DocCommentTree node, Void p) {
            return this.errorAction("<!-- -->", node);
        }

        @Override
        public Void visitErroneous(ErroneousTree node, Void p) {
            Diagnostic<JavaFileObject> diag = node.getDiagnostic();
            if (diag != null) {
                String msg = MessageFormat.format(Messages.HtmlFactoryImpl_11, diag.getSource().getName(), diag.getLineNumber(), diag.getColumnNumber(), diag.getMessage(Locale.getDefault()), node.getBody());
                this.getContext().getReporter().print(diag.getKind(), msg);
            }
            return null;
        }

        @Override
        public Void visitAttribute(AttributeTree node, Void noparam) {
            this.memory.changeDocumentationText();
            String name = node.getName().toString();
            Element top = this.memory.getTop();
            if (node.getValueKind() == AttributeTree.ValueKind.EMPTY) {
                top.attr(name, "");
            } else {
                Element valueElement = new Element(HtmlTags.HIDDEN_PSEUDO_TAG);
                this.memory.pushElement(HtmlTags.HIDDEN_PSEUDO_TAG, (Node)valueElement);
                this.groupAccept(node.getValue());
                this.memory.removeTo((Node)valueElement);
                if (valueElement.childNodeSize() == 0) {
                    top.attr(name, "");
                } else {
                    top.attr(name, valueElement.text());
                }
            }
            return null;
        }

        @Override
        public Void visitStartElement(StartElementTree node, Void noparam) {
            String name = node.getName().toString();
            Element tag = new Element(name);
            this.memory.pushElement(name, (Node)tag);
            this.groupAccept(node.getAttributes());
            if ("p".equalsIgnoreCase(name)) {
                this.memory.removeTo((Node)tag);
                this.memory.changeDocumentationText();
                Element top = this.memory.getTop();
                HtmlFactoryImpl.this.appendChild(top, (Node)tag);
            }
            return null;
        }

        @Override
        public Void visitEndElement(EndElementTree node, Void noparam) {
            String name = node.getName().toString();
            if (!"p".equalsIgnoreCase(name)) {
                StackElement child = ((CommentTextMemoryImpl)this.memory).removeTo(name);
                if (child != null) {
                    Element top = this.memory.getTop();
                    if (child.typeElement != null) {
                        this.memory.changeDocumentationText();
                        HtmlFactoryImpl.this.appendChildren(top, HtmlFactoryImpl.this.createTypeLink(child.typeElement, false, this.cssStyle, this.getContext()));
                        return null;
                    }
                    if (child.variableElement != null) {
                        this.memory.changeDocumentationText();
                        HtmlFactoryImpl.this.appendChildren(top, HtmlFactoryImpl.this.createVariableLink(child.variableElement, child.variableElement.getSimpleName().toString(), this.cssStyle, this.getContext()));
                        return null;
                    }
                    if (child.executableElement != null) {
                        this.memory.changeDocumentationText();
                        HtmlFactoryImpl.this.appendChildren(top, HtmlFactoryImpl.this.createExecutableLink(child.executableElement, child.executableElement.getSimpleName().toString(), this.cssStyle, this.getContext()));
                        return null;
                    }
                    if (child.node != null) {
                        this.memory.changeDocumentationText();
                        HtmlFactoryImpl.this.appendChildren(top, child.node);
                        return null;
                    }
                } else {
                    this.getContext().getReporter().print(Diagnostic.Kind.WARNING, MessageFormat.format(Messages.HtmlFactoryImpl_6, name, HtmlFactoryImpl.this.getElementUtils().getFullIdentifier(this.memory.getElement())));
                }
            }
            return null;
        }

        @Override
        public Void visitLink(LinkTree node, Void noparam) {
            this.invokeInlineTaglet("link", this.memory.getTop(), Collections.singletonList(node));
            return null;
        }

        @Override
        public Void visitEntity(EntityTree node, Void noparam) {
            this.memory.changeDocumentationText();
            Element top = this.memory.getTop();
            top.appendText(node.toString());
            return null;
        }

        @Override
        public Void visitLiteral(LiteralTree node, Void noparam) {
            this.memory.changeDocumentationText();
            Element top = this.memory.getTop();
            if (node.getKind() == DocTree.Kind.CODE) {
                this.invokeInlineTaglet("code", top, Collections.singletonList(node.getBody()));
                return null;
            }
            this.invokeInlineTaglet("literal", top, Collections.singletonList(node.getBody()));
            return null;
        }

        @Override
        public Void visitSerial(SerialTree node, Void noparam) {
            this.groupAccept(node.getDescription());
            return null;
        }

        @Override
        public Void visitSee(SeeTree node, Void noparam) {
            List<? extends DocTree> ref = node.getReference();
            ArrayList<DocTree> refref = new ArrayList<DocTree>();
            ArrayList<DocTree> text = new ArrayList<DocTree>();
            for (DocTree docTree : ref) {
                if (docTree instanceof ReferenceTree) {
                    refref.add(docTree);
                    continue;
                }
                text.add(docTree);
            }
            List<Node> n = this.extractReference(node, null, false, () -> this.groupAccept(refref));
            this.memory.changeDocumentationText();
            Element element = this.memory.getTop();
            HtmlFactoryImpl.this.appendChildren(element, n);
            HtmlFactoryImpl.this.createSecableSpace(element);
            this.groupAccept(text);
            return null;
        }

        @Override
        public Void visitAuthor(AuthorTree node, Void p) {
            this.groupAccept(node.getName());
            return null;
        }

        @Override
        public Void visitComment(CommentTree node, Void p) {
            String text = node.getBody();
            text = text.replaceFirst("^\\s*" + Pattern.quote("<!--") + "\\s*", "");
            text = text.replaceFirst("\\s*" + Pattern.quote("-->") + "\\s*$", "");
            Comment cmt = new Comment(text);
            this.memory.changeDocumentationText();
            Element top = this.memory.getTop();
            HtmlFactoryImpl.this.appendChildren(top, (Node)cmt);
            return null;
        }

        @Override
        public Void visitDeprecated(DeprecatedTree node, Void p) {
            this.groupAccept(node.getBody());
            return null;
        }

        @Override
        public Void visitDocRoot(DocRootTree node, Void p) {
            Element top = this.memory.getTop();
            this.invokeInlineTaglet("docroot", top, Collections.emptyList());
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void p) {
            this.memory.changeDocumentationText();
            Element top = this.memory.getTop();
            top.appendText(node.getName().toString());
            return null;
        }

        @Override
        public Void visitInheritDoc(InheritDocTree node, Void p) {
            this.invokeInlineTaglet("inheritDoc", this.memory.getTop(), Collections.singletonList(node));
            return null;
        }

        @Override
        public Void visitParam(ParamTree node, Void p) {
            this.groupAccept(node.getDescription());
            return null;
        }

        @Override
        public Void visitReturn(ReturnTree node, Void p) {
            this.groupAccept(node.getDescription());
            return null;
        }

        @Override
        public Void visitSerialData(SerialDataTree node, Void p) {
            this.groupAccept(node.getDescription());
            return null;
        }

        @Override
        public Void visitSerialField(SerialFieldTree node, Void p) {
            this.groupAccept(node.getDescription());
            return null;
        }

        @Override
        public Void visitSince(SinceTree node, Void p) {
            this.groupAccept(node.getBody());
            return null;
        }

        @Override
        public Void visitThrows(ThrowsTree node, Void p) {
            this.groupAccept(node.getDescription());
            return null;
        }

        @Override
        public Void visitVersion(VersionTree node, Void p) {
            this.groupAccept(node.getBody());
            return null;
        }

        @Override
        public Void visitUnknownInlineTag(UnknownInlineTagTree node, Void p) {
            String tagName = node.getTagName().toString().trim();
            Taglet taglet = HtmlFactoryImpl.this.getTagletManager().getInlineTaglet(tagName);
            this.visitUnknownTag(node.getContent(), tagName, taglet, Messages.HtmlFactoryImpl_7);
            return null;
        }

        @Override
        public Void visitUnknownBlockTag(UnknownBlockTagTree node, Void noparam) {
            String tagName = node.getTagName().toString().trim();
            Taglet.Location location = this.getContext().getDocUtils().getTagletLocation(this.memory.getElement());
            Taglet taglet = HtmlFactoryImpl.this.getTagletManager().getBlockTaglet(location, tagName);
            this.visitUnknownTag(node.getContent(), tagName, taglet, Messages.HtmlFactoryImpl_8);
            return null;
        }

        private void visitUnknownTag(List<? extends DocTree> nodes, String tagName, Taglet taglet, String errorMessage) {
            if (taglet != null) {
                Element top = this.memory.getTop();
                if (taglet instanceof SarlTaglet) {
                    SarlTaglet staglet = (SarlTaglet)taglet;
                    boolean chg = staglet.appendNode(top, nodes, this.memory.getElement(), this.elementDocumentation, this.cssStyle, this);
                    if (chg) {
                        this.memory.changeDocumentationText();
                    }
                } else {
                    String content = taglet.toString(nodes, this.memory.getElement());
                    this.memory.changeDocumentationText();
                    top.appendText(content);
                }
            } else {
                this.getContext().getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(errorMessage, tagName, HtmlFactoryImpl.this.getElementUtils().getFullIdentifier(this.memory.getElement())));
            }
        }

        @Override
        public Void visitValue(ValueTree node, Void noparam) {
            Element top = this.memory.getTop();
            this.invokeInlineTaglet("value", top, Collections.singletonList(node.getReference()));
            return null;
        }

        private TypeMirror getCurrentType() {
            javax.lang.model.element.Element element = this.memory.getElement();
            assert (element != null);
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return element.asType();
                }
            }
            TypeElement type = HtmlFactoryImpl.this.getElementUtils().getEnclosingTypeElement(element);
            if (type != null) {
                return type.asType();
            }
            return null;
        }

        @Override
        public Void visitReference(ReferenceTree node, Void noparam) {
            String packs;
            javax.lang.model.element.Element referencedElement = HtmlFactoryImpl.this.getElementUtils().getReferencedElement(node, this.getCurrentType(), this.getContext().getQualifiedNameSetBuilder(this.memory.getElement()));
            if (referencedElement instanceof TypeElement) {
                TypeElement cvalue = (TypeElement)referencedElement;
                this.memory.pushElement(HtmlTags.REFERENCE_PSEUDO_TAG, cvalue);
                return null;
            }
            if (referencedElement instanceof ExecutableElement) {
                ExecutableElement cvalue = (ExecutableElement)referencedElement;
                this.memory.pushElement(HtmlTags.REFERENCE_PSEUDO_TAG, cvalue);
                return null;
            }
            if (referencedElement instanceof VariableElement) {
                VariableElement cvalue = (VariableElement)referencedElement;
                this.memory.pushElement(HtmlTags.REFERENCE_PSEUDO_TAG, cvalue);
                return null;
            }
            String signature = node.getSignature();
            if (this.getContext().getQualifiedNameSetBuilder(this.memory.getElement()) != null) {
                Set<String> packages = this.getContext().getQualifiedNameSetBuilder(this.memory.getElement()).buildCandidateList(signature);
                packs = Iterables.toString(packages);
            } else {
                packs = "[]";
            }
            this.getContext().getReporter().print(Diagnostic.Kind.WARNING, MessageFormat.format(Messages.HtmlFactoryImpl_9, signature, packs));
            this.memory.pushElement(HtmlTags.REFERENCE_PSEUDO_TAG, (Node)new TextNode(signature));
            return null;
        }

        @Override
        public Void visitText(TextTree node, Void noparam) {
            this.memory.changeDocumentationText();
            Element top = this.memory.getTop();
            top.appendText(node.getBody());
            return null;
        }
    }

    private class HtmlTabsFactoryImpl
    implements HtmlFactory.HtmlTabsFactory {
        private CssStyles titleStyle;
        private CssStyles contentStyle;
        private final List<Element> titles = new ArrayList<Element>();
        private final List<Element> contents = new ArrayList<Element>();
        private final String tabButtonClassname;
        private final String tabContentClassname;

        HtmlTabsFactoryImpl(CssStyles titleStyle, CssStyles contentStyle) {
            this.titleStyle = titleStyle;
            this.contentStyle = contentStyle;
            this.tabButtonClassname = HtmlFactoryImpl.this.computeTabButtonClassname();
            this.tabContentClassname = HtmlFactoryImpl.this.computeTabContentClassname();
        }

        @Override
        public int size() {
            return this.titles.size();
        }

        @Override
        public Element getSelector(int index) {
            return this.titles.get(index);
        }

        @Override
        public Element getContent(int index) {
            return this.contents.get(index);
        }

        private Element addTabElements() {
            String id = HtmlFactoryImpl.this.computeId();
            boolean isFirst = this.isEmpty();
            Element titleBox = new Element("button");
            titleBox.addClass(CssStyles.TABS_TITLE.getCssClassname());
            if (this.titleStyle != null) {
                titleBox.addClass(this.titleStyle.getCssClassname());
            }
            titleBox.attr("onclick", "openTabElement(this,'" + id + "', '" + this.tabButtonClassname + "', '" + this.tabContentClassname + "')");
            titleBox.addClass(this.tabButtonClassname);
            if (isFirst) {
                titleBox.addClass("active");
            }
            Element contentBox = new Element("div");
            contentBox.id(id);
            contentBox.addClass(CssStyles.TABS_CONTENT.getCssClassname());
            contentBox.addClass(this.tabContentClassname);
            if (this.contentStyle != null) {
                contentBox.addClass(this.contentStyle.getCssClassname());
            }
            if (!isFirst) {
                contentBox.attr("style", "display:none;");
            }
            this.titles.add(titleBox);
            this.contents.add(contentBox);
            return titleBox;
        }

        @Override
        public void addTab(String title) {
            Element titleBox = this.addTabElements();
            titleBox.appendText(title);
        }

        @Override
        public void addTab(Node title) {
            Element titleBox = this.addTabElements();
            titleBox.appendChild(title);
        }

        @Override
        public void removeLastTab() {
            this.titles.remove(this.titles.size() - 1);
            this.contents.remove(this.contents.size() - 1);
        }

        @Override
        public Element createSelectors(Element parent) {
            Element selectors = parent == null ? new Element("div") : parent.appendElement("div");
            for (Element selector : this.titles) {
                selectors.appendChild((Node)selector);
            }
            return selectors;
        }

        @Override
        public Element createContents(Element parent) {
            Element contents = parent == null ? new Element("div") : parent;
            for (Element cnt : this.contents) {
                contents.appendChild((Node)cnt);
            }
            return contents;
        }
    }

    public static class NotFoundTagletException
    extends RuntimeException {
        private static final long serialVersionUID = -335570634022907846L;

        public NotFoundTagletException(String name) {
            super(name);
        }
    }

    private static class StackElement {
        public final Node node;
        public final TypeElement typeElement;
        public final VariableElement variableElement;
        public final ExecutableElement executableElement;
        public final String name;

        public StackElement(String name, Node node) {
            this.name = name;
            this.node = node;
            this.typeElement = null;
            this.variableElement = null;
            this.executableElement = null;
        }

        public StackElement(String name, TypeElement element) {
            this.name = name;
            this.node = null;
            this.typeElement = element;
            this.variableElement = null;
            this.executableElement = null;
        }

        public StackElement(String name, VariableElement element) {
            this.name = name;
            this.node = null;
            this.typeElement = null;
            this.variableElement = element;
            this.executableElement = null;
        }

        public StackElement(String name, ExecutableElement element) {
            this.name = name;
            this.node = null;
            this.typeElement = null;
            this.variableElement = null;
            this.executableElement = element;
        }

        public String toString() {
            if (this.typeElement != null) {
                return this.name + ": " + this.typeElement.toString();
            }
            if (this.variableElement != null) {
                return this.name + ": " + this.variableElement.toString();
            }
            if (this.executableElement != null) {
                return this.name + ": " + this.executableElement.toString();
            }
            return this.name + ": " + this.node.toString();
        }
    }
}

