/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.framework;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.sarl.docs.doclet2.framework.ElementUtils;
import io.sarl.docs.doclet2.framework.TypeRepository;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.HtmlFactory;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Messages;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.framework.PathBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class NavigationImpl
implements Navigation {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(NavigationImpl.class.getPackageName() + ".messages2");
    private List<? extends Node> moduleLink = Collections.emptyList();
    private final List<Element> navigationBars = new ArrayList<Element>();
    private final Set<String> summaryBoxAnchors = new TreeSet<String>();
    private final Set<String> detailBoxAnchors = new TreeSet<String>();
    private HtmlFactory htmlFactory;
    private PathBuilder pathBuilder;
    private TypeRepository typeRepository;
    private ElementUtils elementUtils;
    private Navigation.NavigationKind kind;

    @Inject
    public void setElementUtils(ElementUtils utils) {
        this.elementUtils = utils;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }

    @Inject
    public void setTypeRepository(TypeRepository repository) {
        this.typeRepository = repository;
    }

    public TypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    @Inject
    public void setHtmlFactory(HtmlFactory factory) {
        this.htmlFactory = factory;
    }

    public HtmlFactory getHtmlFactory() {
        return this.htmlFactory;
    }

    @Inject
    public void setPathBuilder(PathBuilder builder) {
        this.pathBuilder = builder;
    }

    public PathBuilder getPathBuilder() {
        return this.pathBuilder;
    }

    @Override
    public Navigation.NavigationKind getKind() {
        return this.kind;
    }

    @Override
    public void setKind(Navigation.NavigationKind kind) {
        this.kind = kind;
    }

    @Override
    public void setModuleLink(List<? extends Node> link) {
        this.moduleLink = link == null ? Collections.emptyList() : link;
    }

    @Override
    public List<? extends Node> getModuleLink() {
        return this.moduleLink;
    }

    @Override
    public Node createNavigationBar(Element parent) {
        Element bar = this.getHtmlFactory().createDivTag(parent, CssStyles.NAVIGATION);
        this.navigationBars.add(bar);
        return bar;
    }

    @Override
    public void generateNavigationBars(TypeElement currentType, HtmlFactoryContext context) {
        TypeElement previousType = null;
        TypeElement nextType = null;
        if (currentType != null) {
            SortedSet<TypeElement> packageElements = this.getTypeRepository().getTypesInPackage(context.getEnvironment().getElementUtils().getPackageOf(currentType));
            Comparator<TypeElement> cmp = this.getElementUtils().getTypeElementComparator();
            Iterator iterator = packageElements.iterator();
            boolean found = false;
            while (iterator.hasNext() && !found) {
                TypeElement c = (TypeElement)iterator.next();
                if (cmp.compare(c, currentType) == 0) {
                    found = true;
                    continue;
                }
                previousType = c;
            }
            if (found) {
                if (iterator.hasNext()) {
                    nextType = (TypeElement)iterator.next();
                }
            } else {
                previousType = null;
            }
        }
        for (Element bar : this.navigationBars) {
            this.generateGlobalNavigationBar(bar, currentType, context);
            if (currentType == null) continue;
            this.generateLocalNavigationBar(bar, previousType, currentType, nextType, context);
        }
    }

    @Override
    public void generateNavigationBars(PackageElement currentPackage, HtmlFactoryContext context) {
        for (Element bar : this.navigationBars) {
            this.generateGlobalNavigationBar(bar, currentPackage, context);
        }
    }

    @Override
    public void generateNavigationBars(ModuleElement currentModule, HtmlFactoryContext context) {
        for (Element bar : this.navigationBars) {
            this.generateGlobalNavigationBar(bar, currentModule, context);
        }
    }

    private void createLink(Element receiver, Path path, String label, HtmlFactoryContext context) {
        Path linkModulePath = context.getPathToRoot().resolve(path);
        List<Node> link = this.getHtmlFactory().createLink(linkModulePath, label, null);
        receiver.appendChildren(link);
    }

    private void createMainNavButton(Element parent, String label, Path relativePath, HtmlFactoryContext context, Navigation.NavigationKind kind) {
        Element navItem = this.getHtmlFactory().createLiTag(parent, null);
        if (this.getKind() == kind) {
            navItem.appendText(label);
            navItem.addClass(CssStyles.ACTIVE.getCssClassname());
        } else if (relativePath != null) {
            this.createLink(navItem, relativePath, label, context);
        } else {
            navItem.appendText(label);
        }
    }

    protected void generateGlobalNavigationBar(Element parent, TypeElement currentType, HtmlFactoryContext context) {
        PackageElement packageElement;
        ModuleElement moduleElement;
        if (currentType != null) {
            moduleElement = context.getEnvironment().getElementUtils().getModuleOf(currentType);
            packageElement = context.getEnvironment().getElementUtils().getPackageOf(currentType);
        } else {
            moduleElement = null;
            packageElement = null;
        }
        this.generateGlobalNavigationBar(parent, moduleElement, packageElement, currentType, context);
    }

    protected void generateGlobalNavigationBar(Element parent, PackageElement currentPackage, HtmlFactoryContext context) {
        ModuleElement moduleElement = currentPackage != null ? context.getEnvironment().getElementUtils().getModuleOf(currentPackage) : null;
        this.generateGlobalNavigationBar(parent, moduleElement, currentPackage, null, context);
    }

    protected void generateGlobalNavigationBar(Element parent, ModuleElement currentModule, HtmlFactoryContext context) {
        this.generateGlobalNavigationBar(parent, currentModule, null, null, context);
    }

    protected void generateGlobalNavigationBar(Element parent, ModuleElement moduleElement, PackageElement packageElement, TypeElement currentType, HtmlFactoryContext context) {
        Element bar = this.getHtmlFactory().createDivTag(parent, CssStyles.GLOBAL_NAVIGATION);
        Element nav = this.getHtmlFactory().createUlTag(bar, CssStyles.NAVIGATION_MAIN_LIST);
        this.createMainNavButton(nav, Messages.NavigationImpl_5, this.getPathBuilder().overviewSummary(), context, Navigation.NavigationKind.OVERVIEW);
        this.createMainNavButton(nav, Messages.NavigationImpl_6, this.getPathBuilder().moduleSummary(moduleElement), context, Navigation.NavigationKind.MODULE);
        this.createMainNavButton(nav, Messages.NavigationImpl_7, this.getPathBuilder().packageSummary(packageElement), context, Navigation.NavigationKind.PACKAGE);
        this.createMainNavButton(nav, Messages.NavigationImpl_8, null, context, Navigation.NavigationKind.TYPE);
        Path treePath = packageElement != null ? this.getPathBuilder().packageTypeHierarchy(packageElement) : this.getPathBuilder().typeHierarchy();
        this.createMainNavButton(nav, Messages.NavigationImpl_10, treePath, context, Navigation.NavigationKind.TREE);
        this.createMainNavButton(nav, Messages.NavigationImpl_11, this.getPathBuilder().deprecatedIndex(), context, Navigation.NavigationKind.DEPRECATED);
        this.createMainNavButton(nav, Messages.NavigationImpl_12, this.getPathBuilder().index(), context, Navigation.NavigationKind.INDEX);
    }

    protected void generateLocalNavigationBar(Element parent, TypeElement previousType, TypeElement currentType, TypeElement nextType, HtmlFactoryContext context) {
        List<Node> link;
        String anchor;
        Iterator<String> anchorIterator;
        Element bar = this.getHtmlFactory().createDivTag(parent, CssStyles.LOCAL_NAVIGATION);
        Element classNav = this.getHtmlFactory().createUlTag(bar, CssStyles.NAVIGATION_LIST);
        Element classNavItem = this.getHtmlFactory().createLiTag(classNav, null);
        Element emphSpan = this.getHtmlFactory().createSpanTag(classNavItem, CssStyles.EMPH);
        if (previousType != null) {
            emphSpan.appendChildren(this.getHtmlFactory().createTypeLink(previousType, Messages.NavigationImpl_0, null, context));
        } else {
            emphSpan.appendText(Messages.NavigationImpl_0);
        }
        classNavItem = this.getHtmlFactory().createLiTag(classNav, null);
        emphSpan = this.getHtmlFactory().createSpanTag(classNavItem, CssStyles.EMPH);
        if (nextType != null) {
            emphSpan.appendChildren(this.getHtmlFactory().createTypeLink(nextType, Messages.NavigationImpl_1, null, context));
        } else {
            emphSpan.appendText(Messages.NavigationImpl_1);
        }
        Element indexNav = this.getHtmlFactory().createUlTag(bar, CssStyles.NAVIGATION_LIST);
        Element indexNavItem = this.getHtmlFactory().createLiTag(indexNav, null);
        Path allTypeIndexPath = this.getPathBuilder().allTypesIndex();
        this.createLink(indexNavItem, allTypeIndexPath, Messages.NavigationImpl_2, context);
        bar.appendChild((Node)this.getHtmlFactory().createNewLineTag());
        if (!this.summaryBoxAnchors.isEmpty()) {
            Element summaryNav = this.getHtmlFactory().createUlTag(bar, CssStyles.NAVIGATION_SUBLIST);
            Element summaryNavItem = this.getHtmlFactory().createLiTag(summaryNav, null);
            summaryNavItem.appendText(Messages.NavigationImpl_3);
            anchorIterator = this.summaryBoxAnchors.iterator();
            while (anchorIterator.hasNext()) {
                anchor = anchorIterator.next();
                summaryNavItem = this.getHtmlFactory().createLiTag(summaryNav, null);
                link = this.getHtmlFactory().createLink((Path)null, anchor, this.mapBoxAnchorIdToName(anchor), null);
                summaryNavItem.appendChildren(link);
                if (!anchorIterator.hasNext()) continue;
                this.getHtmlFactory().createUnsecableSpace(summaryNavItem);
                summaryNavItem.appendText("|");
            }
        }
        if (!this.detailBoxAnchors.isEmpty()) {
            Element detailsNav = this.getHtmlFactory().createUlTag(bar, CssStyles.NAVIGATION_SUBLIST);
            Element detailsNavItem = this.getHtmlFactory().createLiTag(detailsNav, null);
            detailsNavItem.appendText(Messages.NavigationImpl_4);
            anchorIterator = this.detailBoxAnchors.iterator();
            while (anchorIterator.hasNext()) {
                anchor = anchorIterator.next();
                detailsNavItem = this.getHtmlFactory().createLiTag(detailsNav, null);
                link = this.getHtmlFactory().createLink((Path)null, anchor, this.mapBoxAnchorIdToName(anchor), null);
                detailsNavItem.appendChildren(link);
                if (!anchorIterator.hasNext()) continue;
                this.getHtmlFactory().createUnsecableSpace(detailsNavItem);
                detailsNavItem.appendText("|");
            }
        }
    }

    protected String mapBoxAnchorIdToName(String anchorId) {
        try {
            String value = BUNDLE.getString(anchorId);
            if (!Strings.isNullOrEmpty((String)value)) {
                return value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return anchorId;
    }

    @Override
    public void addSummaryBoxAnchor(String anchor) {
        this.summaryBoxAnchors.add(anchor);
    }

    @Override
    public void addDetailBoxAnchor(String anchor) {
        this.detailBoxAnchors.add(anchor);
    }
}

