/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.framework;

import com.google.common.base.Strings;
import io.sarl.docs.doclet2.html.framework.PathBuilder;
import java.nio.file.Path;
import java.util.regex.Pattern;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public class PathBuilderImpl
implements PathBuilder {
    protected Path createModulePath(ModuleElement module, String basename) {
        String name = module.isUnnamed() ? "unnamed-module-" + basename : String.valueOf(module.getQualifiedName()) + "-" + basename;
        return Path.of(name, new String[0]);
    }

    @Override
    public Path moduleSummary(ModuleElement module) {
        if (module == null) {
            return null;
        }
        return this.createModulePath(module, "summary.html");
    }

    protected Path createPackagePath(PackageElement pkg, String basename) {
        String[] elements = pkg.getQualifiedName().toString().split(Pattern.quote("."));
        Path pt = null;
        for (int i = 0; i < elements.length; ++i) {
            String elt = elements[i];
            Path cpath = Path.of(elt, new String[0]);
            pt = pt == null ? cpath : pt.resolve(cpath);
        }
        String name = basename;
        if (Strings.isNullOrEmpty((String)name)) {
            name = pkg.isUnnamed() ? "default-package-summary.html" : "package-summary.html";
        }
        pt = pt == null ? Path.of(name, new String[0]) : pt.resolve(name);
        return pt;
    }

    @Override
    public Path packageSummary(PackageElement pkg) {
        if (pkg == null) {
            return null;
        }
        return this.createPackagePath(pkg, null);
    }

    protected Path createTypePath(TypeElement type, String basename) {
        String[] elements = type.getQualifiedName().toString().split(Pattern.quote("."));
        Path pt = null;
        for (int i = 0; i < elements.length - 1; ++i) {
            String elt = elements[i];
            Path cpath = Path.of(elt, new String[0]);
            pt = pt == null ? cpath : pt.resolve(cpath);
        }
        pt = pt == null ? (basename != null ? Path.of(basename, new String[0]) : Path.of(elements[elements.length - 1] + ".html", new String[0])) : (basename != null ? pt.resolve(basename) : pt.resolve(elements[elements.length - 1] + ".html"));
        return pt;
    }

    @Override
    public Path typeIndex(TypeElement type) {
        if (type == null) {
            return null;
        }
        return this.createTypePath(type, null);
    }

    @Override
    public Path allTypesIndex() {
        return Path.of("all-types.html", new String[0]);
    }

    @Override
    public Path index() {
        return Path.of("index-all.html", new String[0]);
    }

    @Override
    public Path htmlIndexFile() {
        return Path.of("index.html", new String[0]);
    }

    @Override
    public Path rawPackageList() {
        return Path.of("package-list", new String[0]);
    }

    @Override
    public Path rawModuleList() {
        return Path.of("module-list", new String[0]);
    }

    @Override
    public Path deprecatedIndex() {
        return Path.of("deprecated-list.html", new String[0]);
    }

    @Override
    public Path packageTypeHierarchy(PackageElement packageElement) {
        if (packageElement == null) {
            return null;
        }
        return this.createPackagePath(packageElement, "package-tree.html");
    }

    @Override
    public Path typeHierarchy() {
        return Path.of("overview-tree.html", new String[0]);
    }

    @Override
    public Path overviewTree() {
        return Path.of("overview-tree.html", new String[0]);
    }

    @Override
    public Path useIndex(TypeElement type) {
        if (type == null) {
            return null;
        }
        Path typeIndex = this.typeIndex(type);
        Path parent = typeIndex.getParent();
        Path basename = typeIndex.getFileName();
        return parent.resolve("class-use").resolve(basename);
    }

    @Override
    public Path overviewSummary() {
        return Path.of("overview-summary.html", new String[0]);
    }

    @Override
    public Path overviewFrame() {
        return Path.of("overview-frame.html", new String[0]);
    }

    @Override
    public Path allTypesFrame() {
        return Path.of("alltypes-frame.html", new String[0]);
    }
}

