/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.indexes;

import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.framework.AbstractDocumentationGenerator;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.indexes.IndexGenerator;
import io.sarl.docs.doclet2.html.indexes.Messages;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;

public class IndexGeneratorImpl
extends AbstractDocumentationGenerator
implements IndexGenerator {
    private static final Comparator<Element> COMPARATOR = (a, b) -> {
        String bbn;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return Integer.MIN_VALUE;
        }
        if (b == null) {
            return Integer.MAX_VALUE;
        }
        String abn = a.getSimpleName().toString();
        int cmp = abn.compareTo(bbn = b.getSimpleName().toString());
        if (cmp != 0) {
            return cmp;
        }
        return a.toString().compareTo(b.toString());
    };

    @Override
    protected String getDocumentTitleFor(String elementName) {
        return Messages.IndexGeneratorImpl_1;
    }

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.INDEX);
    }

    @Override
    public void generate(Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.initGenerator(cssStylesheets, jsScripts, reporter, environment, cliOptions);
        this.getReporter().print(Diagnostic.Kind.NOTE, Messages.IndexGeneratorImpl_0);
        this.computePaths(this.getPathBuilder().index(), true);
        Path outputPath = this.getDocletOptions().getOutputDirectory().resolve(this.getRelativePath());
        Document document = this.getHtmlFactory().createDocument(cliOptions.getCharset(), this);
        String title = this.getDocumentTitleFor(null);
        this.setLastTitle(title);
        org.jsoup.nodes.Element htmlTag = this.getHtmlAccessor().getRootElement(document);
        this.generateHtmlHeader(htmlTag);
        this.generateHtmlBody(htmlTag);
        if (!this.getDocletOptions().isFakeOutput()) {
            this.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.IndexGeneratorImpl_2, outputPath.toString()));
            IndexGeneratorImpl.writeDocument(outputPath, document);
        }
    }

    protected org.jsoup.nodes.Element generateHtmlHeader(org.jsoup.nodes.Element htmlTag) {
        org.jsoup.nodes.Element headerTree = this.getHtmlFactory().createHeadTag(htmlTag);
        this.getHtmlFactory().createTitleTag(headerTree, this.getLastTitle());
        Path pathToRoot = this.getPathToRoot();
        for (Path cssStyle : this.getCssStylesheets()) {
            this.getHtmlFactory().createCssLinkTag(headerTree, pathToRoot.resolve(cssStyle));
        }
        for (Path jsScript : this.getJsScripts()) {
            this.getHtmlFactory().createJsLinkTag(headerTree, pathToRoot.resolve(jsScript));
        }
        return headerTree;
    }

    protected org.jsoup.nodes.Element generateHtmlBody(org.jsoup.nodes.Element htmlTag) {
        org.jsoup.nodes.Element bodyTag = this.getHtmlFactory().createBodyTag(htmlTag);
        this.generateBodyHeader(bodyTag);
        org.jsoup.nodes.Element contentTag = this.getHtmlFactory().createDivTag(bodyTag, CssStyles.CONTENT);
        this.generateBodyContent(contentTag);
        this.generateBodyFooter(bodyTag);
        this.generateNavigationBar();
        return bodyTag;
    }

    protected void generateBodyHeader(org.jsoup.nodes.Element parent) {
        org.jsoup.nodes.Element divTag = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER);
        this.getNavigation().createNavigationBar(divTag);
    }

    protected void generateBodyFooter(org.jsoup.nodes.Element parent) {
        org.jsoup.nodes.Element divTag = this.getHtmlFactory().createDivTag(parent, CssStyles.FOOTER);
        this.getNavigation().createNavigationBar(divTag);
        this.createCopyrightBox(divTag);
    }

    protected void generateNavigationBar() {
        this.getNavigation().generateNavigationBars((TypeElement)null, (HtmlFactoryContext)this);
    }

    private void addEntry(Map<String, SortedSet<Element>> index, Element element) {
        String name = element.getSimpleName().toString();
        String letter = Character.valueOf(name.charAt(0)).toString().toUpperCase();
        SortedSet entries = index.computeIfAbsent(letter, it -> new TreeSet<Element>(COMPARATOR));
        entries.add(element);
    }

    protected Map<String, SortedSet<Element>> buildIndex() {
        TreeMap<String, SortedSet<Element>> index = new TreeMap<String, SortedSet<Element>>();
        SortedSet<TypeElement> types = this.getTypeRepository().getTypes();
        for (TypeElement type : types) {
            if (!this.getEnvironment().isIncluded(type)) continue;
            this.addEntry(index, type);
            for (Element element : type.getEnclosedElements()) {
                if (!this.getEnvironment().isIncluded(element)) continue;
                switch (element.getKind()) {
                    case FIELD: {
                        this.addEntry(index, element);
                        break;
                    }
                    case METHOD: {
                        this.addEntry(index, element);
                        break;
                    }
                    case ENUM_CONSTANT: {
                        this.addEntry(index, element);
                        break;
                    }
                }
            }
        }
        return index;
    }

    protected void generateIndex(org.jsoup.nodes.Element parent, Map<String, SortedSet<Element>> index) {
        org.jsoup.nodes.Element dlTag = this.getHtmlFactory().createDlTag(parent, CssStyles.INDEX);
        for (Map.Entry<String, SortedSet<Element>> entry : index.entrySet()) {
            org.jsoup.nodes.Element dtTag = this.getHtmlFactory().createDtTag(dlTag, CssStyles.INDEX);
            dtTag.appendText(entry.getKey());
            org.jsoup.nodes.Element ddTag = this.getHtmlFactory().createDdTag(dlTag, CssStyles.INDEX);
            org.jsoup.nodes.Element ulTag = this.getHtmlFactory().createUlTag(ddTag, CssStyles.INDEX);
            for (Element element : entry.getValue()) {
                org.jsoup.nodes.Element liTag = this.getHtmlFactory().createLiTag(null, null);
                if (!this.generateSingleEntry(liTag, element)) continue;
                ulTag.appendChild((Node)liTag);
            }
        }
    }

    protected boolean generateSingleEntry(org.jsoup.nodes.Element parent, Element element) {
        List<Node> link;
        if (element instanceof TypeElement) {
            TypeElement cvalue = (TypeElement)element;
            link = this.getHtmlFactory().createTypeLink(cvalue, true, null, (HtmlFactoryContext)this);
        } else if (element instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)element;
            List<Node> label = this.getHtmlFactory().getExecutablePrototype(ee, ee.getSimpleName().toString(), (HtmlFactoryContext)this);
            link = this.getHtmlFactory().createExecutableLink(ee, label, null, (HtmlFactoryContext)this);
        } else if (element instanceof VariableElement) {
            VariableElement ve = (VariableElement)element;
            link = this.getHtmlFactory().createVariableLink(ve, ve.getSimpleName().toString(), null, (HtmlFactoryContext)this);
        } else {
            return false;
        }
        parent.appendChildren(link);
        this.getHtmlFactory().createUnsecableSpace(parent);
        parent.appendText("-");
        this.getHtmlFactory().createUnsecableSpace(parent);
        ArrayList<Node> description = new ArrayList<Node>();
        this.createFirstSentence(element, description, false, false);
        this.createShortDeprecationMessage(element, description, true);
        parent.appendChildren(description);
        return true;
    }

    protected void generateBodyContent(org.jsoup.nodes.Element parent) {
        Map<String, SortedSet<Element>> fullIndex = this.buildIndex();
        this.generateIndex(parent, fullIndex);
    }
}

