/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.raw;

import com.google.common.base.Strings;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.framework.AbstractDocumentationGenerator;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.raw.Messages;
import io.sarl.docs.doclet2.html.raw.RawModuleListGenerator;
import java.nio.file.Path;
import java.text.MessageFormat;
import javax.lang.model.element.ModuleElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;

public class RawModuleListGeneratorImpl
extends AbstractDocumentationGenerator
implements RawModuleListGenerator {
    @Override
    protected String getDocumentTitleFor(String elementName) {
        return "";
    }

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.INDEX);
    }

    @Override
    public void generate(SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.initGenerator(null, null, reporter, environment, cliOptions);
        this.getReporter().print(Diagnostic.Kind.NOTE, Messages.RawModuleListGeneratorImpl_0);
        this.computePaths(this.getPathBuilder().rawModuleList(), false);
        Path outputPath = this.getDocletOptions().getOutputDirectory().resolve(this.getRelativePath());
        StringBuilder content = new StringBuilder();
        for (ModuleElement moduleElement : this.getTypeRepository().getModules()) {
            String qn = moduleElement.getQualifiedName().toString();
            if (Strings.isNullOrEmpty((String)qn)) continue;
            content.append(qn);
            content.append("\n");
        }
        if (!this.getDocletOptions().isFakeOutput()) {
            this.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.RawModuleListGeneratorImpl_1, outputPath.toString()));
            RawModuleListGeneratorImpl.writeDocument(outputPath, content.toString());
        }
    }
}

