/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.summaries;

import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.framework.AbstractDocumentationGenerator;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.summaries.Messages;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public abstract class AbstractSummaryGenerator
extends AbstractDocumentationGenerator {
    private String title;

    public AbstractSummaryGenerator() {
        this.title = null;
    }

    public AbstractSummaryGenerator(String title) {
        this.title = title;
    }

    protected void setDefaultTitle(String title) {
        this.title = title;
    }

    protected void generate(String logMessage, String basename, Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.initGenerator(cssStylesheets, jsScripts, reporter, environment, cliOptions);
        this.getReporter().print(Diagnostic.Kind.NOTE, logMessage);
        this.computePaths(basename, false);
        this.generate();
    }

    protected void generate(String logMessage, Path filename, Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.initGenerator(cssStylesheets, jsScripts, reporter, environment, cliOptions);
        this.getReporter().print(Diagnostic.Kind.NOTE, logMessage);
        this.computePaths(filename, true);
        this.generate();
    }

    private void generate() throws Exception {
        Path outputPath = this.getDocletOptions().getOutputDirectory().resolve(this.getRelativePath());
        Document document = this.getHtmlFactory().createDocument(this.getDocletOptions().getCharset(), this);
        String title = this.getDocumentTitleFor(null);
        this.setLastTitle(title);
        Element htmlTag = this.getHtmlAccessor().getRootElement(document);
        this.generateHtmlHeader(htmlTag);
        this.generateHtmlBody(htmlTag);
        if (!this.getDocletOptions().isFakeOutput()) {
            this.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.AbstractSummaryGenerator_0, outputPath.toString()));
            AbstractSummaryGenerator.writeDocument(outputPath, document);
        }
    }

    protected Element generateHtmlHeader(Element htmlTag) {
        Element headerTree = this.getHtmlFactory().createHeadTag(htmlTag);
        this.getHtmlFactory().createTitleTag(headerTree, this.getLastTitle());
        Path pathToRoot = this.getPathToRoot();
        for (Path cssStyle : this.getCssStylesheets()) {
            this.getHtmlFactory().createCssLinkTag(headerTree, pathToRoot.resolve(cssStyle));
        }
        for (Path jsScript : this.getJsScripts()) {
            this.getHtmlFactory().createJsLinkTag(headerTree, pathToRoot.resolve(jsScript));
        }
        return headerTree;
    }

    protected Element generateHtmlBody(Element htmlTag) {
        Element bodyTag = this.getHtmlFactory().createBodyTag(htmlTag);
        this.generateBodyHeader(bodyTag);
        Element contentTag = this.getHtmlFactory().createDivTag(bodyTag, CssStyles.CONTENT);
        this.generateBodyContent(contentTag);
        this.generateBodyFooter(bodyTag);
        this.generateNavigationBar();
        return bodyTag;
    }

    protected abstract void generateNavigationBar();

    protected abstract void generateBodyContent(Element var1);

    protected void generateBodyHeader(Element parent) {
        Element divTag = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER);
        this.getNavigation().createNavigationBar(divTag);
    }

    protected void generateBodyFooter(Element parent) {
        Element divTag = this.getHtmlFactory().createDivTag(parent, CssStyles.FOOTER);
        this.getNavigation().createNavigationBar(divTag);
        this.createCopyrightBox(divTag);
    }

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(null);
    }

    @Override
    protected String getDocumentTitleFor(String elementName) {
        return this.title;
    }
}

