/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.summaries;

import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.summaries.AbstractSummaryGenerator;
import io.sarl.docs.doclet2.html.summaries.Messages;
import java.util.List;
import java.util.SortedSet;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public abstract class AbstractTreeSummaryGenerator
extends AbstractSummaryGenerator {
    private Element agentHierarchy;
    private Element behaviorHierarchy;
    private Element capacityHierarchy;
    private Element skillHierarchy;
    private Element eventHierarchy;
    private Element classHierarchy;
    private Element interfaceHierarchy;

    public AbstractTreeSummaryGenerator(String title) {
        super(title);
    }

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.TREE);
    }

    protected void buildHierarchies() {
        this.agentHierarchy = this.getHtmlFactory().createUlTag(null, null);
        this.behaviorHierarchy = this.getHtmlFactory().createUlTag(null, null);
        this.capacityHierarchy = this.getHtmlFactory().createUlTag(null, null);
        this.skillHierarchy = this.getHtmlFactory().createUlTag(null, null);
        this.eventHierarchy = this.getHtmlFactory().createUlTag(null, null);
        this.classHierarchy = this.getHtmlFactory().createUlTag(null, null);
        this.interfaceHierarchy = this.getHtmlFactory().createUlTag(null, null);
        this.updateClasses(null, null, this.getTypeHierarchy().getBaseClasses());
        this.updateInterfaces(null, null, this.getTypeHierarchy().getBaseInterfaces());
    }

    protected boolean isVisible(TypeElement type) {
        return true;
    }

    private void updateClasses(Element receiver, Element root, SortedSet<? extends TypeElement> types) {
        for (TypeElement typeElement : types) {
            Element expectedRoot = this.getElementUtils().isSarlAgent(typeElement) ? this.agentHierarchy : (this.getElementUtils().isSarlBehavior(typeElement) ? this.behaviorHierarchy : (this.getElementUtils().isSarlSkill(typeElement) ? this.skillHierarchy : (this.getElementUtils().isSarlEvent(typeElement) ? this.eventHierarchy : this.classHierarchy)));
            Element parent = receiver;
            if (parent == null || expectedRoot != root) {
                parent = expectedRoot;
            }
            if (!this.isVisible(typeElement)) continue;
            Element typeElement2 = this.getHtmlFactory().createLiTag(parent, null);
            this.generateClassLink(typeElement2, typeElement);
            SortedSet<? extends TypeElement> subTypes = this.getTypeHierarchy().getDirectSubTypes(typeElement);
            if (subTypes.isEmpty()) continue;
            Element container = this.getHtmlFactory().createUlTag(null, null);
            this.updateClasses(container, expectedRoot, subTypes);
            if (container.childNodeSize() <= 0) continue;
            typeElement2.appendChild((Node)container);
        }
    }

    private void updateInterfaces(Element receiver, Element root, SortedSet<? extends TypeElement> types) {
        for (TypeElement typeElement : types) {
            Element expectedRoot = this.getElementUtils().isSarlCapacity(typeElement) ? this.capacityHierarchy : this.interfaceHierarchy;
            Element parent = receiver;
            if (parent == null || expectedRoot != root) {
                parent = expectedRoot;
            }
            if (!this.isVisible(typeElement)) continue;
            Element typeElement2 = this.getHtmlFactory().createLiTag(parent, null);
            this.generateInterfaceLink(typeElement2, typeElement);
            SortedSet<? extends TypeElement> subTypes = this.getTypeHierarchy().getDirectSubTypes(typeElement);
            if (subTypes.isEmpty()) continue;
            Element container = this.getHtmlFactory().createUlTag(null, null);
            this.updateClasses(container, expectedRoot, subTypes);
            if (container.childNodeSize() <= 0) continue;
            typeElement2.appendChild((Node)container);
        }
    }

    protected void generateClassLink(Element parent, TypeElement type) {
        PackageElement pkg = this.getEnvironment().getElementUtils().getPackageOf(type);
        if (!pkg.isUnnamed()) {
            parent.appendText(pkg.getQualifiedName().toString());
            parent.appendText(this.getSARLGrammarKeywordAccess().getFullStopKeyword());
        }
        List<Node> link = this.getHtmlFactory().createTypeLink(type, false, null, (HtmlFactoryContext)this);
        parent.appendChildren(link);
    }

    protected void generateInterfaceLink(Element parent, TypeElement type) {
        PackageElement pkg = this.getEnvironment().getElementUtils().getPackageOf(type);
        if (!pkg.isUnnamed()) {
            parent.appendText(pkg.getQualifiedName().toString());
            parent.appendText(this.getSARLGrammarKeywordAccess().getFullStopKeyword());
        }
        List<Node> link = this.getHtmlFactory().createTypeLink(type, false, null, (HtmlFactoryContext)this);
        parent.appendChildren(link);
    }

    protected void generateAgentHierarchy(Element parent, Element hierarchy) {
        if (hierarchy.childNodeSize() > 0) {
            Element box = this.getHtmlFactory().createDivTag(parent, null);
            Element nameDiv = this.getHtmlFactory().createDivTag(box, CssStyles.HEADER_TYPE_NAME);
            nameDiv.appendText(Messages.AbstractTreeSummaryGeneratorImpl_0);
            box.appendChild((Node)hierarchy);
        }
    }

    protected void generateBehaviorHierarchy(Element parent, Element hierarchy) {
        if (hierarchy.childNodeSize() > 0) {
            Element box = this.getHtmlFactory().createDivTag(parent, null);
            Element nameDiv = this.getHtmlFactory().createDivTag(box, CssStyles.HEADER_TYPE_NAME);
            nameDiv.appendText(Messages.AbstractTreeSummaryGeneratorImpl_1);
            box.appendChild((Node)hierarchy);
        }
    }

    protected void generateCapacityHierarchy(Element parent, Element hierarchy) {
        if (hierarchy.childNodeSize() > 0) {
            Element box = this.getHtmlFactory().createDivTag(parent, null);
            Element nameDiv = this.getHtmlFactory().createDivTag(box, CssStyles.HEADER_TYPE_NAME);
            nameDiv.appendText(Messages.AbstractTreeSummaryGeneratorImpl_2);
            box.appendChild((Node)hierarchy);
        }
    }

    protected void generateSkillHierarchy(Element parent, Element hierarchy) {
        if (hierarchy.childNodeSize() > 0) {
            Element box = this.getHtmlFactory().createDivTag(parent, null);
            Element nameDiv = this.getHtmlFactory().createDivTag(box, CssStyles.HEADER_TYPE_NAME);
            nameDiv.appendText(Messages.AbstractTreeSummaryGeneratorImpl_3);
            box.appendChild((Node)hierarchy);
        }
    }

    protected void generateEventHierarchy(Element parent, Element hierarchy) {
        if (hierarchy.childNodeSize() > 0) {
            Element box = this.getHtmlFactory().createDivTag(parent, null);
            Element nameDiv = this.getHtmlFactory().createDivTag(box, CssStyles.HEADER_TYPE_NAME);
            nameDiv.appendText(Messages.AbstractTreeSummaryGeneratorImpl_4);
            box.appendChild((Node)hierarchy);
        }
    }

    protected void generateClassHierarchy(Element parent, Element hierarchy) {
        if (hierarchy.childNodeSize() > 0) {
            Element box = this.getHtmlFactory().createDivTag(parent, null);
            Element nameDiv = this.getHtmlFactory().createDivTag(box, CssStyles.HEADER_TYPE_NAME);
            nameDiv.appendText(Messages.AbstractTreeSummaryGeneratorImpl_5);
            box.appendChild((Node)hierarchy);
        }
    }

    protected void generateInterfaceHierarchy(Element parent, Element hierarchy) {
        if (hierarchy.childNodeSize() > 0) {
            Element box = this.getHtmlFactory().createDivTag(parent, null);
            Element nameDiv = this.getHtmlFactory().createDivTag(box, CssStyles.HEADER_TYPE_NAME);
            nameDiv.appendText(Messages.AbstractTreeSummaryGeneratorImpl_6);
            box.appendChild((Node)hierarchy);
        }
    }

    @Override
    protected void generateBodyContent(Element parent) {
        this.buildHierarchies();
        this.generateAgentHierarchy(parent, this.agentHierarchy);
        this.generateBehaviorHierarchy(parent, this.behaviorHierarchy);
        this.generateCapacityHierarchy(parent, this.capacityHierarchy);
        this.generateSkillHierarchy(parent, this.skillHierarchy);
        this.generateEventHierarchy(parent, this.eventHierarchy);
        this.generateClassHierarchy(parent, this.classHierarchy);
        this.generateInterfaceHierarchy(parent, this.interfaceHierarchy);
    }
}

