/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.summaries;

import com.google.common.collect.Iterables;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.summaries.AbstractSummaryGenerator;
import io.sarl.docs.doclet2.html.summaries.DeprecatedListGenerator;
import io.sarl.docs.doclet2.html.summaries.Messages;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import jdk.javadoc.doclet.Reporter;
import org.jsoup.nodes.Node;

public class DeprecatedListGeneratorImpl
extends AbstractSummaryGenerator
implements DeprecatedListGenerator {
    public DeprecatedListGeneratorImpl() {
        super(Messages.DeprecatedListGeneratorImpl_1);
    }

    @Override
    protected void generateNavigationBar() {
        this.getNavigation().generateNavigationBars((TypeElement)null, (HtmlFactoryContext)this);
    }

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.DEPRECATED);
    }

    @Override
    public void generate(Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.generate(Messages.DeprecatedListGeneratorImpl_0, "deprecated-list.html", cssStylesheets, jsScripts, environment, cliOptions, reporter);
    }

    protected void generateBodyTitle(org.jsoup.nodes.Element parent) {
        org.jsoup.nodes.Element nameDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER_TYPE_NAME);
        nameDiv.appendText(this.getLastTitle());
    }

    protected void generateAopList(org.jsoup.nodes.Element parent) {
        LinkedHashMap allElements = new LinkedHashMap();
        SortedSet<TypeElement> allDeprecatedTypes = this.getTypeRepository().getDeprecatedTypes();
        Iterable aop = Iterables.filter(allDeprecatedTypes, it -> this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_2, aop);
        Iterable agents = Iterables.filter(allDeprecatedTypes, it -> this.getElementUtils().isSarlAgent((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_3, agents);
        Iterable behaviors = Iterables.filter(allDeprecatedTypes, it -> this.getElementUtils().isSarlBehavior((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_4, behaviors);
        Iterable capacities = Iterables.filter(allDeprecatedTypes, it -> this.getElementUtils().isSarlCapacity((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_5, capacities);
        Iterable skills = Iterables.filter(allDeprecatedTypes, it -> this.getElementUtils().isSarlSkill((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_6, skills);
        Iterable events = Iterables.filter(allDeprecatedTypes, it -> this.getElementUtils().isSarlEvent((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_7, events);
        this.createSummaryBox2(Messages.DeprecatedListGeneratorImpl_8, Messages.DeprecatedListGeneratorImpl_9, Messages.DeprecatedListGeneratorImpl_10, null, parent, allElements, this.getElementUtils().getTypeElementBasenameComparator(), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.addAll(this.getHtmlFactory().createTypeLink((TypeElement)element, false, null, (HtmlFactoryContext)this));
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, false);
            return nodes;
        }, null);
    }

    protected void generateOopList(org.jsoup.nodes.Element parent) {
        LinkedHashMap allElements = new LinkedHashMap();
        SortedSet<TypeElement> allDeprecatedTypes = this.getTypeRepository().getDeprecatedTypes();
        Iterable oop = Iterables.filter(allDeprecatedTypes, it -> !this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_2, oop);
        Iterable classes = Iterables.filter(allDeprecatedTypes, it -> it.getKind() == ElementKind.CLASS && !this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_12, classes);
        Iterable interfaces = Iterables.filter(allDeprecatedTypes, it -> it.getKind() == ElementKind.INTERFACE && !this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_13, interfaces);
        Iterable enumerations = Iterables.filter(allDeprecatedTypes, it -> it.getKind() == ElementKind.ENUM && !this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_14, enumerations);
        Iterable annotations = Iterables.filter(allDeprecatedTypes, it -> it.getKind() == ElementKind.ANNOTATION_TYPE && !this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_15, annotations);
        this.createSummaryBox2(Messages.DeprecatedListGeneratorImpl_11, Messages.DeprecatedListGeneratorImpl_9, Messages.DeprecatedListGeneratorImpl_10, null, parent, allElements, this.getElementUtils().getTypeElementBasenameComparator(), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.addAll(this.getHtmlFactory().createTypeLink((TypeElement)element, false, null, (HtmlFactoryContext)this));
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, false);
            return nodes;
        }, null);
    }

    protected void generateFieldList(org.jsoup.nodes.Element parent) {
        LinkedHashMap allElements = new LinkedHashMap();
        SortedSet<VariableElement> allDeprecatedFields = this.getTypeRepository().getDeprecatedFields();
        allElements.put(Messages.DeprecatedListGeneratorImpl_17, allDeprecatedFields);
        Iterable staticFields = Iterables.filter(allDeprecatedFields, it -> this.getElementUtils().isStatic((Element)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_20, staticFields);
        Iterable concreteFields = Iterables.filter(allDeprecatedFields, it -> !this.getElementUtils().isStatic((Element)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_21, concreteFields);
        this.createSummaryBox2(Messages.DeprecatedListGeneratorImpl_16, Messages.DeprecatedListGeneratorImpl_9, Messages.DeprecatedListGeneratorImpl_10, null, parent, allElements, this.getElementUtils().getVariableElementComparator(), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            String label = element.getEnclosingElement().getSimpleName().toString() + "." + element.getSimpleName().toString();
            nodes.addAll(this.getHtmlFactory().createVariableLink((VariableElement)element, label, null, (HtmlFactoryContext)this));
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, false);
            return nodes;
        }, null);
    }

    protected void generateConstructorList(org.jsoup.nodes.Element parent) {
        LinkedHashMap allElements = new LinkedHashMap();
        Iterable allDeprecatedExecutables = Iterables.filter(this.getTypeRepository().getDeprecatedExecutables(), it -> it.getKind() == ElementKind.CONSTRUCTOR);
        allElements.put(Messages.DeprecatedListGeneratorImpl_23, allDeprecatedExecutables);
        String constructorName = this.getSARLGrammarKeywordAccess().getNewKeyword();
        this.createSummaryBox2(Messages.DeprecatedListGeneratorImpl_22, Messages.DeprecatedListGeneratorImpl_9, Messages.DeprecatedListGeneratorImpl_10, null, parent, allElements, this.getElementUtils().getExecutableElementComparator(), element -> {
            ArrayList<org.jsoup.nodes.Element> nodes = new ArrayList<org.jsoup.nodes.Element>();
            String label = element.getEnclosingElement().getSimpleName().toString() + "." + constructorName;
            List<Node> constructorPrototype = this.getHtmlFactory().getExecutablePrototype((ExecutableElement)element, label, (HtmlFactoryContext)this);
            List<Node> elementLink = this.getHtmlFactory().createExecutableLink((ExecutableElement)element, constructorPrototype, null, (HtmlFactoryContext)this);
            if (elementLink != null) {
                org.jsoup.nodes.Element emphLink = this.getHtmlFactory().createSpanTag(null, null);
                emphLink.appendChildren(elementLink);
                nodes.add(emphLink);
            }
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, false);
            return nodes;
        }, null);
    }

    protected void generateActionList(org.jsoup.nodes.Element parent) {
        LinkedHashMap allElements = new LinkedHashMap();
        Iterable allDeprecatedActions = Iterables.filter(this.getTypeRepository().getDeprecatedExecutables(), it -> it.getKind() == ElementKind.METHOD);
        allElements.put(Messages.DeprecatedListGeneratorImpl_25, allDeprecatedActions);
        Iterable staticActions = Iterables.filter((Iterable)allDeprecatedActions, it -> this.getElementUtils().isStatic((Element)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_26, staticActions);
        Iterable abstractActions = Iterables.filter((Iterable)allDeprecatedActions, it -> !this.getElementUtils().isStatic((Element)it) && this.getElementUtils().isAbstract((Element)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_27, abstractActions);
        Iterable concreteActions = Iterables.filter((Iterable)allDeprecatedActions, it -> !this.getElementUtils().isStatic((Element)it) && !this.getElementUtils().isAbstract((Element)it));
        allElements.put(Messages.DeprecatedListGeneratorImpl_28, concreteActions);
        this.createSummaryBox2(Messages.DeprecatedListGeneratorImpl_24, Messages.DeprecatedListGeneratorImpl_9, Messages.DeprecatedListGeneratorImpl_10, null, parent, allElements, this.getElementUtils().getExecutableElementComparator(), element -> {
            ArrayList<org.jsoup.nodes.Element> nodes = new ArrayList<org.jsoup.nodes.Element>();
            String methodName = element.getEnclosingElement().getSimpleName().toString() + "." + element.getSimpleName().toString();
            List<Node> methodPrototype = this.getHtmlFactory().getExecutablePrototype((ExecutableElement)element, methodName, (HtmlFactoryContext)this);
            List<Node> elementLink = this.getHtmlFactory().createExecutableLink((ExecutableElement)element, methodPrototype, null, (HtmlFactoryContext)this);
            if (elementLink != null) {
                org.jsoup.nodes.Element emphLink = this.getHtmlFactory().createSpanTag(null, null);
                emphLink.appendChildren(elementLink);
                nodes.add(emphLink);
            }
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, false);
            return nodes;
        }, null);
    }

    @Override
    protected void generateBodyContent(org.jsoup.nodes.Element parent) {
        this.generateBodyTitle(parent);
        this.generateAopList(parent);
        this.generateOopList(parent);
        this.generateFieldList(parent);
        this.generateConstructorList(parent);
        this.generateActionList(parent);
    }
}

