/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.summaries;

import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.summaries.AbstractSummaryGenerator;
import io.sarl.docs.doclet2.html.summaries.Messages;
import io.sarl.docs.doclet2.html.summaries.ModuleSummaryGenerator;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.doclet.Taglet;
import org.jsoup.nodes.Node;

public class ModuleSummaryGeneratorImpl
extends AbstractSummaryGenerator
implements ModuleSummaryGenerator {
    private ModuleElement moduleElement;

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.MODULE);
    }

    @Override
    protected void generateNavigationBar() {
        this.getNavigation().generateNavigationBars(this.moduleElement, (HtmlFactoryContext)this);
    }

    @Override
    public void generate(ModuleElement moduleElement, Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.moduleElement = moduleElement;
        String moduleName = this.getElementUtils().getElementName(moduleElement);
        this.setDefaultTitle(MessageFormat.format(Messages.ModuleSummaryGeneratorImpl_1, moduleName));
        this.generate(MessageFormat.format(Messages.ModuleSummaryGeneratorImpl_0, moduleName), this.getPathBuilder().moduleSummary(moduleElement), cssStylesheets, jsScripts, environment, cliOptions, reporter);
    }

    protected void generateBodyTitle(ModuleElement moduleElement, org.jsoup.nodes.Element parent) {
        org.jsoup.nodes.Element nameDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER_TYPE_NAME);
        nameDiv.appendText(this.getLastTitle());
    }

    protected void generatePackageList(ModuleElement moduleElement, org.jsoup.nodes.Element parent) {
        Iterable<PackageElement> packages = this.getTypeRepository().getPackagesFor(moduleElement);
        this.createSummaryBox1(Messages.ModuleSummaryGeneratorImpl_2, Messages.ModuleSummaryGeneratorImpl_3, Messages.ModuleSummaryGeneratorImpl_4, null, parent, packages, this.getElementUtils().getPackageElementComparator(), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.addAll(this.getHtmlFactory().createPackageLink((PackageElement)element, element.getQualifiedName().toString(), null, (HtmlFactoryContext)this));
            this.createFirstSentence((Element)element, (List<Node>)nodes, true, false);
            this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, true);
            return nodes;
        });
    }

    protected void generateModuleDescription(ModuleElement moduleElement, org.jsoup.nodes.Element parent) {
        ArrayList<Node> description = new ArrayList<Node>();
        this.createFullDescriptionBody(moduleElement, description, false, true);
        org.jsoup.nodes.Element descriptionDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.MODULE_DESCRIPTION);
        descriptionDiv.appendChildren(description);
    }

    protected void generateModuleIntroduction(ModuleElement moduleElement, org.jsoup.nodes.Element parent) {
        ArrayList<Node> description = new ArrayList<Node>();
        this.createFirstSentence(moduleElement, description, false, true);
        this.createBlockTagsFor(moduleElement, description, Taglet.Location.MODULE, CssStyles.MODULE_TAG_INFO);
        org.jsoup.nodes.Element descriptionDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.MODULE_DESCRIPTION);
        descriptionDiv.appendChildren(description);
    }

    @Override
    protected void generateBodyContent(org.jsoup.nodes.Element parent) {
        this.generateBodyTitle(this.moduleElement, parent);
        this.generateModuleIntroduction(this.moduleElement, parent);
        this.generatePackageList(this.moduleElement, parent);
        this.generateModuleDescription(this.moduleElement, parent);
    }
}

