/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.summaries;

import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.summaries.AbstractSummaryGenerator;
import io.sarl.docs.doclet2.html.summaries.Messages;
import io.sarl.docs.doclet2.html.summaries.OverviewSummaryGenerator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.doclet.Reporter;
import org.eclipse.xtext.xbase.lib.Pair;
import org.jsoup.nodes.Node;

public class OverviewSummaryGeneratorImpl
extends AbstractSummaryGenerator
implements OverviewSummaryGenerator {
    public OverviewSummaryGeneratorImpl() {
        super(Messages.OverviewSummaryGeneratorImpl_1);
    }

    @Override
    protected void generateNavigationBar() {
        this.getNavigation().generateNavigationBars((TypeElement)null, (HtmlFactoryContext)this);
    }

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.OVERVIEW);
    }

    @Override
    public void generate(Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.generate(Messages.OverviewSummaryGeneratorImpl_0, "overview-summary.html", cssStylesheets, jsScripts, environment, cliOptions, reporter);
    }

    protected void generateBodyTitle(org.jsoup.nodes.Element parent) {
        org.jsoup.nodes.Element nameDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER_TYPE_NAME);
        nameDiv.appendText(this.getDocumentationTitle());
    }

    protected void generateModuleList(org.jsoup.nodes.Element parent) {
        Set<ModuleElement> modules = this.getTypeRepository().getModules();
        this.createSummaryBox1(Messages.OverviewSummaryGeneratorImpl_2, Messages.OverviewSummaryGeneratorImpl_3, Messages.OverviewSummaryGeneratorImpl_4, null, parent, modules, this.getElementUtils().getModuleElementComparator(), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.addAll(this.getHtmlFactory().createModuleLink((ModuleElement)element, element.getQualifiedName().toString(), null, (HtmlFactoryContext)this));
            this.createFirstSentence((Element)element, (List<Node>)nodes, true, false);
            this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, true);
            return nodes;
        });
    }

    protected void generatePackageList(org.jsoup.nodes.Element parent, Collection<PackageElement> packages) {
        this.createSummaryBox1(Messages.OverviewSummaryGeneratorImpl_5, Messages.OverviewSummaryGeneratorImpl_6, Messages.OverviewSummaryGeneratorImpl_4, null, parent, packages, this.getElementUtils().getPackageElementComparator(), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.addAll(this.getHtmlFactory().createPackageLink((PackageElement)element, element.getQualifiedName().toString(), null, (HtmlFactoryContext)this));
            this.createFirstSentence((Element)element, (List<Node>)nodes, true, false);
            this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, true);
            return nodes;
        });
    }

    private SortedSet<PackageElement> selectPackages(SortedSet<PackageElement> remainingPackages, Pattern pattern) {
        TreeSet<PackageElement> selectedPackages = new TreeSet<PackageElement>(this.getElementUtils().getPackageElementComparator());
        Iterator iterator = remainingPackages.iterator();
        while (iterator.hasNext()) {
            PackageElement candidate = (PackageElement)iterator.next();
            Matcher matcher = pattern.matcher(candidate.getQualifiedName().toString());
            if (!matcher.matches()) continue;
            iterator.remove();
            selectedPackages.add(candidate);
        }
        return selectedPackages;
    }

    protected Collection<PackageElement> generateGroups(org.jsoup.nodes.Element parent, Collection<PackageElement> packages) {
        TreeSet<PackageElement> remainingPackages = new TreeSet<PackageElement>(this.getElementUtils().getPackageElementComparator());
        remainingPackages.addAll(packages);
        for (Pair<String, Pattern> entry : this.getDocletOptions().getGroups()) {
            SortedSet<PackageElement> selectedPackages = this.selectPackages(remainingPackages, (Pattern)entry.getValue());
            if (selectedPackages.isEmpty()) continue;
            this.createSummaryBox1((String)entry.getKey(), Messages.OverviewSummaryGeneratorImpl_6, Messages.OverviewSummaryGeneratorImpl_4, null, parent, selectedPackages, this.getElementUtils().getPackageElementComparator(), element -> {
                ArrayList<Node> nodes = new ArrayList<Node>();
                nodes.addAll(this.getHtmlFactory().createPackageLink((PackageElement)element, element.getQualifiedName().toString(), null, (HtmlFactoryContext)this));
                this.createFirstSentence((Element)element, (List<Node>)nodes, true, false);
                this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, true);
                return nodes;
            });
        }
        return remainingPackages;
    }

    @Override
    protected void generateBodyContent(org.jsoup.nodes.Element parent) {
        this.generateBodyTitle(parent);
        Collection<PackageElement> packages = this.generateGroups(parent, new ArrayList<PackageElement>(this.getTypeRepository().getPackages()));
        this.generateModuleList(parent);
        this.generatePackageList(parent, packages);
    }
}

