/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.summaries;

import com.google.common.collect.Iterables;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.summaries.AbstractSummaryGenerator;
import io.sarl.docs.doclet2.html.summaries.Messages;
import io.sarl.docs.doclet2.html.summaries.PackageSummaryGenerator;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.doclet.Taglet;
import org.jsoup.nodes.Node;

public class PackageSummaryGeneratorImpl
extends AbstractSummaryGenerator
implements PackageSummaryGenerator {
    private PackageElement packageElement;

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.PACKAGE);
    }

    @Override
    protected void generateNavigationBar() {
        this.getNavigation().generateNavigationBars(this.packageElement, (HtmlFactoryContext)this);
    }

    @Override
    public void generate(PackageElement packageElement, Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        this.packageElement = packageElement;
        String packageName = this.getElementUtils().getElementName(packageElement);
        this.setDefaultTitle(MessageFormat.format(Messages.PackageSummaryGeneratorImpl_1, packageName));
        this.generate(MessageFormat.format(Messages.PackageSummaryGeneratorImpl_0, packageName), this.getPathBuilder().packageSummary(packageElement), cssStylesheets, jsScripts, environment, cliOptions, reporter);
    }

    protected void generateBodyTitle(PackageElement packageElement, org.jsoup.nodes.Element parent) {
        org.jsoup.nodes.Element nameDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER_TYPE_NAME);
        nameDiv.appendText(this.getLastTitle());
    }

    protected void generatePackageDescription(PackageElement packageElement, org.jsoup.nodes.Element parent) {
        ArrayList<Node> description = new ArrayList<Node>();
        this.createFullDescriptionBody(packageElement, description, false, true);
        org.jsoup.nodes.Element descriptionDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.PACKAGE_DESCRIPTION);
        descriptionDiv.appendChildren(description);
    }

    protected void generatePackageIntroduction(PackageElement packageElement, org.jsoup.nodes.Element parent) {
        ArrayList<Node> description = new ArrayList<Node>();
        this.createFirstSentence(packageElement, description, false, true);
        this.createBlockTagsFor(packageElement, description, Taglet.Location.PACKAGE, CssStyles.PACKAGE_TAG_INFO);
        org.jsoup.nodes.Element descriptionDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.PACKAGE_DESCRIPTION);
        descriptionDiv.appendChildren(description);
    }

    protected void generateAopList(PackageElement packageElement, org.jsoup.nodes.Element parent) {
        LinkedHashMap allElements = new LinkedHashMap();
        SortedSet<TypeElement> allTypes = this.getTypeRepository().getTypesInPackage(packageElement);
        Iterable aop = Iterables.filter(allTypes, it -> this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_3, aop);
        Iterable agents = Iterables.filter(allTypes, it -> this.getElementUtils().isSarlAgent((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_10, agents);
        Iterable behaviors = Iterables.filter(allTypes, it -> this.getElementUtils().isSarlBehavior((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_11, behaviors);
        Iterable capacities = Iterables.filter(allTypes, it -> this.getElementUtils().isSarlCapacity((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_12, capacities);
        Iterable skills = Iterables.filter(allTypes, it -> this.getElementUtils().isSarlSkill((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_13, skills);
        Iterable events = Iterables.filter(allTypes, it -> this.getElementUtils().isSarlEvent((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_14, events);
        this.createSummaryBox2(Messages.PackageSummaryGeneratorImpl_9, Messages.PackageSummaryGeneratorImpl_8, Messages.PackageSummaryGeneratorImpl_15, null, parent, allElements, this.getElementUtils().getTypeElementBasenameComparator(), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.addAll(this.getHtmlFactory().createTypeLink((TypeElement)element, false, null, (HtmlFactoryContext)this));
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            this.createFirstSentence((Element)element, (List<Node>)nodes, false, false);
            this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, true);
            return nodes;
        }, null);
    }

    protected void generateOopList(PackageElement packageElement, org.jsoup.nodes.Element parent) {
        LinkedHashMap allElements = new LinkedHashMap();
        SortedSet<TypeElement> allTypes = this.getTypeRepository().getTypesInPackage(packageElement);
        Iterable oop = Iterables.filter(allTypes, it -> !this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_3, oop);
        Iterable classes = Iterables.filter(allTypes, it -> it.getKind() == ElementKind.CLASS && !this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_4, classes);
        Iterable interfaces = Iterables.filter(allTypes, it -> it.getKind() == ElementKind.INTERFACE && !this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_5, interfaces);
        Iterable enumerations = Iterables.filter(allTypes, it -> it.getKind() == ElementKind.ENUM && !this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_6, enumerations);
        Iterable annotations = Iterables.filter(allTypes, it -> it.getKind() == ElementKind.ANNOTATION_TYPE && !this.getElementUtils().isAopElement((TypeElement)it));
        allElements.put(Messages.PackageSummaryGeneratorImpl_7, annotations);
        this.createSummaryBox2(Messages.PackageSummaryGeneratorImpl_2, Messages.PackageSummaryGeneratorImpl_8, Messages.PackageSummaryGeneratorImpl_15, null, parent, allElements, this.getElementUtils().getTypeElementBasenameComparator(), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.addAll(this.getHtmlFactory().createTypeLink((TypeElement)element, false, null, (HtmlFactoryContext)this));
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            this.createFirstSentence((Element)element, (List<Node>)nodes, false, false);
            this.createShortDeprecationMessage((Element)element, (List<Node>)nodes, true);
            return nodes;
        }, null);
    }

    @Override
    protected void generateBodyContent(org.jsoup.nodes.Element parent) {
        this.generateBodyTitle(this.packageElement, parent);
        this.generatePackageIntroduction(this.packageElement, parent);
        this.generateAopList(this.packageElement, parent);
        this.generateOopList(this.packageElement, parent);
        this.generatePackageDescription(this.packageElement, parent);
    }
}

