/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.taglets;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.sun.source.doctree.DocTree;
import io.sarl.docs.doclet2.framework.ElementUtils;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.HtmlFactory;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContentExtractor;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.HtmlTags;
import io.sarl.docs.doclet2.html.taglets.SarlTaglet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import jdk.javadoc.doclet.Taglet;
import org.jsoup.nodes.Node;

public abstract class AbstractSarlTaglet
implements SarlTaglet {
    private HtmlFactory htmlFactory;
    private ElementUtils elementUtils;
    private DocletOptions docletOptions;
    private final String name;
    private final boolean inline;
    private final Set<Taglet.Location> locations;

    public AbstractSarlTaglet(String name, boolean inline, Taglet.Location ... locations) {
        this.name = name;
        this.inline = inline;
        this.locations = inline ? Collections.emptySet() : EnumSet.copyOf(Arrays.asList(locations));
    }

    @Inject
    public void setHtmlFactory(HtmlFactory factory) {
        this.htmlFactory = factory;
    }

    public HtmlFactory getHtmlFactory() {
        return this.htmlFactory;
    }

    @Inject
    public void setDocletOptions(DocletOptions options) {
        this.docletOptions = options;
    }

    public DocletOptions getDocletOptions() {
        return this.docletOptions;
    }

    @Inject
    public void setElementUtils(ElementUtils utils) {
        this.elementUtils = utils;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.isInlineTag()) {
            buf.append("@");
        }
        buf.append(this.getName());
        buf.append(":");
        buf.append(this.getAllowedLocations());
        return buf.toString();
    }

    @Override
    public String toString(List<? extends DocTree> tags, Element element) {
        org.jsoup.nodes.Element elt = new org.jsoup.nodes.Element(HtmlTags.pseudoTag("empty"));
        if (this.appendNode(elt, tags, element, null, null, null)) {
            return elt.html();
        }
        return "";
    }

    @Override
    public Set<Taglet.Location> getAllowedLocations() {
        return Collections.unmodifiableSet(this.locations);
    }

    @Override
    public boolean isInlineTag() {
        return this.inline;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected boolean appendCommentTextWithSpace(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element documentedElement, CssStyles style, HtmlFactoryContext context) {
        return this.appendCommentText(parent, tags, documentedElement, null, true, style, context);
    }

    protected boolean appendCommentTextWithComa(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element documentedElement, CssStyles style, HtmlFactoryContext context) {
        return this.appendCommentText(parent, tags, documentedElement, ",", true, style, context);
    }

    protected boolean appendCommentText(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element documentedElement, String separator, boolean createSpan, CssStyles style, HtmlFactoryContext context) {
        if (!tags.isEmpty()) {
            Iterator<? extends DocTree> contentElements = tags.iterator();
            org.jsoup.nodes.Element outputNode = createSpan ? this.getHtmlFactory().createSpanTag(null, style) : parent;
            HtmlFactory.CommentTextMemory memory = this.getHtmlFactory().createCommentTextMemory(outputNode, documentedElement, context);
            boolean changed = this.getHtmlFactory().createCommentText(memory, contentElements.next(), style);
            while (contentElements.hasNext()) {
                if (!Strings.isNullOrEmpty((String)separator)) {
                    outputNode.appendText(separator);
                }
                this.getHtmlFactory().createSecableSpace(outputNode);
                changed = this.getHtmlFactory().createCommentText(memory, contentElements.next(), style) || changed;
            }
            if (changed && createSpan) {
                parent.appendChild((Node)outputNode);
            }
            return changed;
        }
        return false;
    }

    protected void appendChildren(org.jsoup.nodes.Element parent, Iterable<? extends Node> children) {
        assert (parent != null) : "parent argument must not be null";
        assert (children != null) : "children argument must not be null";
        for (Node node : children) {
            if (node == null) continue;
            this.appendChildren(parent, node);
        }
    }

    protected void appendChildren(org.jsoup.nodes.Element parent, Node child) {
        assert (parent != null) : "parent argument must not be null";
        assert (child != null) : "child argument must not be null";
        if (HtmlTags.isPseudoTag(child.nodeName()) && child instanceof Element) {
            for (Node chld : child.childNodes()) {
                parent.appendChild(chld.clone());
            }
        } else {
            parent.appendChild(child.clone());
        }
    }

    @Override
    public boolean appendNode(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element element, DocTree sourceDocumentation, CssStyles style, HtmlFactoryContentExtractor referenceExtractor) {
        throw new RuntimeException("Unexpected use of the taglet " + this.getClass().getSimpleName());
    }
}

