/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.taglets.block;

import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContentExtractor;
import io.sarl.docs.doclet2.html.taglets.AbstractSarlTaglet;
import io.sarl.docs.doclet2.html.taglets.block.Messages;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Taglet;

public class DeprecatedTaglet
extends AbstractSarlTaglet {
    public static final String TAGLET_NAME = "deprecated";

    public DeprecatedTaglet() {
        super(TAGLET_NAME.toLowerCase(), false, Taglet.Location.values());
    }

    protected CssStyles getTextCssStyle(CssStyles original) {
        return CssStyles.TAG_DEPRECATED_COMMENT;
    }

    @Override
    public boolean appendNode(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element element, DocTree sourceDocumentation, CssStyles style, HtmlFactoryContentExtractor referenceExtractor) {
        LinkedList<Element> candidates = new LinkedList<Element>();
        candidates.addLast(element);
        while (!candidates.isEmpty()) {
            Element current = (Element)candidates.removeFirst();
            boolean deprecated = referenceExtractor.getContext().getEnvironment().getElementUtils().isDeprecated(current);
            if (deprecated) {
                boolean bl = current != element;
                if (!bl) continue;
                org.jsoup.nodes.Element prefix = this.getHtmlFactory().createSpanTag(parent, this.getTextCssStyle(style));
                prefix.appendText(MessageFormat.format(Messages.DeprecatedTaglet_0, element.getSimpleName()));
                this.getHtmlFactory().createSecableSpace(parent);
                continue;
            }
            Element element2 = current.getEnclosingElement();
            if (element2 == null) continue;
            candidates.addLast(element2);
        }
        boolean changed = false;
        for (DocTree docTree : tags) {
            if (changed) {
                if (!parent.html().toString().endsWith(".")) {
                    parent.appendText(".");
                }
                this.getHtmlFactory().createSecableSpace(parent);
            }
            if (docTree instanceof DeprecatedTree) {
                DeprecatedTree dt = (DeprecatedTree)docTree;
                changed = this.appendCommentTextWithSpace(parent, dt.getBody(), element, this.getTextCssStyle(style), referenceExtractor.getContext()) || changed;
                continue;
            }
            if (!(docTree instanceof UnknownBlockTagTree)) continue;
            UnknownBlockTagTree ubtt = (UnknownBlockTagTree)docTree;
            changed = this.appendCommentTextWithSpace(parent, ubtt.getContent(), element, this.getTextCssStyle(style), referenceExtractor.getContext()) || changed;
        }
        boolean deprecated0 = referenceExtractor.getContext().getEnvironment().getElementUtils().isDeprecated(element);
        if (!deprecated0) {
            referenceExtractor.getContext().getReporter().print(Diagnostic.Kind.WARNING, MessageFormat.format(Messages.DeprecatedTaglet_1, this.getElementUtils().getFullyQualifiedName(element, true), Deprecated.class.getName()));
        }
        return changed;
    }
}

