/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.taglets.block;

import com.google.common.base.Strings;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContentExtractor;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.taglets.AbstractSarlTaglet;
import io.sarl.docs.doclet2.html.taglets.block.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Taglet;
import org.jsoup.nodes.Node;

public class OptionalParamTaglet
extends AbstractSarlTaglet {
    public static final String TAGLET_NAME = "optionalparam";

    public OptionalParamTaglet() {
        super(TAGLET_NAME.toLowerCase(), false, Taglet.Location.TYPE, Taglet.Location.CONSTRUCTOR, Taglet.Location.METHOD);
    }

    protected CssStyles getTextCssStyle(CssStyles original) {
        return CssStyles.TAG_OPTIONALPARAM_COMMENT;
    }

    @Override
    public String getTagBlockLabel() {
        return Messages.OptionalParamTaglet_0;
    }

    @Override
    public boolean appendNode(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element element, DocTree sourceDocumentation, CssStyles style, HtmlFactoryContentExtractor referenceExtractor) {
        ArrayList<ParamTree> genericParameters = new ArrayList<ParamTree>();
        ArrayList<ParamTree> regularParameters = new ArrayList<ParamTree>();
        for (DocTree docTree : tags) {
            if (!(docTree instanceof ParamTree)) continue;
            ParamTree paramTree = (ParamTree)docTree;
            String name = paramTree.getName().getName().toString();
            if (Strings.isNullOrEmpty((String)name)) {
                referenceExtractor.getContext().getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.OptionalParamTaglet_1, element.getSimpleName().toString()));
                continue;
            }
            if (paramTree.isTypeParameter()) {
                genericParameters.add(paramTree);
                continue;
            }
            regularParameters.add(paramTree);
        }
        CssStyles rstyle = this.getTextCssStyle(style);
        boolean bl2 = this.appendParameters(false, genericParameters, Messages.OptionalParamTaglet_2, parent, element, rstyle, referenceExtractor.getContext());
        bl2 = this.appendParameters(bl2, regularParameters, Messages.OptionalParamTaglet_3, parent, element, rstyle, referenceExtractor.getContext());
        return bl2;
    }

    private boolean appendParameters(boolean previousChange, List<ParamTree> parameters, String headModel, org.jsoup.nodes.Element parent, Element element, CssStyles style, HtmlFactoryContext context) {
        boolean changed = previousChange;
        for (ParamTree parameter : parameters) {
            if (changed) {
                parent.appendChild((Node)this.getHtmlFactory().createNewLineTag());
            }
            String paramName = parameter.getName().getName().toString();
            parent.appendText(MessageFormat.format(headModel, paramName));
            this.getHtmlFactory().createSecableSpace(parent);
            boolean hasDescription = this.appendCommentTextWithSpace(parent, Collections.singletonList(parameter), element, this.getTextCssStyle(style), context);
            if (!hasDescription) {
                context.getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.OptionalParamTaglet_1, paramName, element.getSimpleName().toString()));
            }
            changed = true;
        }
        return changed;
    }
}

