/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.taglets.block;

import com.google.common.collect.Iterables;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ReturnTree;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContentExtractor;
import io.sarl.docs.doclet2.html.taglets.AbstractSarlTaglet;
import io.sarl.docs.doclet2.html.taglets.block.Messages;
import java.util.List;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Taglet;
import org.jsoup.nodes.Node;

public class ReturnTaglet
extends AbstractSarlTaglet {
    public static final String TAGLET_NAME = "return";

    public ReturnTaglet() {
        super(TAGLET_NAME.toLowerCase(), false, Taglet.Location.METHOD);
    }

    protected CssStyles getTextCssStyle(CssStyles original) {
        return CssStyles.TAG_RETURN_COMMENT;
    }

    @Override
    public String getTagBlockLabel() {
        return Messages.ReturnTaglet_0;
    }

    @Override
    public boolean appendNode(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element element, DocTree sourceDocumentation, CssStyles style, HtmlFactoryContentExtractor context) {
        Iterable returns = Iterables.filter(tags, ReturnTree.class);
        CssStyles rstyle = this.getTextCssStyle(style);
        boolean changed = false;
        for (ReturnTree returnEntry : returns) {
            boolean hasDescription;
            if (changed) {
                parent.appendChild((Node)this.getHtmlFactory().createNewLineTag());
            }
            if (!(hasDescription = this.appendCommentTextWithSpace(parent, returnEntry.getDescription(), element, rstyle, context.getContext()))) {
                context.getContext().getReporter().print(Diagnostic.Kind.ERROR, Messages.ReturnTaglet_1);
            }
            changed = changed || hasDescription;
        }
        return changed;
    }
}

