/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.taglets.block;

import com.google.common.collect.Iterables;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ThrowsTree;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContentExtractor;
import io.sarl.docs.doclet2.html.taglets.AbstractSarlTaglet;
import io.sarl.docs.doclet2.html.taglets.block.Messages;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Taglet;

public class ThrowsTaglet
extends AbstractSarlTaglet {
    public static final String TAGLET_NAME = "throws";

    public ThrowsTaglet() {
        this(TAGLET_NAME.toLowerCase());
    }

    public ThrowsTaglet(String name) {
        super(name, false, Taglet.Location.CONSTRUCTOR, Taglet.Location.METHOD);
    }

    protected CssStyles getTextCssStyle(CssStyles original) {
        return CssStyles.TAG_THROWS_COMMENT;
    }

    @Override
    public String getTagBlockLabel() {
        return Messages.ThrowsTaglet_0;
    }

    @Override
    public boolean appendNode(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element element, DocTree sourceDocumentation, CssStyles style, HtmlFactoryContentExtractor context) {
        Iterable throwsList0 = Iterables.filter(tags, ThrowsTree.class);
        Iterable throwsList = Iterables.filter((Iterable)throwsList0, it -> {
            ReferenceTree reference = it.getExceptionName();
            if (reference == null) {
                context.getContext().getReporter().print(Diagnostic.Kind.ERROR, Messages.ThrowsTaglet_1);
                return false;
            }
            return true;
        });
        CssStyles rstyle = this.getTextCssStyle(style);
        boolean changed = false;
        if (throwsList.iterator().hasNext()) {
            org.jsoup.nodes.Element ulElement = this.getHtmlFactory().createUlTag(parent, rstyle);
            for (ThrowsTree throwsEntry : throwsList) {
                ReferenceTree reference = throwsEntry.getExceptionName();
                org.jsoup.nodes.Element tmpElement0 = this.getHtmlFactory().createSpanTag(null, null);
                this.appendCommentTextWithSpace(tmpElement0, Collections.singletonList(reference), element, rstyle, context.getContext());
                org.jsoup.nodes.Element tmpElement1 = this.getHtmlFactory().createSpanTag(null, null);
                boolean hasDescription = this.appendCommentTextWithSpace(tmpElement1, throwsEntry.getDescription(), element, rstyle, context.getContext());
                if (!hasDescription) {
                    context.getContext().getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.ThrowsTaglet_2, reference.toString()));
                }
                String text = MessageFormat.format(Messages.ThrowsTaglet_3, tmpElement0.html(), tmpElement1.html());
                org.jsoup.nodes.Element liElement = this.getHtmlFactory().createLiTag(ulElement, rstyle);
                liElement.append(text);
                changed = true;
            }
        }
        return changed;
    }
}

