/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.taglets.inline;

import com.google.common.collect.Iterables;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ProvidesTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UsesTree;
import com.sun.source.doctree.VersionTree;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContentExtractor;
import io.sarl.docs.doclet2.html.taglets.AbstractSarlTaglet;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import jdk.javadoc.doclet.Taglet;

public class InheritDocTaglet
extends AbstractSarlTaglet {
    public static final String TAGLET_NAME = "inheritDoc";

    public InheritDocTaglet() {
        super(TAGLET_NAME.toLowerCase(), true, new Taglet.Location[0]);
    }

    @Override
    public boolean appendNode(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element element, DocTree sourceDocumentation, CssStyles style, HtmlFactoryContentExtractor referenceExtractor) {
        if (sourceDocumentation instanceof BlockTagTree) {
            return this.appendFromInheritedBlockTagDocumentation(parent, element, sourceDocumentation, referenceExtractor);
        }
        return this.appendFromInheritedMainDocumentation(parent, element, sourceDocumentation, referenceExtractor);
    }

    private static boolean isSameBlockTag(DocTree hidder, DocTree hidden) {
        BlockTagTree phidder;
        if (hidder instanceof ParamTree) {
            phidder = (ParamTree)hidder;
            if (hidden instanceof ParamTree) {
                ParamTree phidden = (ParamTree)hidden;
                return phidder.isTypeParameter() == phidden.isTypeParameter() && phidder.getName().toString().equals(phidden.getName().toString());
            }
        }
        if (hidder instanceof ThrowsTree) {
            phidder = (ThrowsTree)hidder;
            if (hidden instanceof ThrowsTree) {
                ThrowsTree phidden = (ThrowsTree)hidden;
                return phidder.getExceptionName().getSignature().equals(phidden.getExceptionName().getSignature());
            }
        }
        if (hidder instanceof ProvidesTree) {
            phidder = (ProvidesTree)hidder;
            if (hidden instanceof ProvidesTree) {
                ProvidesTree phidden = (ProvidesTree)hidden;
                return phidder.getServiceType().getSignature().equals(phidden.getServiceType().getSignature());
            }
        }
        if (hidder instanceof UsesTree) {
            phidder = (UsesTree)hidder;
            if (hidden instanceof UsesTree) {
                UsesTree phidden = (UsesTree)hidden;
                return phidder.getServiceType().getSignature().equals(phidden.getServiceType().getSignature());
            }
        }
        return hidder instanceof AuthorTree && hidden instanceof AuthorTree || hidder instanceof DeprecatedTree && hidden instanceof DeprecatedTree || hidder instanceof ReturnTree && hidden instanceof ReturnTree || hidder instanceof SeeTree && hidden instanceof SeeTree || hidder instanceof SinceTree && hidden instanceof SinceTree || hidder instanceof VersionTree && hidden instanceof VersionTree;
    }

    protected boolean appendFromInheritedBlockTagDocumentation(org.jsoup.nodes.Element parent, Element element, DocTree sourceDocumentation, HtmlFactoryContentExtractor referenceExtractor) {
        List<? extends DocTree> blocks;
        DocTree inheritedDoc;
        SarlDocletEnvironment env = referenceExtractor.getContext().getEnvironment();
        DocCommentTree fullComment = referenceExtractor.getContext().getDocUtils().getInheritedFullDocumentation(element, env);
        if (fullComment != null && (inheritedDoc = (DocTree)Iterables.find(blocks = fullComment.getBlockTags(), it -> InheritDocTaglet.isSameBlockTag(sourceDocumentation, it))) != null) {
            return this.appendCommentText(parent, Collections.singletonList(inheritedDoc), element, " ", false, null, referenceExtractor.getContext());
        }
        return false;
    }

    protected boolean appendFromInheritedMainDocumentation(org.jsoup.nodes.Element parent, Element element, DocTree sourceDocumentation, HtmlFactoryContentExtractor referenceExtractor) {
        SarlDocletEnvironment env = referenceExtractor.getContext().getEnvironment();
        List<? extends DocTree> documentation = referenceExtractor.getContext().getDocUtils().getInheritedDocumentation(element, env);
        if (!documentation.isEmpty()) {
            return this.appendCommentText(parent, documentation, element, " ", false, null, referenceExtractor.getContext());
        }
        return false;
    }
}

