/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.taglets.inline;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.ReferenceTree;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContentExtractor;
import io.sarl.docs.doclet2.html.taglets.AbstractSarlTaglet;
import io.sarl.docs.doclet2.html.taglets.inline.Messages;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Taglet;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class LinkTaglet
extends AbstractSarlTaglet {
    public static final String TAGLET_NAME = "link";

    public LinkTaglet() {
        super(TAGLET_NAME.toLowerCase(), true, new Taglet.Location[0]);
    }

    private static String formatLinkLabel(ReferenceTree referenceTree) {
        String sig = Strings.isNullOrEmpty((String)referenceTree.getSignature()) ? referenceTree.toString() : referenceTree.getSignature();
        int idx = sig.indexOf("#");
        if (idx >= 0 && idx < sig.length() - 1) {
            return sig.substring(idx + 1);
        }
        return sig;
    }

    @Override
    public boolean appendNode(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element element, DocTree sourceDocumentation, CssStyles style, HtmlFactoryContentExtractor contentExtractor) {
        LinkTree node = (LinkTree)Iterables.find(tags, it -> it instanceof LinkTree);
        org.jsoup.nodes.Element labelElement = contentExtractor.extractSimpleText(node.getLabel());
        if (node.getReference() == null) {
            this.appendChildren(parent, labelElement.childNodes());
            return true;
        }
        List<TextNode> labelNode = labelElement.childNodeSize() == 0 ? Collections.singletonList(new TextNode(LinkTaglet.formatLinkLabel(node.getReference()))) : labelElement.childNodes();
        boolean isplain = node.getKind() == DocTree.Kind.LINK_PLAIN;
        List<Node> referenceNode = contentExtractor.extractReference(node.getReference(), labelNode, isplain);
        if (referenceNode == null) {
            this.appendChildren(parent, labelElement.childNodes());
            contentExtractor.getContext().getReporter().print(Diagnostic.Kind.ERROR, Messages.LinkTaglet_0);
            return false;
        }
        this.appendChildren(parent, referenceNode);
        return true;
    }
}

