/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.taglets.inline;

import com.google.common.collect.Iterables;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ReferenceTree;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContentExtractor;
import io.sarl.docs.doclet2.html.taglets.AbstractSarlTaglet;
import io.sarl.docs.doclet2.html.taglets.inline.Messages;
import java.text.MessageFormat;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Taglet;
import org.eclipse.xtext.util.Strings;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class ValueTaglet
extends AbstractSarlTaglet {
    public static final String TAGLET_NAME = "value";

    public ValueTaglet() {
        super(TAGLET_NAME.toLowerCase(), true, new Taglet.Location[0]);
    }

    protected CssStyles getCssStyle(CssStyles base) {
        return CssStyles.TAG_VALUE_COMMENT;
    }

    @Override
    public boolean appendNode(org.jsoup.nodes.Element parent, List<? extends DocTree> tags, Element element, DocTree sourceDocumentation, CssStyles style, HtmlFactoryContentExtractor contentExtractor) {
        ReferenceTree node = (ReferenceTree)Iterables.find(tags, it -> it instanceof ReferenceTree);
        if (node == null) {
            contentExtractor.getContext().getReporter().print(Diagnostic.Kind.ERROR, Messages.ValueTaglet_0);
            return false;
        }
        Element referencedElement = contentExtractor.extractReferencedElement(node);
        if (referencedElement == null) {
            contentExtractor.getContext().getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.ValueTaglet_1, node.toString()));
            return false;
        }
        if (!(referencedElement instanceof VariableElement)) {
            contentExtractor.getContext().getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.ValueTaglet_2, node.toString()));
            return false;
        }
        VariableElement variable = (VariableElement)referencedElement;
        Object constantValue = variable.getConstantValue();
        if (constantValue == null) {
            contentExtractor.getContext().getReporter().print(Diagnostic.Kind.ERROR, MessageFormat.format(Messages.ValueTaglet_3, variable.getSimpleName(), node.toString()));
            return false;
        }
        TextNode textNode = new TextNode(this.formatValue(constantValue));
        CssStyles theStyle = this.getCssStyle(style);
        if (theStyle != null) {
            org.jsoup.nodes.Element spanNode = this.getHtmlFactory().createSpanTag(parent, theStyle);
            spanNode.appendChild((Node)textNode);
        } else {
            parent.appendChild((Node)textNode);
        }
        return true;
    }

    protected String formatValue(Object value) {
        return ValueTaglet.defaultFormatValue(value);
    }

    public static String defaultFormatValue(Object value) {
        if (value instanceof CharSequence) {
            return "\"" + Strings.convertToJavaString((String)value.toString()) + "\"";
        }
        return value.toString();
    }
}

