/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.docs.doclet2.html.types;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import io.sarl.docs.doclet2.framework.SarlDocletEnvironment;
import io.sarl.docs.doclet2.html.framework.AbstractDocumentationGenerator;
import io.sarl.docs.doclet2.html.framework.CssStyles;
import io.sarl.docs.doclet2.html.framework.DocletOptions;
import io.sarl.docs.doclet2.html.framework.HtmlFactory;
import io.sarl.docs.doclet2.html.framework.HtmlFactoryContext;
import io.sarl.docs.doclet2.html.framework.Navigation;
import io.sarl.docs.doclet2.html.taglets.inline.ValueTaglet;
import io.sarl.docs.doclet2.html.types.Messages;
import io.sarl.docs.doclet2.html.types.TypeDocumentationGenerator;
import io.sarl.lang.core.annotation.FiredEvent;
import io.sarl.lang.core.annotation.ImportedCapacityFeature;
import io.sarl.lang.core.annotation.PerceptGuardEvaluator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor14;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.doclet.Taglet;
import org.eclipse.xtext.xbase.lib.Functions;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public abstract class AbstractTypeDocumentationGenerator
extends AbstractDocumentationGenerator
implements TypeDocumentationGenerator {
    public static final String ID_EVENT_HANDLER_DETAILS = "event.handlers.details.box";
    public static final String ID_ACTION_DETAILS = "action.details.box";
    public static final String ID_CONSTRUCTOR_DETAILS = "constructors.details.box";
    public static final String ID_FIELD_DETAILS = "fields.details.box";
    public static final String ID_PROPERTY_DETAILS = "properties.details.box";
    public static final String ID_ENUM_CONSTANT_DETAILS = "enumeration.constants.details.box";
    public static final String ID_CAPACITY_USE_SUMMARY = "capacity.uses.summary.box";
    public static final String ID_PROPERTY_SUMMARY = "properties.summary.box";
    public static final String ID_FIELD_SUMMARY = "fields.summary.box";
    public static final String ID_ENUM_CONSTANT_SUMMARY = "enumeration.constants.summary.box";
    public static final String ID_NESTED_CLASS_SUMMARY = "nested.classes.summary.box";
    public static final String ID_CONSTRUCTOR_SUMMARY = "constructors.summary.box";
    public static final String ID_ACTION_SUMMARY = "actions.summary.box";
    public static final String ID_EVENT_HANDLER_SUMMARY = "event.handlers.summary.box";

    @Override
    protected void initNavigation(Navigation navigation) {
        navigation.setKind(Navigation.NavigationKind.TYPE);
    }

    @Override
    protected String getDocumentTitleFor(String elementName) {
        return MessageFormat.format(Messages.AbstractTypeDocumentationGenerator_3, elementName);
    }

    @Override
    public final void generate(TypeElement type, Collection<Path> cssStylesheets, Collection<Path> jsScripts, SarlDocletEnvironment environment, DocletOptions cliOptions, Reporter reporter) throws Exception {
        try {
            this.initGenerator(cssStylesheets, jsScripts, reporter, environment, cliOptions);
            this.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.AbstractTypeDocumentationGenerator_0, type.getQualifiedName().toString()));
            this.computePaths(type.getQualifiedName().toString(), true);
            Path outputPath = cliOptions.getOutputDirectory().resolve(this.getRelativePath());
            Document document = this.getHtmlFactory().createDocument(cliOptions.getCharset(), this);
            String title = this.getDocumentTitleFor(type.getSimpleName().toString());
            this.setLastTitle(title);
            Element htmlTag = this.getHtmlAccessor().getRootElement(document);
            this.generateTypeDocumentation(type, environment, htmlTag);
            if (!cliOptions.isFakeOutput()) {
                this.getReporter().print(Diagnostic.Kind.NOTE, MessageFormat.format(Messages.AbstractTypeDocumentationGenerator_1, outputPath.toString()));
                AbstractTypeDocumentationGenerator.writeDocument(outputPath, document);
            }
        }
        catch (Exception ex) {
            Reporter rep = this.getReporter();
            if (rep == null) {
                throw new RuntimeException(ex);
            }
            StringWriter writer = new StringWriter();
            try (PrintWriter printWriter = new PrintWriter(writer);){
                String msg = ex.getLocalizedMessage();
                if (Strings.isNullOrEmpty((String)msg)) {
                    msg = ex.getMessage();
                }
                if (Strings.isNullOrEmpty((String)msg)) {
                    msg = ex.getClass().getName();
                }
                printWriter.print(msg);
                printWriter.print(" (");
                printWriter.print(type.getQualifiedName().toString());
                printWriter.println(")");
                ex.printStackTrace(printWriter);
            }
            rep.print(Diagnostic.Kind.ERROR, writer.toString());
        }
    }

    protected void generateTypeDocumentation(TypeElement type, SarlDocletEnvironment environment, Element htmlTag) throws Exception {
        List<Node> linkContent = this.getHtmlFactory().createModuleLink(this.getEnvironment().getElementUtils().getModuleOf(type), Messages.AbstractTypeDocumentationGenerator_2, CssStyles.NAVIGATION, (HtmlFactoryContext)this);
        this.getNavigation().setModuleLink(linkContent);
        this.generateHtmlHeader(htmlTag, type);
        this.generateHtmlBody(htmlTag, type);
    }

    protected Element generateHtmlHeader(Element htmlTag, TypeElement typeElement) {
        Element headerTree = this.getHtmlFactory().createHeadTag(htmlTag);
        this.getHtmlFactory().createTitleTag(headerTree, this.getLastTitle());
        Path pathToRoot = this.getPathToRoot();
        for (Path cssStyle : this.getCssStylesheets()) {
            this.getHtmlFactory().createCssLinkTag(headerTree, pathToRoot.resolve(cssStyle));
        }
        for (Path jsScript : this.getJsScripts()) {
            this.getHtmlFactory().createJsLinkTag(headerTree, pathToRoot.resolve(jsScript));
        }
        return headerTree;
    }

    protected Element generateHtmlBody(Element htmlTag, TypeElement typeElement) {
        Element bodyTag = this.getHtmlFactory().createBodyTag(htmlTag);
        this.generateBodyHeader(bodyTag, typeElement);
        Element contentTag = this.getHtmlFactory().createDivTag(bodyTag, CssStyles.CONTENT);
        this.generateTypeIntroduction(contentTag, typeElement);
        this.generateTypeTree(contentTag, typeElement);
        this.generateTypeInfo(contentTag, typeElement);
        this.generateMemberSummary(contentTag, typeElement);
        this.generateMemberDetails(contentTag, typeElement);
        this.generateBodyFooter(bodyTag, typeElement);
        this.getNavigation().generateNavigationBars(typeElement, (HtmlFactoryContext)this);
        return bodyTag;
    }

    protected void generateMemberDetails(Element parent, TypeElement typeElement) {
        this.generateEnumConstantsDetails(parent, typeElement);
        this.generatePropertiesDetails(parent, typeElement);
        this.generateFieldsDetails(parent, typeElement);
        this.generateConstructorsDetails(parent, typeElement);
        this.generateActionsDetails(parent, typeElement);
        this.generateEventHandlersDetails(parent, typeElement);
    }

    private AnnotationValue getPeceptGuardEvaluatorAnnotationValue(AnnotatedConstruct element) {
        if (element != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                TypeElement type = this.getElementUtils().asTypeElement(annotationMirror.getAnnotationType(), this.getEnvironment().getTypeUtils());
                if (!PerceptGuardEvaluator.class.getName().equals(type.getQualifiedName().toString()) || annotationMirror.getElementValues().isEmpty()) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    ExecutableElement method = entry.getKey();
                    TypeMirror returnType = method.getReturnType();
                    if (!"typeParameters".equals(method.getSimpleName().toString()) || returnType.getKind() != TypeKind.ARRAY) continue;
                    return entry.getValue();
                }
            }
        }
        return null;
    }

    private void extractTypeParameterBounds(AnnotatedConstruct element, final Consumer<List<TypeMirror>> handler) {
        AnnotationValue annotationValue;
        if (handler != null && (annotationValue = this.getPeceptGuardEvaluatorAnnotationValue(element)) != null) {
            annotationValue.accept(new SimpleAnnotationValueVisitor14<Void, Void>(this, null){

                @Override
                public Void visitArray(List<? extends AnnotationValue> values, Void additionalParameter0) {
                    if (!values.isEmpty()) {
                        final ArrayList types = new ArrayList();
                        for (AnnotationValue annotationValue : values) {
                            annotationValue.accept(new SimpleAnnotationValueVisitor14<Void, Void>(this, null){

                                @Override
                                public Void visitType(TypeMirror type, Void additionalParamter1) {
                                    types.add(type);
                                    return null;
                                }
                            }, null);
                        }
                        if (!types.isEmpty()) {
                            handler.accept(types);
                        }
                    }
                    return null;
                }

                @Override
                public Void visitType(TypeMirror t, Void p) {
                    handler.accept(Collections.singletonList(t));
                    return null;
                }
            }, null);
        }
    }

    protected void generateEventHandlersDetails(Element parent, TypeElement typeElement) {
        if (!this.getElementUtils().isEventHandlerContainer(typeElement)) {
            return;
        }
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), ExecutableElement.class);
        Iterable eventHandlers = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.METHOD && !this.getElementUtils().isStatic((javax.lang.model.element.Element)it) && it.getAnnotation(PerceptGuardEvaluator.class) != null);
        this.createDetailBox(Messages.AbstractTypeDocumentationGenerator_58, ID_EVENT_HANDLER_DETAILS, parent, eventHandlers, this.getElementUtils().getExecutableElementComparator(), element -> this.getHtmlFactory().toExecutableAnchor((ExecutableElement)element), element -> {
            ArrayList<Object> nodes = new ArrayList<Object>();
            nodes.add(new TextNode(this.getSARLGrammarKeywordAccess().getOnKeyword()));
            nodes.add(this.getHtmlFactory().createSecableSpace(null));
            TypeMirror eventType = element.getParameters().get(0).asType();
            TypeElement eventTypeElement = this.getElementUtils().asTypeElement(eventType, this.getEnvironment().getTypeUtils());
            nodes.add(new TextNode(eventTypeElement.getSimpleName().toString()));
            this.extractTypeParameterBounds((AnnotatedConstruct)element, bounds -> {
                nodes.add(new TextNode(this.getSARLGrammarKeywordAccess().getLessThanSignKeyword()));
                boolean first = true;
                for (TypeMirror bound : bounds) {
                    if (first) {
                        first = false;
                    } else {
                        nodes.add(new TextNode(this.getSARLGrammarKeywordAccess().getCommaKeyword()));
                    }
                    TypeElement boundType = this.getElementUtils().asTypeElement(bound, this.getEnvironment().getTypeUtils());
                    nodes.add(new TextNode(boundType.getSimpleName().toString()));
                }
                nodes.add(new TextNode(this.getSARLGrammarKeywordAccess().getGreaterThanSignKeyword()));
            });
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            Element prototype = this.getHtmlFactory().createPreTag(null, null);
            this.getHtmlFactory().keyword(prototype, this.getSARLGrammarKeywordAccess().getOnKeyword());
            this.getHtmlFactory().createSecableSpace(prototype);
            TypeMirror eventType = element.getParameters().get(0).asType();
            prototype.appendChildren(this.getHtmlFactory().createTypeLink(eventType, false, null, (HtmlFactoryContext)this));
            this.extractTypeParameterBounds((AnnotatedConstruct)element, bounds -> {
                prototype.appendText(this.getSARLGrammarKeywordAccess().getLessThanSignKeyword());
                boolean first = true;
                for (TypeMirror bound : bounds) {
                    if (first) {
                        first = false;
                    } else {
                        prototype.appendText(this.getSARLGrammarKeywordAccess().getCommaKeyword());
                    }
                    TypeElement boundType = this.getElementUtils().asTypeElement(bound, this.getEnvironment().getTypeUtils());
                    prototype.appendText(boundType.getSimpleName().toString());
                }
                prototype.appendText(this.getSARLGrammarKeywordAccess().getGreaterThanSignKeyword());
            });
            nodes.add((Node)prototype);
            this.createFullDescriptionBody((javax.lang.model.element.Element)element, (List<Node>)nodes, false, true);
            this.createBlockTagsFor((javax.lang.model.element.Element)element, (List<Node>)nodes, Taglet.Location.METHOD, CssStyles.DETAIL_BOX_TAG);
            return nodes;
        });
    }

    protected void generateReturnTypeConstruct(ExecutableElement element, Element receiver) {
        List<Node> type;
        TypeMirror rtype = element.getReturnType();
        if (rtype != null && rtype.getKind() != TypeKind.VOID && (type = this.getHtmlFactory().createTypeLink(rtype, true, null, (HtmlFactoryContext)this)) != null) {
            this.getHtmlFactory().createSecableSpace(receiver);
            receiver.appendText(this.getSARLGrammarKeywordAccess().getColonKeyword());
            this.getHtmlFactory().createSecableSpace(receiver);
            receiver.appendChildren(type);
        }
    }

    protected void generateTypeParameterConstruct(ExecutableElement element, Element receiver, boolean addNewLine) {
        List<? extends TypeParameterElement> parameters = element.getTypeParameters();
        if (parameters != null && !parameters.isEmpty()) {
            Element realReceiver = receiver;
            if (addNewLine) {
                realReceiver = this.getHtmlFactory().createParagraphTag(receiver, CssStyles.PRE_INDENT);
            }
            this.getHtmlFactory().createSecableSpace(realReceiver);
            this.getHtmlFactory().keyword(realReceiver, this.getSARLGrammarKeywordAccess().getWithKeyword());
            boolean first = true;
            for (TypeParameterElement typeParameterElement : parameters) {
                Iterable boundTypes;
                if (first) {
                    first = false;
                } else {
                    realReceiver.appendText(this.getSARLGrammarKeywordAccess().getCommaKeyword());
                }
                this.getHtmlFactory().createSecableSpace(realReceiver);
                realReceiver.appendText(typeParameterElement.getSimpleName().toString());
                List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
                if (bounds == null || bounds.isEmpty() || !(boundTypes = Iterables.filter(bounds, it -> {
                    TypeElement te = this.getElementUtils().asTypeElement((TypeMirror)it, this.getEnvironment().getTypeUtils());
                    return te == null || !Object.class.getName().equals(this.getElementUtils().getFullyQualifiedName(te, true));
                })).iterator().hasNext()) continue;
                this.getHtmlFactory().createSecableSpace(realReceiver);
                this.getHtmlFactory().keyword(realReceiver, this.getSARLGrammarKeywordAccess().getExtendsKeyword());
                boolean first0 = true;
                for (TypeMirror tm : boundTypes) {
                    this.getHtmlFactory().createSecableSpace(realReceiver);
                    if (first0) {
                        first0 = false;
                    } else {
                        realReceiver.appendText(this.getSARLGrammarKeywordAccess().getAmpersandKeyword());
                        this.getHtmlFactory().createSecableSpace(realReceiver);
                    }
                    List<Node> typeRef = this.getHtmlFactory().createTypeLink(tm, true, null, (HtmlFactoryContext)this);
                    realReceiver.appendChildren(typeRef);
                }
            }
        }
    }

    protected void generateThrowsConstruct(ExecutableElement element, Element receiver, boolean addNewLine) {
        List<? extends TypeMirror> exceptions = element.getThrownTypes();
        if (exceptions != null && !exceptions.isEmpty()) {
            Element realReceiver = receiver;
            if (addNewLine) {
                realReceiver = this.getHtmlFactory().createParagraphTag(receiver, CssStyles.PRE_INDENT);
            }
            this.getHtmlFactory().createSecableSpace(realReceiver);
            this.getHtmlFactory().keyword(realReceiver, this.getSARLGrammarKeywordAccess().getThrowsKeyword());
            boolean first = true;
            for (TypeMirror typeMirror : exceptions) {
                List<Node> type = this.getHtmlFactory().createTypeLink(typeMirror, true, null, (HtmlFactoryContext)this);
                if (type == null) continue;
                if (first) {
                    first = false;
                } else {
                    realReceiver.appendText(this.getSARLGrammarKeywordAccess().getCommaKeyword());
                }
                this.getHtmlFactory().createSecableSpace(realReceiver);
                realReceiver.appendChildren(type);
            }
        }
    }

    protected void generateFiresConstruct(ExecutableElement element, Element receiver, boolean addNewLine) {
        Iterable annotations = Iterables.filter(element.getAnnotationMirrors(), it -> {
            AnnotationValue value;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values;
            DeclaredType dt = it.getAnnotationType();
            String qn = this.getElementUtils().getFullyQualifiedName(dt.asElement(), true);
            if (FiredEvent.class.getName().equals(qn) && (values = it.getElementValues()).size() == 1 && (value = values.values().iterator().next()) != null) {
                boolean rvalue = (Boolean)new SimpleAnnotationValueVisitor9<Boolean, Void>(this){

                    @Override
                    public Boolean visitArray(List<? extends AnnotationValue> vals, Void p) {
                        return !vals.isEmpty();
                    }

                    @Override
                    protected Boolean defaultAction(Object o, Void p) {
                        return Boolean.FALSE;
                    }
                }.visit(value);
                return rvalue;
            }
            return false;
        });
        if (annotations.iterator().hasNext()) {
            final Element realReceiver = addNewLine ? this.getHtmlFactory().createParagraphTag(receiver, CssStyles.PRE_INDENT) : receiver;
            this.getHtmlFactory().createSecableSpace(realReceiver);
            this.getHtmlFactory().keyword(realReceiver, this.getSARLGrammarKeywordAccess().getFiresKeyword());
            final boolean[] first = new boolean[]{true};
            for (AnnotationMirror annotation : annotations) {
                AnnotationValue value = annotation.getElementValues().values().iterator().next();
                new SimpleAnnotationValueVisitor9<Void, Void>(){

                    @Override
                    public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
                        for (AnnotationValue annotationValue : vals) {
                            TypeMirror tm = (TypeMirror)new SimpleAnnotationValueVisitor9<TypeMirror, Void>(this){

                                @Override
                                public TypeMirror visitType(TypeMirror t, Void p) {
                                    return t;
                                }

                                @Override
                                protected TypeMirror defaultAction(Object o, Void p) {
                                    return null;
                                }
                            }.visit(annotationValue);
                            if (tm == null) continue;
                            if (first[0]) {
                                first[0] = false;
                            } else {
                                realReceiver.appendText(AbstractTypeDocumentationGenerator.this.getSARLGrammarKeywordAccess().getCommaKeyword());
                            }
                            AbstractTypeDocumentationGenerator.this.getHtmlFactory().createSecableSpace(realReceiver);
                            List<Node> typeNodes = AbstractTypeDocumentationGenerator.this.getHtmlFactory().createTypeLink(tm, true, null, (HtmlFactoryContext)AbstractTypeDocumentationGenerator.this);
                            realReceiver.appendChildren(typeNodes);
                        }
                        return null;
                    }

                    @Override
                    protected Void defaultAction(Object o, Void p) {
                        return null;
                    }
                }.visit(value);
            }
        }
    }

    protected void generateActionsDetails(Element parent, TypeElement typeElement) {
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), ExecutableElement.class);
        Iterable actions = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.METHOD && this.getEnvironment().isIncluded((javax.lang.model.element.Element)it));
        this.createDetailBox(Messages.AbstractTypeDocumentationGenerator_54, ID_ACTION_DETAILS, parent, actions, this.getElementUtils().getExecutableElementComparator(), element -> this.getHtmlFactory().toExecutableAnchor((ExecutableElement)element), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            String simpleName = element.getSimpleName().toString();
            List<Node> constructorPrototype = this.getHtmlFactory().getExecutablePrototype((ExecutableElement)element, simpleName, (HtmlFactoryContext)this);
            nodes.addAll(constructorPrototype);
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            Element prototype = this.getHtmlFactory().createPreTag(null, null);
            String modifierStr = this.getElementUtils().getVisibilityModifiersString((javax.lang.model.element.Element)element, false);
            if (!Strings.isNullOrEmpty((String)modifierStr)) {
                this.getHtmlFactory().keyword(prototype, modifierStr);
                this.getHtmlFactory().createSecableSpace(prototype);
            }
            this.getHtmlFactory().keyword(prototype, this.getSARLGrammarKeywordAccess().getDefKeyword());
            this.getHtmlFactory().createSecableSpace(prototype);
            String simpleName = element.getSimpleName().toString();
            List<Node> constructorPrototype = this.getHtmlFactory().getExecutablePrototype((ExecutableElement)element, simpleName, (HtmlFactoryContext)this);
            prototype.appendChildren(constructorPrototype);
            this.generateReturnTypeConstruct((ExecutableElement)element, prototype);
            this.generateTypeParameterConstruct((ExecutableElement)element, prototype, true);
            this.generateThrowsConstruct((ExecutableElement)element, prototype, true);
            this.generateFiresConstruct((ExecutableElement)element, prototype, true);
            nodes.add((Node)prototype);
            this.createFullDescriptionBody((javax.lang.model.element.Element)element, (List<Node>)nodes, false, true);
            this.createBlockTagsFor((javax.lang.model.element.Element)element, (List<Node>)nodes, Taglet.Location.METHOD, CssStyles.DETAIL_BOX_TAG);
            return nodes;
        });
    }

    protected void generateConstructorsDetails(Element parent, TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.CLASS) {
            return;
        }
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), ExecutableElement.class);
        Iterable constructors = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.CONSTRUCTOR && this.getEnvironment().isIncluded((javax.lang.model.element.Element)it));
        String constructorName = this.getSARLGrammarKeywordAccess().getNewKeyword();
        this.createDetailBox(Messages.AbstractTypeDocumentationGenerator_53, ID_CONSTRUCTOR_DETAILS, parent, constructors, this.getElementUtils().getExecutableElementComparator(), element -> this.getHtmlFactory().toExecutableAnchor((ExecutableElement)element), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            List<Node> constructorPrototype = this.getHtmlFactory().getExecutablePrototype((ExecutableElement)element, constructorName, (HtmlFactoryContext)this);
            nodes.addAll(constructorPrototype);
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            Element prototype = this.getHtmlFactory().createPreTag(null, null);
            String modifierStr = this.getElementUtils().getVisibilityModifiersString((javax.lang.model.element.Element)element, false);
            if (!Strings.isNullOrEmpty((String)modifierStr)) {
                this.getHtmlFactory().keyword(prototype, modifierStr);
                this.getHtmlFactory().createSecableSpace(prototype);
            }
            List<Element> label = Collections.singletonList(this.getHtmlFactory().keyword(null, constructorName));
            List<Node> constructorPrototype = this.getHtmlFactory().getExecutablePrototype((ExecutableElement)element, (List<Node>)label, (HtmlFactoryContext)this);
            prototype.appendChildren(constructorPrototype);
            this.generateTypeParameterConstruct((ExecutableElement)element, prototype, true);
            this.generateThrowsConstruct((ExecutableElement)element, prototype, true);
            this.generateFiresConstruct((ExecutableElement)element, prototype, true);
            nodes.add((Node)prototype);
            this.createFullDescriptionBody((javax.lang.model.element.Element)element, (List<Node>)nodes, false, true);
            this.createBlockTagsFor((javax.lang.model.element.Element)element, (List<Node>)nodes, Taglet.Location.CONSTRUCTOR, CssStyles.DETAIL_BOX_TAG);
            return nodes;
        });
    }

    protected void generateFieldsDetails(Element parent, TypeElement typeElement) {
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), VariableElement.class);
        Iterable fields = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.FIELD && this.getEnvironment().isIncluded((javax.lang.model.element.Element)it));
        this.createDetailBox(Messages.AbstractTypeDocumentationGenerator_52, ID_FIELD_DETAILS, parent, fields, this.getElementUtils().getVariableElementComparator(), element -> this.getHtmlFactory().toVariableAnchor((VariableElement)element), element -> {
            ArrayList<TextNode> nodes = new ArrayList<TextNode>();
            nodes.add(new TextNode(element.getSimpleName().toString()));
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            Element prototype = this.getHtmlFactory().createPreTag(null, null);
            String modifierStr = this.getElementUtils().getModifiersString((javax.lang.model.element.Element)element, false, false, true);
            if (!Strings.isNullOrEmpty((String)modifierStr)) {
                this.getHtmlFactory().keyword(prototype, modifierStr);
                this.getHtmlFactory().createSecableSpace(prototype);
            }
            String fieldName = element.getSimpleName().toString();
            prototype.appendText(fieldName);
            this.getHtmlFactory().createSecableSpace(prototype);
            prototype.appendText(this.getSARLGrammarKeywordAccess().getColonKeyword());
            this.getHtmlFactory().createSecableSpace(prototype);
            TypeMirror type = element.asType();
            if (type != null) {
                List<Node> typeNodes = this.getHtmlFactory().createTypeLink(type, true, null, (HtmlFactoryContext)this);
                prototype.appendChildren(typeNodes);
            } else {
                prototype.appendChild((Node)new TextNode(element.toString()));
            }
            Object constantValue = element.getConstantValue();
            if (constantValue != null) {
                this.getHtmlFactory().createSecableSpace(prototype);
                prototype.appendText(this.getSARLGrammarKeywordAccess().getEqualsSignKeyword());
                this.getHtmlFactory().createSecableSpace(prototype);
                prototype.appendChild((Node)new TextNode(ValueTaglet.defaultFormatValue(constantValue)));
            }
            nodes.add((Node)prototype);
            this.createFullDescriptionBody((javax.lang.model.element.Element)element, (List<Node>)nodes, false, true);
            this.createBlockTagsFor((javax.lang.model.element.Element)element, (List<Node>)nodes, Taglet.Location.FIELD, CssStyles.DETAIL_BOX_TAG);
            return nodes;
        });
    }

    protected void generatePropertiesDetails(Element parent, TypeElement typeElement) {
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), ExecutableElement.class);
        NoType voidType = this.getEnvironment().getTypeUtils().getNoType(TypeKind.VOID);
        Iterable properties = Iterables.filter((Iterable)source, it -> this.getEnvironment().isIncluded((javax.lang.model.element.Element)it) && !this.getElementUtils().isStatic((javax.lang.model.element.Element)it) && it.getParameters().size() == 0 && it.getReturnType() != null && !voidType.equals(it.getReturnType()) && this.isPropertyGetterName(it.getSimpleName().toString()));
        TreeSet<String> declaredSetters = new TreeSet<String>();
        for (javax.lang.model.element.Element element2 : this.getTypeHierarchy().getDeclaredElements(typeElement, true, this.getEnvironment(), it1 -> {
            if (it1 instanceof ExecutableElement) {
                ExecutableElement ee = (ExecutableElement)it1;
                if (!this.getElementUtils().isStatic(ee) && ee.getParameters().size() == 1 && (ee.getReturnType() == null || voidType.equals(ee.getReturnType())) && this.isPropertySetterName(ee.getSimpleName().toString())) {
                    return true;
                }
            }
            return false;
        })) {
            String name = this.setterName2property(element2.getSimpleName().toString());
            assert (name != null);
            declaredSetters.add(name);
        }
        this.createDetailBox(Messages.AbstractTypeDocumentationGenerator_50, ID_PROPERTY_DETAILS, parent, properties, this.getElementUtils().getExecutableElementComparator(), null, element -> {
            ArrayList<TextNode> nodes = new ArrayList<TextNode>();
            String propertyName = this.getterName2property(element.getSimpleName().toString());
            nodes.add(new TextNode(propertyName));
            return nodes;
        }, element -> {
            String propertyName;
            ArrayList<Node> nodes = new ArrayList<Node>();
            Element prototype = this.getHtmlFactory().createPreTag(null, null);
            String modifierStr = this.getElementUtils().getVisibilityModifiersString((javax.lang.model.element.Element)element, false);
            if (!Strings.isNullOrEmpty((String)modifierStr)) {
                this.getHtmlFactory().keyword(prototype, modifierStr);
                this.getHtmlFactory().createSecableSpace(prototype);
            }
            if (declaredSetters.contains(propertyName = this.getterName2property(element.getSimpleName().toString()))) {
                this.getHtmlFactory().keyword(prototype, this.getSARLGrammarKeywordAccess().getWriteableVarKeyword());
            } else {
                this.getHtmlFactory().keyword(prototype, this.getSARLGrammarKeywordAccess().getValKeyword());
            }
            this.getHtmlFactory().createSecableSpace(prototype);
            prototype.appendText(propertyName);
            this.getHtmlFactory().createSecableSpace(prototype);
            prototype.appendText(this.getSARLGrammarKeywordAccess().getColonKeyword());
            this.getHtmlFactory().createSecableSpace(prototype);
            TypeMirror type = element.getReturnType();
            if (type != null) {
                List<Node> typeNodes = this.getHtmlFactory().createTypeLink(type, true, null, (HtmlFactoryContext)this);
                prototype.appendChildren(typeNodes);
            } else {
                prototype.appendChild((Node)new TextNode(element.toString()));
            }
            nodes.add((Node)prototype);
            this.createFullDescriptionBody((javax.lang.model.element.Element)element, (List<Node>)nodes, false, true);
            List<Node> aliasedLabel = this.getHtmlFactory().getExecutablePrototype((ExecutableElement)element, this);
            List<Node> aliasedNodes = this.getHtmlFactory().createExecutableLink((ExecutableElement)element, aliasedLabel, null, (HtmlFactoryContext)this);
            if (!aliasedNodes.isEmpty()) {
                Element paragraph = this.getHtmlFactory().createParagraphTag(null, null);
                paragraph.appendText(Messages.AbstractTypeDocumentationGenerator_51);
                paragraph.appendChildren(aliasedNodes);
                nodes.add((Node)paragraph);
            }
            this.createBlockTagsFor((javax.lang.model.element.Element)element, (List<Node>)nodes, Taglet.Location.METHOD, CssStyles.DETAIL_BOX_TAG);
            return nodes;
        });
    }

    protected void generateEnumConstantsDetails(Element parent, TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.ENUM) {
            return;
        }
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), VariableElement.class);
        Iterable enumConstants = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.ENUM_CONSTANT);
        this.createDetailBox(Messages.AbstractTypeDocumentationGenerator_49, ID_ENUM_CONSTANT_DETAILS, parent, enumConstants, this.getElementUtils().getVariableElementComparator(), element -> this.getHtmlFactory().toVariableAnchor((VariableElement)element), element -> {
            ArrayList<TextNode> nodes = new ArrayList<TextNode>();
            nodes.add(new TextNode(element.getSimpleName().toString()));
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            Element prototype0 = this.getHtmlFactory().createPreTag(null, null);
            nodes.add((Node)prototype0);
            Element prototype1 = this.getHtmlFactory().createPreTag(prototype0, null);
            this.getHtmlFactory().keyword(prototype1, this.getSARLGrammarKeywordAccess().getStaticStaticKeyword());
            this.getHtmlFactory().createSecableSpace(prototype1);
            this.getHtmlFactory().keyword(prototype1, this.getSARLGrammarKeywordAccess().getValKeyword());
            this.getHtmlFactory().createSecableSpace(prototype1);
            prototype1.appendText(element.getSimpleName().toString());
            this.getHtmlFactory().createSecableSpace(prototype1);
            prototype1.appendText(this.getSARLGrammarKeywordAccess().getColonKeyword());
            this.getHtmlFactory().createSecableSpace(prototype1);
            prototype1.appendText(typeElement.getSimpleName().toString());
            this.createFullDescriptionBody((javax.lang.model.element.Element)element, (List<Node>)nodes, false, true);
            this.createBlockTagsFor((javax.lang.model.element.Element)element, (List<Node>)nodes, Taglet.Location.FIELD, CssStyles.DETAIL_BOX_TAG);
            return nodes;
        });
    }

    protected void generateMemberSummary(Element parent, TypeElement typeElement) {
        this.generatePropertiesSummary(parent, typeElement);
        this.generateNestedClassesSummary(parent, typeElement);
        this.generateEnumConstantsSummary(parent, typeElement);
        this.generateFieldsSummary(parent, typeElement);
        this.generateConstructorsSummary(parent, typeElement);
        this.generateActionsSummary(parent, typeElement);
        this.generateEventHandlersSummary(parent, typeElement);
        this.generateCapacityUsesSummary(parent, typeElement);
    }

    protected void generateCapacityUsesSummary(Element parent, TypeElement typeElement) {
        if (!this.getElementUtils().isCapacityUser(typeElement)) {
            return;
        }
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), VariableElement.class);
        Iterable capacityUsers = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.FIELD && !this.getElementUtils().isStatic((javax.lang.model.element.Element)it) && it.getAnnotation(ImportedCapacityFeature.class) != null);
        Iterable capacityUses = Iterables.transform((Iterable)capacityUsers, it -> {
            Iterable mirrors = Iterables.filter(it.getAnnotationMirrors(), it0 -> {
                DeclaredType dt = it0.getAnnotationType();
                String qn = this.getElementUtils().getFullIdentifier(dt.asElement());
                return ImportedCapacityFeature.class.getName().equals(qn);
            });
            return (AnnotationMirror)mirrors.iterator().next();
        });
        final TreeSet capacityElements = new TreeSet(this.getElementUtils().getTypeElementComparator());
        for (AnnotationMirror annotation : capacityUses) {
            if (annotation.getElementValues().size() != 1) continue;
            new SimpleAnnotationValueVisitor9<Void, Void>(){

                @Override
                public Void visitType(TypeMirror t, Void p) {
                    TypeElement te = AbstractTypeDocumentationGenerator.this.getElementUtils().asTypeElement(t, AbstractTypeDocumentationGenerator.this.getEnvironment().getTypeUtils());
                    capacityElements.add(te);
                    return null;
                }

                @Override
                protected Void defaultAction(Object o, Void p) {
                    return null;
                }
            }.visit(annotation.getElementValues().values().iterator().next());
        }
        this.createSummaryBox1(Messages.AbstractTypeDocumentationGenerator_59, Messages.AbstractTypeDocumentationGenerator_60, Messages.AbstractTypeDocumentationGenerator_61, ID_CAPACITY_USE_SUMMARY, parent, capacityElements, this.getElementUtils().getTypeElementComparator(), element -> this.getHtmlFactory().createTypeLink((TypeElement)element, false, null, (HtmlFactoryContext)this));
    }

    protected void generateEventHandlersSummary(Element parent, TypeElement typeElement) {
        if (!this.getElementUtils().isEventHandlerContainer(typeElement)) {
            return;
        }
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), ExecutableElement.class);
        Iterable eventHandlers = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.METHOD && !this.getElementUtils().isStatic((javax.lang.model.element.Element)it) && it.getAnnotation(PerceptGuardEvaluator.class) != null);
        this.createSummaryBox1(Messages.AbstractTypeDocumentationGenerator_56, Messages.AbstractTypeDocumentationGenerator_55, Messages.AbstractTypeDocumentationGenerator_57, ID_EVENT_HANDLER_SUMMARY, parent, eventHandlers, this.getElementUtils().getExecutableElementComparator(), element -> {
            ArrayList<Node> label = new ArrayList<Node>();
            label.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getOnKeyword()));
            label.add(this.getHtmlFactory().createSecableSpace(null));
            TypeMirror eventType = element.getParameters().get(0).asType();
            TypeElement eventTypeElement = this.getElementUtils().asTypeElement(eventType, this.getEnvironment().getTypeUtils());
            label.add((Node)new TextNode(eventTypeElement.getSimpleName().toString()));
            this.extractTypeParameterBounds((AnnotatedConstruct)element, bounds -> {
                label.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getLessThanSignKeyword()));
                boolean first = true;
                for (TypeMirror bound : bounds) {
                    if (first) {
                        first = false;
                    } else {
                        label.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getCommaKeyword()));
                    }
                    TypeElement boundType = this.getElementUtils().asTypeElement(bound, this.getEnvironment().getTypeUtils());
                    label.add((Node)new TextNode(boundType.getSimpleName().toString()));
                }
                label.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getGreaterThanSignKeyword()));
            });
            String anchor = this.getHtmlFactory().toEventHandlerAnchor((ExecutableElement)element);
            List<Node> elementLink = label;
            try {
                elementLink = this.getHtmlFactory().createLink((Path)null, anchor, label, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Element emphLink = this.getHtmlFactory().createSpanTag(null, CssStyles.SUMMARY_BOX_ID);
            emphLink.appendChildren(elementLink);
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add((Node)emphLink);
            this.createFirstSentence((javax.lang.model.element.Element)element, (List<Node>)nodes, true, false);
            this.createShortDeprecationMessage((javax.lang.model.element.Element)element, (List<Node>)nodes, true);
            return nodes;
        }, (Functions.Function0<Collection<? extends Node>>)((Functions.Function0)() -> {
            TreeMap<String, ArrayList<Node>> nodes = new TreeMap<String, ArrayList<Node>>();
            for (javax.lang.model.element.Element element : this.getTypeHierarchy().getInheritedElements(typeElement, true, false, true, true, this.getEnvironment(), it1 -> it1 instanceof ExecutableElement && it1.getKind() == ElementKind.METHOD && !this.getElementUtils().isStatic((javax.lang.model.element.Element)it1) && it1.getAnnotation(PerceptGuardEvaluator.class) != null)) {
                javax.lang.model.element.Element enclosing = element.getEnclosingElement();
                TypeMirror enclosingType = enclosing.asType();
                String anchor = this.getHtmlFactory().toEventHandlerAnchor((ExecutableElement)element);
                TypeElement enclosingTypeElement = this.getElementUtils().asTypeElement(enclosingType, this.getEnvironment().getTypeUtils());
                ArrayList<Node> label = new ArrayList<Node>();
                label.add((Node)new TextNode(enclosingTypeElement.getSimpleName().toString()));
                label.add((Node)new TextNode("/"));
                label.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getOnKeyword()));
                label.add(this.getHtmlFactory().createSecableSpace(null));
                ExecutableElement executableElement = (ExecutableElement)element;
                TypeMirror eventType = executableElement.getParameters().get(0).asType();
                TypeElement eventTypeElement = this.getElementUtils().asTypeElement(eventType, this.getEnvironment().getTypeUtils());
                label.add((Node)new TextNode(eventTypeElement.getSimpleName().toString()));
                this.extractTypeParameterBounds(executableElement, bounds -> {
                    label.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getLessThanSignKeyword()));
                    boolean first = true;
                    for (TypeMirror bound : bounds) {
                        if (first) {
                            first = false;
                        } else {
                            label.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getCommaKeyword()));
                        }
                        TypeElement boundType = this.getElementUtils().asTypeElement(bound, this.getEnvironment().getTypeUtils());
                        label.add((Node)new TextNode(boundType.getSimpleName().toString()));
                    }
                    label.add((Node)new TextNode(this.getSARLGrammarKeywordAccess().getGreaterThanSignKeyword()));
                });
                List<Node> elementLink = label;
                try {
                    elementLink = this.getHtmlFactory().createTypeLink(enclosingType, anchor, label, null, (HtmlFactoryContext)this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                nodes.putIfAbsent(eventTypeElement.getSimpleName().toString(), (ArrayList<Node>)elementLink);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            boolean bl = true;
            for (List entity : nodes.values()) {
                boolean bl2;
                if (bl2) {
                    bl2 = false;
                } else {
                    list.add(new TextNode(this.getSARLGrammarKeywordAccess().getCommaKeyword()));
                    list.add(this.getHtmlFactory().createSecableSpace(null));
                }
                list.addAll(entity);
            }
            return list;
        }));
    }

    protected void generateActionsSummary(Element parent, TypeElement typeElement) {
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), ExecutableElement.class);
        Iterable allActions = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.METHOD && this.getEnvironment().isIncluded((javax.lang.model.element.Element)it));
        Iterable staticActions = Iterables.filter((Iterable)allActions, it -> this.getElementUtils().isStatic((javax.lang.model.element.Element)it));
        Iterable concreteActions = Iterables.filter((Iterable)allActions, it -> !this.getElementUtils().isStatic((javax.lang.model.element.Element)it) && !this.getElementUtils().isAbstract((javax.lang.model.element.Element)it));
        Iterable abstractActions = Iterables.filter((Iterable)allActions, it -> !this.getElementUtils().isStatic((javax.lang.model.element.Element)it) && this.getElementUtils().isAbstract((javax.lang.model.element.Element)it));
        LinkedHashMap actions = new LinkedHashMap();
        actions.put(Messages.AbstractTypeDocumentationGenerator_39, allActions);
        actions.put(Messages.AbstractTypeDocumentationGenerator_42, staticActions);
        actions.put(Messages.AbstractTypeDocumentationGenerator_48, abstractActions);
        actions.put(Messages.AbstractTypeDocumentationGenerator_43, concreteActions);
        this.createSummaryBox2(Messages.AbstractTypeDocumentationGenerator_38, Messages.AbstractTypeDocumentationGenerator_40, Messages.AbstractTypeDocumentationGenerator_41, ID_ACTION_SUMMARY, parent, actions, this.getElementUtils().getExecutableElementComparator(), element -> {
            ArrayList<Object> nodes = new ArrayList<Object>();
            String modifierStr = this.getElementUtils().getModifiersString((javax.lang.model.element.Element)element, false, true, false);
            if (!Strings.isNullOrEmpty((String)modifierStr)) {
                nodes.add(new TextNode(modifierStr));
                nodes.add(this.getHtmlFactory().createUnsecableSpace(null));
            }
            TypeMirror rtype = element.getReturnType();
            List<Node> type = this.getHtmlFactory().createTypeLink(rtype, true, null, (HtmlFactoryContext)this);
            if (type != null) {
                nodes.addAll(type);
            }
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            String methodName = element.getSimpleName().toString();
            List<Node> methodPrototype = this.getHtmlFactory().getExecutablePrototype((ExecutableElement)element, methodName, (HtmlFactoryContext)this);
            List<Node> elementLink = this.getHtmlFactory().createExecutableLink((ExecutableElement)element, methodPrototype, null, (HtmlFactoryContext)this);
            if (elementLink != null) {
                Element emphLink = this.getHtmlFactory().createSpanTag(null, CssStyles.SUMMARY_BOX_ID);
                emphLink.appendChildren(elementLink);
                nodes.add((Node)emphLink);
            }
            this.createFirstSentence((javax.lang.model.element.Element)element, (List<Node>)nodes, true, false);
            this.createShortDeprecationMessage((javax.lang.model.element.Element)element, (List<Node>)nodes, true);
            return nodes;
        }, (Functions.Function0<Collection<? extends Node>>)((Functions.Function0)() -> {
            TreeMap<String, List<Node>> nodes = new TreeMap<String, List<Node>>();
            for (javax.lang.model.element.Element element : this.getTypeHierarchy().getInheritedElements(typeElement, true, this.getEnvironment(), it1 -> it1 instanceof ExecutableElement && it1.getKind() == ElementKind.METHOD)) {
                ExecutableElement ee = (ExecutableElement)element;
                String methodName = element.getSimpleName().toString();
                List<Node> methodPrototype = this.getHtmlFactory().getExecutablePrototype(ee, methodName, (HtmlFactoryContext)this);
                nodes.putIfAbsent(methodPrototype.toString(), this.getHtmlFactory().createExecutableLink(ee, methodPrototype, null, (HtmlFactoryContext)this));
            }
            ArrayList list = new ArrayList();
            for (List entity : nodes.values()) {
                list.addAll(entity);
            }
            return list;
        }));
    }

    protected void generateConstructorsSummary(Element parent, TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.CLASS) {
            return;
        }
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), ExecutableElement.class);
        Iterable constructors = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.CONSTRUCTOR && this.getEnvironment().isIncluded((javax.lang.model.element.Element)it));
        String constructorName = this.getSARLGrammarKeywordAccess().getNewKeyword();
        this.createSummaryBox1(Messages.AbstractTypeDocumentationGenerator_35, Messages.AbstractTypeDocumentationGenerator_36, Messages.AbstractTypeDocumentationGenerator_37, ID_CONSTRUCTOR_SUMMARY, parent, constructors, this.getElementUtils().getExecutableElementComparator(), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            List<Node> constructorPrototype = this.getHtmlFactory().getExecutablePrototype((ExecutableElement)element, constructorName, (HtmlFactoryContext)this);
            List<Node> elementLink = this.getHtmlFactory().createExecutableLink((ExecutableElement)element, constructorPrototype, null, (HtmlFactoryContext)this);
            if (elementLink != null) {
                Element emphLink = this.getHtmlFactory().createSpanTag(null, CssStyles.SUMMARY_BOX_ID);
                emphLink.appendChildren(elementLink);
                nodes.add((Node)emphLink);
            }
            this.createFirstSentence((javax.lang.model.element.Element)element, (List<Node>)nodes, true, false);
            this.createShortDeprecationMessage((javax.lang.model.element.Element)element, (List<Node>)nodes, true);
            return nodes;
        });
    }

    protected void generateNestedClassesSummary(Element parent, TypeElement typeElement) {
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), TypeElement.class);
        Iterable nestedTypes = Iterables.filter((Iterable)source, it -> this.getEnvironment().isIncluded((javax.lang.model.element.Element)it));
        this.createSummaryBox2(Messages.AbstractTypeDocumentationGenerator_31, Messages.AbstractTypeDocumentationGenerator_32, Messages.AbstractTypeDocumentationGenerator_33, Messages.AbstractTypeDocumentationGenerator_34, ID_NESTED_CLASS_SUMMARY, parent, nestedTypes, this.getElementUtils().getTypeElementComparator(), element -> {
            ArrayList<TextNode> nodes = new ArrayList<TextNode>();
            String modifierStr = this.getElementUtils().getVisibilityModifiersString((javax.lang.model.element.Element)element, false);
            if (!Strings.isNullOrEmpty((String)modifierStr)) {
                nodes.add(new TextNode(modifierStr));
            }
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            String typeName = this.getElementUtils().getInnerTypeQualifiedName((javax.lang.model.element.Element)element);
            List<Node> elementLink = this.getHtmlFactory().createTypeLink((TypeElement)element, typeName, null, (HtmlFactoryContext)this);
            if (elementLink != null) {
                Element emphLink = this.getHtmlFactory().createSpanTag(null, CssStyles.SUMMARY_BOX_ID);
                emphLink.appendChildren(elementLink);
                nodes.add((Node)emphLink);
            }
            this.createFirstSentence((javax.lang.model.element.Element)element, (List<Node>)nodes, true, false);
            this.createShortDeprecationMessage((javax.lang.model.element.Element)element, (List<Node>)nodes, true);
            return nodes;
        }, null);
    }

    protected void generateEnumConstantsSummary(Element parent, TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.ENUM) {
            return;
        }
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), VariableElement.class);
        Iterable enumConstants = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.ENUM_CONSTANT);
        this.createSummaryBox1(Messages.AbstractTypeDocumentationGenerator_23, Messages.AbstractTypeDocumentationGenerator_24, Messages.AbstractTypeDocumentationGenerator_25, ID_ENUM_CONSTANT_SUMMARY, parent, enumConstants, this.getElementUtils().getVariableElementComparator(), element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            String constantName = element.getSimpleName().toString();
            List<Node> elementLink = this.getHtmlFactory().createVariableLink((VariableElement)element, constantName, null, (HtmlFactoryContext)this);
            if (elementLink != null) {
                Element emphLink = this.getHtmlFactory().createSpanTag(null, CssStyles.SUMMARY_BOX_ID);
                emphLink.appendChildren(elementLink);
                nodes.add((Node)emphLink);
            }
            this.createFirstSentence((javax.lang.model.element.Element)element, (List<Node>)nodes, true, false);
            this.createShortDeprecationMessage((javax.lang.model.element.Element)element, (List<Node>)nodes, true);
            return nodes;
        });
    }

    protected void generateFieldsSummary(Element parent, TypeElement typeElement) {
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), VariableElement.class);
        Iterable allFields = Iterables.filter((Iterable)source, it -> it.getKind() == ElementKind.FIELD && this.getEnvironment().isIncluded((javax.lang.model.element.Element)it));
        Iterable staticFields = Iterables.filter((Iterable)allFields, it -> !this.getElementUtils().isFinal((javax.lang.model.element.Element)it) && this.getElementUtils().isStatic((javax.lang.model.element.Element)it));
        Iterable concreteFields = Iterables.filter((Iterable)allFields, it -> !this.getElementUtils().isFinal((javax.lang.model.element.Element)it) && !this.getElementUtils().isStatic((javax.lang.model.element.Element)it));
        Iterable staticValues = Iterables.filter((Iterable)allFields, it -> this.getElementUtils().isFinal((javax.lang.model.element.Element)it) && this.getElementUtils().isStatic((javax.lang.model.element.Element)it));
        Iterable concreteValues = Iterables.filter((Iterable)allFields, it -> this.getElementUtils().isFinal((javax.lang.model.element.Element)it) && !this.getElementUtils().isStatic((javax.lang.model.element.Element)it));
        LinkedHashMap fields = new LinkedHashMap();
        fields.put(Messages.AbstractTypeDocumentationGenerator_28, allFields);
        fields.put(Messages.AbstractTypeDocumentationGenerator_44, staticFields);
        fields.put(Messages.AbstractTypeDocumentationGenerator_45, concreteFields);
        fields.put(Messages.AbstractTypeDocumentationGenerator_46, staticValues);
        fields.put(Messages.AbstractTypeDocumentationGenerator_47, concreteValues);
        this.createSummaryBox2(Messages.AbstractTypeDocumentationGenerator_27, Messages.AbstractTypeDocumentationGenerator_29, Messages.AbstractTypeDocumentationGenerator_30, ID_FIELD_SUMMARY, parent, fields, this.getElementUtils().getVariableElementComparator(), element -> {
            ArrayList<Object> nodes = new ArrayList<Object>();
            String modifierStr = this.getElementUtils().getModifiersString((javax.lang.model.element.Element)element, false, false, true);
            if (!Strings.isNullOrEmpty((String)modifierStr)) {
                nodes.add(new TextNode(modifierStr));
                nodes.add(this.getHtmlFactory().createUnsecableSpace(null));
            }
            TypeMirror rtype = element.asType();
            List<Node> type = this.getHtmlFactory().createTypeLink(rtype, true, null, (HtmlFactoryContext)this);
            if (type != null) {
                nodes.addAll(type);
            }
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            String fieldName = element.getSimpleName().toString();
            List<Node> elementLink = this.getHtmlFactory().createVariableLink((VariableElement)element, fieldName, null, (HtmlFactoryContext)this);
            if (elementLink != null) {
                Element emphLink = this.getHtmlFactory().createSpanTag(null, CssStyles.SUMMARY_BOX_ID);
                emphLink.appendChildren(elementLink);
                nodes.add((Node)emphLink);
            }
            this.createFirstSentence((javax.lang.model.element.Element)element, (List<Node>)nodes, true, false);
            this.createShortDeprecationMessage((javax.lang.model.element.Element)element, (List<Node>)nodes, true);
            return nodes;
        }, (Functions.Function0<Collection<? extends Node>>)((Functions.Function0)() -> {
            TreeMap<String, List<Node>> nodes = new TreeMap<String, List<Node>>();
            for (javax.lang.model.element.Element element : this.getTypeHierarchy().getInheritedElements(typeElement, true, this.getEnvironment(), it1 -> it1 instanceof VariableElement && it1.getKind() == ElementKind.FIELD)) {
                String name = element.getSimpleName().toString();
                nodes.putIfAbsent(name, this.getHtmlFactory().createVariableLink((VariableElement)element, name, null, (HtmlFactoryContext)this));
            }
            ArrayList list = new ArrayList();
            for (List entity : nodes.values()) {
                list.addAll(entity);
            }
            return list;
        }));
    }

    protected void generatePropertiesSummary(Element parent, TypeElement typeElement) {
        Iterable source = Iterables.filter(typeElement.getEnclosedElements(), ExecutableElement.class);
        NoType voidType = this.getEnvironment().getTypeUtils().getNoType(TypeKind.VOID);
        Iterable properties = Iterables.filter((Iterable)source, it -> this.getEnvironment().isIncluded((javax.lang.model.element.Element)it) && !this.getElementUtils().isStatic((javax.lang.model.element.Element)it) && it.getParameters().size() == 0 && it.getReturnType() != null && !voidType.equals(it.getReturnType()) && this.isPropertyGetterName(it.getSimpleName().toString()));
        this.createSummaryBox2(Messages.AbstractTypeDocumentationGenerator_19, Messages.AbstractTypeDocumentationGenerator_20, Messages.AbstractTypeDocumentationGenerator_21, Messages.AbstractTypeDocumentationGenerator_22, ID_PROPERTY_SUMMARY, parent, properties, this.getElementUtils().getExecutableElementComparator(), element -> {
            ArrayList<Object> nodes = new ArrayList<Object>();
            String modifierStr = this.getElementUtils().getVisibilityModifiersString((javax.lang.model.element.Element)element, false);
            if (!Strings.isNullOrEmpty((String)modifierStr)) {
                nodes.add(new TextNode(modifierStr));
                nodes.add(this.getHtmlFactory().createUnsecableSpace(null));
            }
            TypeMirror rtype = element.getReturnType();
            List<Node> type = this.getHtmlFactory().createTypeLink(rtype, true, null, (HtmlFactoryContext)this);
            if (type != null) {
                nodes.addAll(type);
            }
            return nodes;
        }, element -> {
            ArrayList<Node> nodes = new ArrayList<Node>();
            String propertyName = this.getterName2property(element.getSimpleName().toString());
            List<Node> elementLink = this.getHtmlFactory().createExecutableLink((ExecutableElement)element, propertyName, null, (HtmlFactoryContext)this);
            if (elementLink != null) {
                Element emphLink = this.getHtmlFactory().createSpanTag(null, CssStyles.SUMMARY_BOX_ID);
                emphLink.appendChildren(elementLink);
                nodes.add((Node)emphLink);
            }
            this.createFirstSentence((javax.lang.model.element.Element)element, (List<Node>)nodes, true, false);
            this.createShortDeprecationMessage((javax.lang.model.element.Element)element, (List<Node>)nodes, true);
            return nodes;
        }, (Functions.Function0<Collection<? extends Node>>)((Functions.Function0)() -> {
            TreeMap<String, List<Node>> nodes = new TreeMap<String, List<Node>>();
            for (javax.lang.model.element.Element element : this.getTypeHierarchy().getInheritedElements(typeElement, true, this.getEnvironment(), it1 -> {
                if (it1 instanceof ExecutableElement) {
                    ExecutableElement ee = (ExecutableElement)it1;
                    if (!this.getElementUtils().isStatic(ee) && ee.getParameters().size() == 0 && ee.getReturnType() != null && !voidType.equals(ee.getReturnType()) && this.isPropertyGetterName(ee.getSimpleName().toString())) {
                        return true;
                    }
                }
                return false;
            })) {
                String name = this.getterName2property(element.getSimpleName().toString());
                nodes.putIfAbsent(name, this.getHtmlFactory().createExecutableLink((ExecutableElement)element, name, null, (HtmlFactoryContext)this));
            }
            ArrayList list = new ArrayList();
            for (List entity : nodes.values()) {
                list.addAll(entity);
            }
            return list;
        }));
    }

    protected void generateTypeInfo(Element parent, TypeElement typeElement) {
        Element divTag = this.getHtmlFactory().createDivTag(parent, CssStyles.TYPE_INFO_BOX);
        this.generateTypeParameterInfo(divTag, typeElement);
        this.generateSuperInterfacesInfo(divTag, typeElement);
        this.generateSubTypeInfo(divTag, typeElement);
        this.generateInterfaceUsageInfo(divTag, typeElement);
        this.generateNestedTypeInfo(divTag, typeElement);
        this.generateFunctionalInterfaceInfo(divTag, typeElement);
        this.generateDeprecationInfo(divTag, typeElement);
        this.generateTypeSignature(divTag, typeElement);
        this.generateTypeDescription(divTag, typeElement);
        this.generateTypeTagInfo(divTag, typeElement);
    }

    protected void generateTypeTagInfo(Element parent, TypeElement typeElement) {
        Element dlTag = this.getHtmlFactory().createDlTag(parent, CssStyles.TYPE_TAG_INFO);
        this.createTagInfo(dlTag, typeElement, Taglet.Location.TYPE, CssStyles.TYPE_TAG_INFO);
    }

    protected void generateTypeDescription(Element parent, TypeElement typeElement) {
        List<? extends DocTree> body;
        Element descriptionTag = this.getHtmlFactory().createDivTag(parent, CssStyles.TYPE_DESCRIPTION);
        DocCommentTree commentTree = this.getEnvironment().getDocTrees().getDocCommentTree(typeElement);
        if (commentTree != null && !(body = commentTree.getFullBody()).isEmpty()) {
            Element textDiv = this.getHtmlFactory().createDivTag(descriptionTag, CssStyles.TYPE_DESCRIPTION_MAIN);
            HtmlFactory.CommentTextMemory memory = this.getHtmlFactory().createCommentTextMemory(textDiv, typeElement, this);
            for (DocTree docTree : body) {
                this.getHtmlFactory().createCommentText(memory, docTree, CssStyles.TYPE_DESCRIPTION_MAIN);
            }
        }
    }

    protected void generateDeprecationInfo(Element parent, TypeElement typeElement) {
        List<? extends BlockTagTree> deprs;
        javax.lang.model.element.Element deprecatedElement = this.getElementUtils().getFirstEnclosingDeprecatedElement(typeElement);
        if (deprecatedElement != null && !(deprs = this.getDocUtils().getBlockTags(deprecatedElement, DocTree.Kind.DEPRECATED, this.getEnvironment())).isEmpty()) {
            Element dlTag = this.getHtmlFactory().createDlTag(parent, CssStyles.DEPRECATION_INFO);
            Element dtTag = this.getHtmlFactory().createDtTag(dlTag, CssStyles.DEPRECATION_INFO);
            boolean isForRemoval = this.getElementUtils().isDeprecatedForRemoval(deprecatedElement);
            String since = this.getElementUtils().getDeprecatedSince(deprecatedElement);
            if (Strings.isNullOrEmpty((String)since)) {
                if (isForRemoval) {
                    dtTag.appendText(Messages.AbstractTypeDocumentationGenerator_16);
                } else {
                    dtTag.appendText(Messages.AbstractTypeDocumentationGenerator_17);
                }
            } else if (isForRemoval) {
                dtTag.appendText(MessageFormat.format(Messages.AbstractTypeDocumentationGenerator_62, since));
            } else {
                dtTag.appendText(MessageFormat.format(Messages.AbstractTypeDocumentationGenerator_63, since));
            }
            Element ddTag = this.getHtmlFactory().createDdTag(dlTag, CssStyles.DEPRECATION_INFO);
            HtmlFactory.CommentTextMemory memory = this.getHtmlFactory().createCommentTextMemory(ddTag, deprecatedElement, this);
            for (BlockTagTree blockTagTree : deprs) {
                List<? extends DocTree> text = this.getDocUtils().getCommentForDeprecatedTag(blockTagTree);
                if (text.isEmpty()) continue;
                for (DocTree docTree : text) {
                    this.getHtmlFactory().createCommentText(memory, docTree, CssStyles.DEPRECATION_INFO);
                }
            }
        }
    }

    protected void generateAnnotationInfo(Element parent, TypeElement typeElement) {
        this.addAnnotationInfo(parent, 0, typeElement, typeElement.getAnnotationMirrors(), true);
    }

    private boolean addAnnotationInfo(Element containerTag, int indent, TypeElement element, List<? extends AnnotationMirror> descList, boolean lineBreak) {
        List<Element> annotations = this.getHtmlFactory().getAnnotationsFor(indent, descList, lineBreak, CssStyles.TYPE_SIGNATURE_ANNOTATION_INFO, CssStyles.TYPE_SIGNATURE_ANNOTATION_INFO_VALUE, this);
        if (annotations.isEmpty()) {
            return false;
        }
        boolean first = true;
        for (Element annotation : annotations) {
            containerTag.appendChild((Node)annotation);
            if (first) {
                first = false;
                continue;
            }
            if (lineBreak) continue;
            containerTag.appendText(" ");
        }
        return true;
    }

    protected void generateTypeSignature(Element parent, TypeElement typeElement) {
        List<? extends TypeMirror> interfaces;
        TypeMirror superclass;
        Element preTag = this.getHtmlFactory().createDivTag(parent, CssStyles.TYPE_SIGNATURE);
        this.generateAnnotationInfo(preTag, typeElement);
        String modifiers = this.getElementUtils().getModifiersString(typeElement, true, true, false);
        preTag.appendText(modifiers);
        Element typeNameElement = this.getHtmlFactory().createSpanTag(preTag, CssStyles.TYPE_SIGNATURE_TYPE_NAME);
        typeNameElement.appendText(typeElement.getSimpleName().toString());
        if (!typeElement.getTypeParameters().isEmpty()) {
            typeNameElement.appendText(this.getSARLGrammarKeywordAccess().getLessThanSignKeyword());
            boolean first = true;
            for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
                if (first) {
                    first = false;
                } else {
                    typeNameElement.appendText(this.getSARLGrammarKeywordAccess().getCommaKeyword());
                    typeNameElement.appendText(" ");
                }
                typeNameElement.appendText(typeParameterElement.toString());
            }
            typeNameElement.appendText(this.getSARLGrammarKeywordAccess().getGreaterThanSignKeyword());
        }
        if (typeElement.getKind() != ElementKind.INTERFACE && (superclass = this.getElementUtils().getFirstVisibleSuperType(typeElement, false, this.getEnvironment())) != null && superclass.getKind() != TypeKind.NONE) {
            preTag.appendChild((Node)this.getHtmlFactory().createNewLineTag());
            preTag.appendText(this.getSARLGrammarKeywordAccess().getExtendsKeyword());
            preTag.appendText(" ");
            preTag.appendChildren(this.getHtmlFactory().createTypeLink(superclass, true, CssStyles.TYPE_SIGNATURE, (HtmlFactoryContext)this));
        }
        if (!(interfaces = typeElement.getInterfaces()).isEmpty()) {
            boolean first = true;
            for (TypeMirror typeMirror : interfaces) {
                TypeElement type0 = this.getElementUtils().asTypeElement(typeMirror, this.getEnvironment().getTypeUtils());
                if (!this.getElementUtils().isPublic(type0) && !this.getElementUtils().isLinkable(type0, this.getEnvironment())) continue;
                if (first) {
                    first = false;
                    preTag.appendChild((Node)this.getHtmlFactory().createNewLineTag());
                    if (type0.getKind() == ElementKind.INTERFACE) {
                        preTag.appendText(this.getSARLGrammarKeywordAccess().getImplementsKeyword());
                    } else {
                        preTag.appendText(this.getSARLGrammarKeywordAccess().getExtendsKeyword());
                    }
                } else {
                    preTag.appendText(this.getSARLGrammarKeywordAccess().getCommaKeyword());
                }
                preTag.appendText(" ");
                preTag.appendChildren(this.getHtmlFactory().createTypeLink(typeMirror, true, CssStyles.TYPE_SIGNATURE, (HtmlFactoryContext)this));
            }
        }
    }

    protected void generateFunctionalInterfaceInfo(Element bodyTag, TypeElement typeElement) {
        if (typeElement.getKind() == ElementKind.INTERFACE && this.getEnvironment().getElementUtils().isFunctionalInterface(typeElement)) {
            Element dlTag = this.getHtmlFactory().createDlTag(bodyTag, CssStyles.NESTED_TYPE_INFO);
            Element dtTag = this.getHtmlFactory().createDtTag(dlTag, CssStyles.NESTED_TYPE_INFO);
            dtTag.appendText(Messages.AbstractTypeDocumentationGenerator_14);
            Element ddTag = this.getHtmlFactory().createDdTag(dlTag, CssStyles.NESTED_TYPE_INFO);
            ddTag.appendText(Messages.AbstractTypeDocumentationGenerator_15);
        }
    }

    protected void generateNestedTypeInfo(final Element parent, TypeElement typeElement) {
        javax.lang.model.element.Element outerClass = typeElement.getEnclosingElement();
        if (outerClass != null) {
            new SimpleElementVisitor9<Void, Void>(){

                @Override
                public Void visitType(TypeElement currentElement, Void parameter) {
                    Element dlTag = AbstractTypeDocumentationGenerator.this.getHtmlFactory().createDlTag(parent, CssStyles.NESTED_TYPE_INFO);
                    Element dtTag = AbstractTypeDocumentationGenerator.this.getHtmlFactory().createDtTag(dlTag, CssStyles.NESTED_TYPE_INFO);
                    if (currentElement.getKind() == ElementKind.INTERFACE) {
                        dtTag.appendText(Messages.AbstractTypeDocumentationGenerator_13);
                    } else {
                        dtTag.appendText(Messages.AbstractTypeDocumentationGenerator_12);
                    }
                    Element ddTag = AbstractTypeDocumentationGenerator.this.getHtmlFactory().createDdTag(dlTag, CssStyles.NESTED_TYPE_INFO);
                    ddTag.appendChildren(AbstractTypeDocumentationGenerator.this.getHtmlFactory().createTypeLink(currentElement, true, CssStyles.NESTED_TYPE_INFO, (HtmlFactoryContext)AbstractTypeDocumentationGenerator.this));
                    return null;
                }
            }.visit(outerClass);
        }
    }

    protected void generateInterfaceUsageInfo(Element parent, TypeElement typeElement) {
        Set<TypeElement> impl;
        if (typeElement.getKind() == ElementKind.INTERFACE && !(impl = this.getTypeHierarchy().getImplementingClasses(typeElement)).isEmpty()) {
            Element dlTag = this.getHtmlFactory().createDlTag(parent, CssStyles.IMPLEMENTING_CLASS_LIST);
            Element dtTag = this.getHtmlFactory().createDtTag(dlTag, CssStyles.IMPLEMENTING_CLASS_LIST);
            dtTag.appendText(Messages.AbstractTypeDocumentationGenerator_11);
            Element ddTag = this.getHtmlFactory().createDdTag(dlTag, CssStyles.IMPLEMENTING_CLASS_LIST);
            boolean first = true;
            for (TypeElement type : impl) {
                if (first) {
                    first = false;
                } else {
                    ddTag.appendText(Messages.AbstractTypeDocumentationGenerator_8);
                }
                ddTag.appendChildren(this.getHtmlFactory().createTypeLink(type, true, CssStyles.IMPLEMENTING_CLASS_LIST, (HtmlFactoryContext)this));
            }
        }
    }

    protected void generateSubTypeInfo(Element parent, TypeElement typeElement) {
        SortedSet<? extends TypeElement> directSubTypes = this.getTypeHierarchy().getDirectSubTypes(typeElement);
        if (!directSubTypes.isEmpty()) {
            Element dlTag = this.getHtmlFactory().createDlTag(parent, CssStyles.DIRECT_SUBTYPE_LIST);
            Element dtTag = this.getHtmlFactory().createDtTag(dlTag, CssStyles.DIRECT_SUBTYPE_LIST);
            if (typeElement.getKind() == ElementKind.INTERFACE) {
                dtTag.appendText(Messages.AbstractTypeDocumentationGenerator_9);
            } else {
                dtTag.appendText(Messages.AbstractTypeDocumentationGenerator_10);
            }
            Element ddTag = this.getHtmlFactory().createDdTag(dlTag, CssStyles.DIRECT_SUBTYPE_LIST);
            boolean first = true;
            for (TypeElement typeElement2 : directSubTypes) {
                if (first) {
                    first = false;
                } else {
                    ddTag.appendText(Messages.AbstractTypeDocumentationGenerator_8);
                }
                ddTag.appendChildren(this.getHtmlFactory().createTypeLink(typeElement2, true, CssStyles.DIRECT_SUBTYPE_LIST, (HtmlFactoryContext)this));
            }
        }
    }

    protected void generateSuperInterfacesInfo(Element parent, TypeElement typeElement) {
        SortedSet<? extends TypeMirror> interfaces = this.getElementUtils().getAllInterfaces(typeElement, this.getEnvironment());
        if (!interfaces.isEmpty()) {
            Element dlTag = this.getHtmlFactory().createDlTag(parent, CssStyles.SUPER_INTERFACE_LIST);
            Element dtTag = this.getHtmlFactory().createDtTag(dlTag, CssStyles.SUPER_INTERFACE_LIST);
            dtTag.appendText(Messages.AbstractTypeDocumentationGenerator_7);
            Element ddTag = this.getHtmlFactory().createDdTag(dlTag, CssStyles.SUPER_INTERFACE_LIST);
            boolean first = true;
            for (TypeMirror typeMirror : interfaces) {
                if (first) {
                    first = false;
                } else {
                    ddTag.appendText(Messages.AbstractTypeDocumentationGenerator_8);
                }
                ddTag.appendChildren(this.getHtmlFactory().createTypeLink(typeMirror, true, CssStyles.SUPER_INTERFACE_LIST, (HtmlFactoryContext)this));
            }
        }
    }

    protected void generateTypeParameterInfo(Element parent, TypeElement typeElement) {
        if (!typeElement.getTypeParameters().isEmpty()) {
            Element dlTag = this.getHtmlFactory().createDlTag(parent, CssStyles.TYPE_PARAMETER_LIST);
            Element dtTag = this.getHtmlFactory().createDtTag(dlTag, CssStyles.TYPE_PARAMETER_LIST);
            dtTag.appendText(Messages.AbstractTypeDocumentationGenerator_4);
            for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
                Element ddTag = this.getHtmlFactory().createDdTag(dlTag, CssStyles.TYPE_PARAMETER_LIST);
                List<? extends DocTree> comment = this.getDocUtils().getTypeParameterComment(typeElement, typeParameterElement.getSimpleName().toString(), this.getEnvironment());
                ddTag.appendText(MessageFormat.format(Messages.AbstractTypeDocumentationGenerator_5, typeParameterElement.getSimpleName().toString()));
                HtmlFactory.CommentTextMemory memory = this.getHtmlFactory().createCommentTextMemory(ddTag, typeElement, this);
                for (DocTree docTree : comment) {
                    this.getHtmlFactory().createCommentText(memory, docTree, CssStyles.TYPE_PARAMETER_LIST);
                }
            }
        }
    }

    protected void generateTypeTree(Element parent, TypeElement typeElement) {
        Element divTag = this.getHtmlFactory().createDivTag(parent, CssStyles.INHERITANCE_TREE);
        this.getHtmlFactory().createTypeInheritanceTree(divTag, typeElement.asType(), CssStyles.INHERITANCE_TREE_TREE, CssStyles.INHERITANCE_TREE_TYPE, this);
    }

    protected void generatePrivateApiMessage(Element parent, TypeElement typeElement) {
        Element messageDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER_PRIVATEAPI_MESSAGE);
        messageDiv.appendText(MessageFormat.format(Messages.AbstractTypeDocumentationGenerator_18, typeElement.getSimpleName().toString()));
    }

    protected void generateTypeIntroduction(Element parent, TypeElement typeElement) {
        String name;
        PackageElement packageElement;
        ModuleElement module = this.getEnvironment().getElementUtils().getModuleOf(typeElement);
        if (!module.isUnnamed()) {
            Element moduleNameDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER_MODULE_NAME);
            moduleNameDiv.appendText(Messages.AbstractTypeDocumentationGenerator_2);
            this.getHtmlFactory().createUnsecableSpace(moduleNameDiv);
            List<Node> moduleLink = this.getHtmlFactory().createModuleLink(module, module.getQualifiedName().toString(), CssStyles.HEADER_MODULE_NAME, (HtmlFactoryContext)this);
            moduleNameDiv.appendChildren(moduleLink);
        }
        if (!(packageElement = this.getEnvironment().getElementUtils().getPackageOf(typeElement)).isUnnamed()) {
            Element packageNameDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER_PACKAGE_NAME);
            List<Node> packageLink = this.getHtmlFactory().createPackageLink(packageElement, packageElement.getQualifiedName().toString(), CssStyles.HEADER_PACKAGE_NAME, (HtmlFactoryContext)this);
            packageNameDiv.appendChildren(packageLink);
        }
        Element nameDiv = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER_TYPE_NAME);
        if (!typeElement.getTypeParameters().isEmpty()) {
            StringBuilder params = new StringBuilder();
            for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
                if (params.length() > 0) {
                    params.append(", ");
                }
                params.append(typeParameterElement.getSimpleName().toString());
            }
            name = MessageFormat.format(Messages.AbstractTypeDocumentationGenerator_6, typeElement.getSimpleName().toString(), params.toString());
        } else {
            name = typeElement.getSimpleName().toString();
        }
        nameDiv.appendText(this.getTypeHeaderText(name.toString()));
    }

    protected void generateBodyHeader(Element parent, TypeElement typeElement) {
        Element divTag = this.getHtmlFactory().createDivTag(parent, CssStyles.HEADER);
        this.generateHeaderNavigationBar(divTag, typeElement);
        if (this.getElementUtils().isPrivateAPI(typeElement)) {
            this.generatePrivateApiMessage(divTag, typeElement);
        }
    }

    protected void generateHeaderNavigationBar(Element parent, TypeElement typeElement) {
        this.getNavigation().createNavigationBar(parent);
    }

    protected void generateFooterNavigationBar(Element parent, TypeElement typeElement) {
        this.getNavigation().createNavigationBar(parent);
    }

    protected void generateBodyFooter(Element parent, TypeElement typeElement) {
        Element divTag = this.getHtmlFactory().createDivTag(parent, CssStyles.FOOTER);
        this.generateFooterNavigationBar(divTag, typeElement);
        this.createCopyrightBox(divTag);
    }

    protected abstract String getTypeHeaderText(String var1);
}

