/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2021 the original authors or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.core;

import io.sarl.core.Failure;
import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * Notifies an agent that a failure has occurred when it tried to commit a suicide.
 * The event is fired within the default space of the inner context of the failing agent.
 * Subclasses of this event could be defined in order to specify more in detail the failure.
 * Only the killing agent receives this event.
 * 
 * @author <a href="http://www.ciad-lab.fr/author-10836/">St&eacute;phane Galland</a>
 * @version io.sarl.core 0.12.0 20210527-171007
 * @mavengroupid io.sarl
 * @mavenartifactid io.sarl.core
 * @since 0.12
 */
@SarlSpecification("0.12")
@SarlElementType(15)
@SuppressWarnings("all")
public class AgentKillFailure extends Failure {
  /**
   * Construct the event.
   * 
   * @param source the address of the emitter.
   * @param cause the cause of the failure.
   */
  @DefaultValueSource
  public AgentKillFailure(@DefaultValue("io.sarl.core.AgentKillFailure#NEW_0") final Address source, final Object cause) {
    super(source, cause);
  }
  
  /**
   * Default value for the parameter source
   */
  @Pure
  @SyntheticMember
  @SarlSourceCode("null")
  private static Address $DEFAULT_VALUE$NEW_0() {
    return null;
  }
  
  /**
   * Construct the event.
   * 
   * @optionalparam source the address of the emitter.
   * @optionalparam cause the cause of the failure.
   */
  @DefaultValueUse("io.sarl.lang.core.Address,java.lang.Object")
  @SyntheticMember
  public AgentKillFailure(final Object cause) {
    this($DEFAULT_VALUE$NEW_0(), cause);
  }
  
  @SyntheticMember
  private static final long serialVersionUID = 820096355L;
}
