/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2021 the original authors or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.core;

import io.sarl.lang.annotation.EarlyExit;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Event;

/**
 * Notifies the destruction of an element.
 * The source of this event is the agent itself.
 * This event is marked as an early exit event. It means that any action that is firing this
 * event is supposed to never return, e.g. the <code>killMe</code> action.
 * 
 * <h4>For an Agent</h4>
 * This event is received by the agent's native behavior when the agent is destroyed, usually after
 * a call to {@code killMe}.
 * All the agent behaviors of the agent are unregistered prior to the firing of this events.
 * All the agent tasks are canceled prior to the firing of this events.
 * Agent skills are uninstalled after the {@code Destroy} event handler is ran.
 * 
 * <h4>For a Behavior</h4>
 * Each Behavior instance within the agent receives this event when it is unregistered for the last time.
 * 
 * <h4>For a Skill</h4>
 * No skill receives this event, except if you have registered the skill as an event listener on the
 * agent internal event bus. In the last case, the skill will receive the {@code Destroy} event because
 * is will be uninstalled after its firing.
 * 
 * <h4>For Agent Members</h4>
 * The member agents do not receive this event from the parent agent because the parent agent cannot be
 * destroyed if it has agent members.
 * 
 * @author <a href="http://www.sebastianrodriguez.com.ar/">Sebastian Rodriguez</a>
 * @author <a href="http://www.ciad-lab.fr/author-10836/">St&eacute;phane Galland</a>
 * @version io.sarl.core 0.12.0 20210527-171007
 * @mavengroupid io.sarl
 * @mavenartifactid io.sarl.core
 */
@EarlyExit
@SarlSpecification("0.12")
@SarlElementType(15)
@SuppressWarnings("all")
public final class Destroy extends Event {
  @SyntheticMember
  public Destroy() {
    super();
  }
  
  @SyntheticMember
  public Destroy(final Address arg0) {
    super(arg0);
  }
  
  @SyntheticMember
  private static final long serialVersionUID = 588368462L;
}
