/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2021 the original authors or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.core;

import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.SpaceID;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Notifies other participants that the member has effectively
 * left the space.
 * The event is fired within the default space of the context in which the agent left the space.
 * The leaving agent does not receive this event.
 * The source of the event is the leaving agent.
 * 
 * @author <a href="http://www.ciad-lab.fr/author-10834/">Nicolas Gaud</a>
 * @version io.sarl.core 0.12.0 20210527-171007
 * @mavengroupid io.sarl
 * @mavenartifactid io.sarl.core
 * @since 0.10
 */
@SarlSpecification("0.12")
@SarlElementType(15)
@SuppressWarnings("all")
public final class ParticipantLeft extends Event {
  /**
   * The identifier of the space the agent just left.
   */
  public final SpaceID spaceID;
  
  /**
   * Construct the event.
   * 
   * @param source the address of the emitter.
   * @param spaceID the identifier of the space.
   */
  public ParticipantLeft(final Address source, final SpaceID spaceID) {
    this.setSource(source);
    this.spaceID = spaceID;
  }
  
  @Override
  @Pure
  @SyntheticMember
  public boolean equals(final Object obj) {
    return super.equals(obj);
  }
  
  @Override
  @Pure
  @SyntheticMember
  public int hashCode() {
    int result = super.hashCode();
    return result;
  }
  
  /**
   * Returns a String representation of the ParticipantLeft event's attributes only.
   */
  @SyntheticMember
  @Pure
  protected void toString(final ToStringBuilder builder) {
    super.toString(builder);
    builder.add("spaceID", this.spaceID);
  }
  
  @SyntheticMember
  private static final long serialVersionUID = 797360011L;
}
