/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.SarlAsynchronousExecution;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.Scope;
import io.sarl.lang.util.ConcurrentCollection;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.12")
@SarlElementType(value=20)
public interface Behaviors
extends Capacity {
    @Pure
    public boolean hasRegisteredBehavior();

    @Pure
    public ConcurrentCollection<Behavior> getRegisteredBehaviors();

    @DefaultValueSource
    public Behavior registerBehavior(Behavior var1, @DefaultValue(value="io.sarl.core.Behaviors#REGISTERBEHAVIOR_0") Functions.Function1<? super Event, ? extends Boolean> var2, Object ... var3);

    public Behavior unregisterBehavior(Behavior var1);

    @DefaultValueSource
    @SarlAsynchronousExecution
    public void wake(Event var1, @DefaultValue(value="io.sarl.core.Behaviors#WAKE_0") Scope<Address> var2);

    @SarlAsynchronousExecution
    public void wake(Behavior var1, Event var2);

    @SarlAsynchronousExecution
    public void wake(Iterable<Behavior> var1, Event var2);

    @Pure
    public EventListener asEventListener();

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public Functions.Function1 $DEFAULT_VALUE$REGISTERBEHAVIOR_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public Scope $DEFAULT_VALUE$WAKE_0() {
        return null;
    }

    @DefaultValueUse(value="io.sarl.lang.core.Behavior,(io.sarl.lang.core.Event)=>boolean,java.lang.Object*")
    @SyntheticMember
    default public Behavior registerBehavior(Behavior attitude, Object ... initializationParameters) {
        return this.registerBehavior(attitude, (Functions.Function1<? super Event, ? extends Boolean>)this.$DEFAULT_VALUE$REGISTERBEHAVIOR_0(), initializationParameters);
    }

    @DefaultValueUse(value="io.sarl.lang.core.Event,io.sarl.lang.core.Scope")
    @SyntheticMember
    @SarlAsynchronousExecution
    default public void wake(Event event) {
        this.wake(event, (Scope<Address>)this.$DEFAULT_VALUE$WAKE_0());
    }

    public static class ContextAwareCapacityWrapper<C extends Behaviors>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements Behaviors {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public boolean hasRegisteredBehavior() {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((Behaviors)this.capacity).hasRegisteredBehavior();
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public ConcurrentCollection<Behavior> getRegisteredBehaviors() {
            try {
                this.ensureCallerInLocalThread();
                ConcurrentCollection<Behavior> concurrentCollection = ((Behaviors)this.capacity).getRegisteredBehaviors();
                return concurrentCollection;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Behavior registerBehavior(Behavior attitude, Functions.Function1<? super Event, ? extends Boolean> filter, Object ... initializationParameters) {
            try {
                this.ensureCallerInLocalThread();
                Behavior behavior = ((Behaviors)this.capacity).registerBehavior(attitude, filter, initializationParameters);
                return behavior;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Behavior unregisterBehavior(Behavior attitude) {
            try {
                this.ensureCallerInLocalThread();
                Behavior behavior = ((Behaviors)this.capacity).unregisterBehavior(attitude);
                return behavior;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void wake(Event event, Scope<Address> scope) {
            try {
                this.ensureCallerInLocalThread();
                ((Behaviors)this.capacity).wake(event, scope);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void wake(Behavior behavior, Event event) {
            try {
                this.ensureCallerInLocalThread();
                ((Behaviors)this.capacity).wake(behavior, event);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void wake(Iterable<Behavior> behaviors, Event event) {
            try {
                this.ensureCallerInLocalThread();
                ((Behaviors)this.capacity).wake(behaviors, event);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public EventListener asEventListener() {
            try {
                this.ensureCallerInLocalThread();
                EventListener eventListener = ((Behaviors)this.capacity).asEventListener();
                return eventListener;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Behavior registerBehavior(Behavior attitude, Object ... initializationParameters) {
            try {
                this.ensureCallerInLocalThread();
                Behavior behavior = ((Behaviors)this.capacity).registerBehavior(attitude, initializationParameters);
                return behavior;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void wake(Event event) {
            try {
                this.ensureCallerInLocalThread();
                ((Behaviors)this.capacity).wake(event);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

