/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.core.AgentKillFailure;
import io.sarl.core.AgentKilled;
import io.sarl.core.AgentSpawnFailure;
import io.sarl.core.AgentSpawned;
import io.sarl.core.Destroy;
import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.EarlyExit;
import io.sarl.lang.annotation.FiredEvent;
import io.sarl.lang.annotation.SarlAsynchronousExecution;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.12")
@SarlElementType(value=20)
public interface Lifecycle
extends Capacity {
    @FiredEvent(value={AgentSpawned.class, AgentSpawnFailure.class})
    @SarlAsynchronousExecution
    public void spawn(Class<? extends Agent> var1, Object ... var2);

    @FiredEvent(value={AgentSpawned.class, AgentSpawnFailure.class})
    @SarlAsynchronousExecution
    public void spawn(int var1, Class<? extends Agent> var2, Object ... var3);

    @FiredEvent(value={AgentSpawned.class, AgentSpawnFailure.class})
    @SarlAsynchronousExecution
    public void spawnInContext(Class<? extends Agent> var1, AgentContext var2, Object ... var3);

    @FiredEvent(value={AgentSpawned.class, AgentSpawnFailure.class})
    @SarlAsynchronousExecution
    public void spawnInContext(int var1, Class<? extends Agent> var2, AgentContext var3, Object ... var4);

    @FiredEvent(value={AgentSpawned.class, AgentSpawnFailure.class})
    @SarlAsynchronousExecution
    public void spawnInContextWithID(Class<? extends Agent> var1, UUID var2, AgentContext var3, Object ... var4);

    @FiredEvent(value={AgentSpawned.class, AgentSpawnFailure.class})
    @SarlAsynchronousExecution
    public void spawnWithID(Class<? extends Agent> var1, UUID var2, Object ... var3);

    @DefaultValueSource
    @FiredEvent(value={AgentKilled.class, Destroy.class, AgentKillFailure.class})
    @EarlyExit
    public void killMe(@DefaultValue(value="io.sarl.core.Lifecycle#KILLME_0") Object var1);

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public Object $DEFAULT_VALUE$KILLME_0() {
        return null;
    }

    @DefaultValueUse(value="java.lang.Object")
    @SyntheticMember
    @FiredEvent(value={AgentKilled.class, Destroy.class, AgentKillFailure.class})
    @EarlyExit
    default public void killMe() {
        this.killMe(this.$DEFAULT_VALUE$KILLME_0());
    }

    public static class ContextAwareCapacityWrapper<C extends Lifecycle>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements Lifecycle {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public void spawn(Class<? extends Agent> agentType, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                ((Lifecycle)this.capacity).spawn(agentType, params);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void spawn(int nbAgents, Class<? extends Agent> agentType, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                ((Lifecycle)this.capacity).spawn(nbAgents, agentType, params);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void spawnInContext(Class<? extends Agent> agentClass, AgentContext context, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                ((Lifecycle)this.capacity).spawnInContext(agentClass, context, params);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void spawnInContext(int nbAgents, Class<? extends Agent> agentClass, AgentContext context, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                ((Lifecycle)this.capacity).spawnInContext(nbAgents, agentClass, context, params);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void spawnInContextWithID(Class<? extends Agent> agentClass, UUID agentID, AgentContext context, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                ((Lifecycle)this.capacity).spawnInContextWithID(agentClass, agentID, context, params);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void spawnWithID(Class<? extends Agent> agentClass, UUID agentID, Object ... params) {
            try {
                this.ensureCallerInLocalThread();
                ((Lifecycle)this.capacity).spawnWithID(agentClass, agentID, params);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void killMe(Object terminationCause) {
            try {
                this.ensureCallerInLocalThread();
                ((Lifecycle)this.capacity).killMe(terminationCause);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void killMe() {
            try {
                this.ensureCallerInLocalThread();
                ((Lifecycle)this.capacity).killMe();
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

