/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.12")
@SarlElementType(value=20)
public interface Logging
extends Capacity {
    public void setLoggingName(String var1);

    @Deprecated
    public void println(Object var1);

    @DefaultValueSource
    public void error(Object var1, @DefaultValue(value="io.sarl.core.Logging#ERROR_0") Throwable var2, Object ... var3);

    public void error(Supplier<String> var1);

    @DefaultValueSource
    public void warning(Object var1, @DefaultValue(value="io.sarl.core.Logging#WARNING_0") Throwable var2, Object ... var3);

    public void warning(Supplier<String> var1);

    public void info(Object var1, Object ... var2);

    public void info(Supplier<String> var1);

    public void debug(Object var1, Object ... var2);

    public void debug(Supplier<String> var1);

    @Pure
    public boolean isErrorLogEnabled();

    @Pure
    public boolean isWarningLogEnabled();

    @Pure
    public boolean isInfoLogEnabled();

    @Pure
    public boolean isDebugLogEnabled();

    @Pure
    public int getLogLevel();

    public void setLogLevel(int var1);

    @Pure
    public Logger getLogger();

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public Throwable $DEFAULT_VALUE$ERROR_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public Throwable $DEFAULT_VALUE$WARNING_0() {
        return null;
    }

    @DefaultValueUse(value="java.lang.Object,java.lang.Throwable,java.lang.Object*")
    @SyntheticMember
    default public void error(Object message, Object ... parameters) {
        this.error(message, this.$DEFAULT_VALUE$ERROR_0(), parameters);
    }

    @DefaultValueUse(value="java.lang.Object,java.lang.Throwable,java.lang.Object*")
    @SyntheticMember
    default public void warning(Object message, Object ... parameters) {
        this.warning(message, this.$DEFAULT_VALUE$WARNING_0(), parameters);
    }

    public static class ContextAwareCapacityWrapper<C extends Logging>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements Logging {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public void setLoggingName(String name) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).setLoggingName(name);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void println(Object message) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).println(message);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void error(Object message, Throwable exception, Object ... parameters) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).error(message, exception, parameters);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void error(Supplier<String> messageProvider) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).error(messageProvider);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void warning(Object message, Throwable exception, Object ... parameters) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).warning(message, exception, parameters);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void warning(Supplier<String> messageProvider) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).warning(messageProvider);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void info(Object message, Object ... parameters) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).info(message, parameters);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void info(Supplier<String> messageProvider) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).info(messageProvider);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void debug(Object message, Object ... parameters) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).debug(message, parameters);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void debug(Supplier<String> messageProvider) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).debug(messageProvider);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isErrorLogEnabled() {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((Logging)this.capacity).isErrorLogEnabled();
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isWarningLogEnabled() {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((Logging)this.capacity).isWarningLogEnabled();
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isInfoLogEnabled() {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((Logging)this.capacity).isInfoLogEnabled();
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isDebugLogEnabled() {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((Logging)this.capacity).isDebugLogEnabled();
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public int getLogLevel() {
            try {
                this.ensureCallerInLocalThread();
                int n = ((Logging)this.capacity).getLogLevel();
                return n;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void setLogLevel(int level) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).setLogLevel(level);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Logger getLogger() {
            try {
                this.ensureCallerInLocalThread();
                Logger logger = ((Logging)this.capacity).getLogger();
                return logger;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void error(Object message, Object ... parameters) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).error(message, parameters);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void warning(Object message, Object ... parameters) {
            try {
                this.ensureCallerInLocalThread();
                ((Logging)this.capacity).warning(message, parameters);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

