/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.core.AgentTask;
import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.util.ConcurrentSet;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.12")
@SarlElementType(value=20)
public interface Schedules
extends Capacity {
    @Pure
    public ConcurrentSet<String> getActiveTasks();

    @DefaultValueSource
    public AgentTask in(@DefaultValue(value="io.sarl.core.Schedules#IN_0") AgentTask var1, long var2, Procedures.Procedure1<? super Agent> var4);

    public AgentTask task(String var1);

    public void setName(AgentTask var1, String var2);

    @DefaultValueSource
    public boolean cancel(AgentTask var1, @DefaultValue(value="io.sarl.core.Schedules#CANCEL_0") boolean var2);

    @Pure
    public boolean isCanceled(AgentTask var1);

    @DefaultValueSource
    public AgentTask every(@DefaultValue(value="io.sarl.core.Schedules#EVERY_0") AgentTask var1, long var2, Procedures.Procedure1<? super Agent> var4);

    @DefaultValueSource
    public AgentTask atFixedDelay(@DefaultValue(value="io.sarl.core.Schedules#ATFIXEDDELAY_0") AgentTask var1, long var2, Procedures.Procedure1<? super Agent> var4);

    @DefaultValueSource
    public AgentTask execute(@DefaultValue(value="io.sarl.core.Schedules#EXECUTE_0") AgentTask var1, Procedures.Procedure1<? super Agent> var2);

    @DefaultValueSource
    public AgentTask at(@DefaultValue(value="io.sarl.core.Schedules#AT_0") AgentTask var1, long var2, Procedures.Procedure1<? super Agent> var4);

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public AgentTask $DEFAULT_VALUE$IN_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="true")
    default public boolean $DEFAULT_VALUE$CANCEL_0() {
        return true;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public AgentTask $DEFAULT_VALUE$EVERY_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public AgentTask $DEFAULT_VALUE$ATFIXEDDELAY_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public AgentTask $DEFAULT_VALUE$EXECUTE_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public AgentTask $DEFAULT_VALUE$AT_0() {
        return null;
    }

    @DefaultValueUse(value="io.sarl.core.AgentTask,long,(io.sarl.lang.core.Agent)=>void")
    @SyntheticMember
    default public AgentTask in(long delay, Procedures.Procedure1<? super Agent> procedure) {
        return this.in(this.$DEFAULT_VALUE$IN_0(), delay, procedure);
    }

    @DefaultValueUse(value="io.sarl.core.AgentTask,boolean")
    @SyntheticMember
    default public boolean cancel(AgentTask task) {
        return this.cancel(task, this.$DEFAULT_VALUE$CANCEL_0());
    }

    @DefaultValueUse(value="io.sarl.core.AgentTask,long,(io.sarl.lang.core.Agent)=>void")
    @SyntheticMember
    default public AgentTask every(long period, Procedures.Procedure1<? super Agent> procedure) {
        return this.every(this.$DEFAULT_VALUE$EVERY_0(), period, procedure);
    }

    @DefaultValueUse(value="io.sarl.core.AgentTask,long,(io.sarl.lang.core.Agent)=>void")
    @SyntheticMember
    default public AgentTask atFixedDelay(long delay, Procedures.Procedure1<? super Agent> procedure) {
        return this.atFixedDelay(this.$DEFAULT_VALUE$ATFIXEDDELAY_0(), delay, procedure);
    }

    @DefaultValueUse(value="io.sarl.core.AgentTask,(io.sarl.lang.core.Agent)=>void")
    @SyntheticMember
    default public AgentTask execute(Procedures.Procedure1<? super Agent> procedure) {
        return this.execute(this.$DEFAULT_VALUE$EXECUTE_0(), procedure);
    }

    @DefaultValueUse(value="io.sarl.core.AgentTask,long,(io.sarl.lang.core.Agent)=>void")
    @SyntheticMember
    default public AgentTask at(long time, Procedures.Procedure1<? super Agent> procedure) {
        return this.at(this.$DEFAULT_VALUE$AT_0(), time, procedure);
    }

    public static class ContextAwareCapacityWrapper<C extends Schedules>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements Schedules {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public ConcurrentSet<String> getActiveTasks() {
            try {
                this.ensureCallerInLocalThread();
                ConcurrentSet<String> concurrentSet = ((Schedules)this.capacity).getActiveTasks();
                return concurrentSet;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AgentTask in(AgentTask task, long delay, Procedures.Procedure1<? super Agent> procedure) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).in(task, delay, procedure);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public AgentTask task(String name) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).task(name);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void setName(AgentTask task, String name) {
            try {
                this.ensureCallerInLocalThread();
                ((Schedules)this.capacity).setName(task, name);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(AgentTask task, boolean mayInterruptIfRunning) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((Schedules)this.capacity).cancel(task, mayInterruptIfRunning);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isCanceled(AgentTask task) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((Schedules)this.capacity).isCanceled(task);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AgentTask every(AgentTask task, long period, Procedures.Procedure1<? super Agent> procedure) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).every(task, period, procedure);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AgentTask atFixedDelay(AgentTask task, long delay, Procedures.Procedure1<? super Agent> procedure) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).atFixedDelay(task, delay, procedure);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AgentTask execute(AgentTask task, Procedures.Procedure1<? super Agent> procedure) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).execute(task, procedure);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AgentTask at(AgentTask task, long time, Procedures.Procedure1<? super Agent> procedure) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).at(task, time, procedure);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AgentTask in(long delay, Procedures.Procedure1<? super Agent> procedure) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).in(delay, procedure);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean cancel(AgentTask task) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((Schedules)this.capacity).cancel(task);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AgentTask every(long period, Procedures.Procedure1<? super Agent> procedure) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).every(period, procedure);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AgentTask atFixedDelay(long delay, Procedures.Procedure1<? super Agent> procedure) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).atFixedDelay(delay, procedure);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public AgentTask execute(Procedures.Procedure1<? super Agent> procedure) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).execute(procedure);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AgentTask at(long time, Procedures.Procedure1<? super Agent> procedure) {
            try {
                this.ensureCallerInLocalThread();
                AgentTask agentTask = ((Schedules)this.capacity).at(time, procedure);
                return agentTask;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

