/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.core;

import io.sarl.lang.annotation.DefaultValue;
import io.sarl.lang.annotation.DefaultValueSource;
import io.sarl.lang.annotation.DefaultValueUse;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSourceCode;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.12")
@SarlElementType(value=20)
public interface Time
extends Capacity {
    @DefaultValueSource
    @Pure
    public double getTime(@DefaultValue(value="io.sarl.core.Time#GETTIME_0") TimeUnit var1);

    @Pure
    public double getOSTimeFactor();

    @Pure
    public double toOSTime(double var1);

    public double fromOSTime(double var1);

    @Pure
    public double toOSDuration(double var1);

    public double fromOSDuration(double var1);

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    default public TimeUnit $DEFAULT_VALUE$GETTIME_0() {
        return null;
    }

    @DefaultValueUse(value="java.util.concurrent.TimeUnit")
    @SyntheticMember
    @Pure
    default public double getTime() {
        return this.getTime(this.$DEFAULT_VALUE$GETTIME_0());
    }

    public static class ContextAwareCapacityWrapper<C extends Time>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements Time {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getTime(TimeUnit timeUnit) {
            try {
                this.ensureCallerInLocalThread();
                double d = ((Time)this.capacity).getTime(timeUnit);
                return d;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public double getOSTimeFactor() {
            try {
                this.ensureCallerInLocalThread();
                double d = ((Time)this.capacity).getOSTimeFactor();
                return d;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double toOSTime(double timeValue) {
            try {
                this.ensureCallerInLocalThread();
                double d = ((Time)this.capacity).toOSTime(timeValue);
                return d;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double fromOSTime(double timeValue) {
            try {
                this.ensureCallerInLocalThread();
                double d = ((Time)this.capacity).fromOSTime(timeValue);
                return d;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double toOSDuration(double timeDuration) {
            try {
                this.ensureCallerInLocalThread();
                double d = ((Time)this.capacity).toOSDuration(timeDuration);
                return d;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double fromOSDuration(double timeDuration) {
            try {
                this.ensureCallerInLocalThread();
                double d = ((Time)this.capacity).fromOSDuration(timeDuration);
                return d;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public double getTime() {
            try {
                this.ensureCallerInLocalThread();
                double d = ((Time)this.capacity).getTime();
                return d;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

