/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2021 the original authors or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.util;

import com.google.inject.BindingAnnotation;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation that is used for marking formal parameters and object fields in order to
 * received the default space instance of a SARL context.
 * 
 * <p>This annotation has the contract to be associated to: i) a formal parameter or an object field
 * of type {@link OpenEventspace} and to the {@code @Inject} annotation, and ii) to be used only
 * inside a subtype of {@code Space}.
 * 
 * <p>When a formal parameter or a field is in a subtype of {@code Space} and it is injectable and
 * marked with this annotation, the SARL run-time environment is supposed to inject the instance
 * of the default space of the context in which the injected space is located.
 * 
 * @author <a href="http://www.ciad-lab.fr/author-10836/">St&eacute;phane Galland</a>
 * @version io.sarl.util 0.12.0 20210527-171007
 * @mavengroupid io.sarl
 * @mavenartifactid io.sarl.util
 * @since 0.10
 */
@Target({ ElementType.PARAMETER, ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
@BindingAnnotation
@SarlSpecification("0.12")
@SarlElementType(13)
@SuppressWarnings("all")
public @interface DefaultSpace {
}
