/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2021 the original authors or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.util;

import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import java.util.EventListener;
import java.util.function.Consumer;

/**
 * This interface represents an object that is able to provide a notification policy
 * for calling Java event listeners.
 * 
 * @author <a href="http://www.ciad-lab.fr/author-10836/">St&eacute;phane Galland</a>
 * @version io.sarl.util 0.12.0 20210527-171007
 * @mavengroupid io.sarl
 * @mavenartifactid io.sarl.util
 * @since 0.10
 */
@FunctionalInterface
@SarlSpecification("0.12")
@SarlElementType(11)
@SuppressWarnings("all")
public interface ListenerNotifier {
  /**
   * Build a call policy for the given list of listeners and call them.
   * 
   * @param <L> the type of event listener to support.
   * @param listeners is the list of listeners to call.
   * @param action is the action to apply on each listener.
   */
  <L extends EventListener> void notifyListeners(final L[] listeners, final Consumer<L> action);
}
