/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2021 the original authors or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.util;

import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.util.ListenerNotifier;
import java.util.EventListener;
import java.util.function.Consumer;

/**
 * This class implements a sequence execution mechanism for notifying the event listeners.
 * 
 * @author <a href="http://www.ciad-lab.fr/author-10836/">St&eacute;phane Galland</a>
 * @version io.sarl.util 0.12.0 20210527-171007
 * @mavengroupid io.sarl
 * @mavenartifactid io.sarl.util
 * @since 0.10
 */
@SarlSpecification("0.12")
@SarlElementType(10)
@SuppressWarnings("all")
public class SequenceListenerNotifier implements ListenerNotifier {
  @Override
  public <L extends EventListener> void notifyListeners(final L[] listeners, final Consumer<L> action) {
    for (final L listener : listeners) {
      action.accept(listener);
    }
  }
  
  @SyntheticMember
  public SequenceListenerNotifier() {
    super();
  }
}
