/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2021 the original authors or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.util;

import io.sarl.lang.annotation.Injectable;
import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.util.ListenerNotifier;
import java.util.EventListener;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.arakhne.afc.util.ListenerCollection;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * A smart implementation of an event listeners' collection.
 * This collection knows how to schedule the calls to the listeners.
 * 
 * @author <a href="http://www.ciad-lab.fr/author-10836/">St&eacute;phane Galland</a>
 * @version io.sarl.util 0.12.0 20210527-171007
 * @mavengroupid io.sarl
 * @mavenartifactid io.sarl.util
 * @since 0.10
 */
@SuppressWarnings("manual_inline_definition")
@SarlSpecification("0.12")
@SarlElementType(10)
@Injectable
public class SmartListenerCollection<T extends EventListener> extends ListenerCollection<T> implements ListenerNotifier {
  private final ListenerNotifier notifier;
  
  /**
   * Constructor.
   * 
   * @param notifier is the notifier to the listeners that must be used by this collection.
   */
  @Inject
  public SmartListenerCollection(final ListenerNotifier notifier) {
    this.notifier = notifier;
  }
  
  @Override
  public <L extends EventListener> void notifyListeners(final L[] listeners, final Consumer<L> action) {
    this.notifier.<L>notifyListeners(listeners, action);
  }
  
  /**
   * Build a call policy for the given list of listeners and call them.
   * 
   * @param <L> the type of event listener to support.
   * @param type the type of the listeners to be called.
   * @param action is the action to apply on each listener.
   */
  public <L extends EventListener> void notifyListeners(final Class<L> type, final Consumer<L> action) {
    this.<L>notifyListeners(this.<L>getListeners(type), action);
  }
  
  @Override
  @Pure
  @SyntheticMember
  public boolean equals(final Object obj) {
    return super.equals(obj);
  }
  
  @Override
  @Pure
  @SyntheticMember
  public int hashCode() {
    int result = super.hashCode();
    return result;
  }
}
