/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.util;

import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@SarlSpecification(value="0.12")
@SarlElementType(value=10)
public final class Collections3 {
    @Pure
    public static <T> Collection<T> serializableCollection(Collection<T> elements) {
        if (elements instanceof Serializable) {
            return elements;
        }
        return new SerializableCollectionWrapper<T>(elements);
    }

    @SyntheticMember
    public Collections3() {
    }

    @SarlSpecification(value="0.12")
    @SarlElementType(value=10)
    private static class SerializableCollectionWrapper<E>
    extends AbstractCollection<E>
    implements Serializable {
        private transient Collection<E> collection;
        @SyntheticMember
        private static final long serialVersionUID = -4813965186L;

        SerializableCollectionWrapper(Collection<E> collection) {
            this.collection = collection;
        }

        @Override
        public Iterator<E> iterator() {
            return this.collection.iterator();
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        private void writeObject(ObjectOutputStream stream) {
            try {
                stream.defaultWriteObject();
                stream.writeInt(this.collection.size());
                for (E element : this.collection) {
                    stream.writeObject(element);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        private void readObject(ObjectInputStream stream) {
            try {
                stream.defaultReadObject();
                int s = stream.readInt();
                ArrayList _arrayList = new ArrayList(s);
                this.collection = _arrayList;
                for (int i = 0; i < s; ++i) {
                    Object _readObject = stream.readObject();
                    this.collection.add(_readObject);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        @Override
        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

