/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.util;

import io.sarl.lang.annotation.SarlElementType;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.annotation.SyntheticMember;
import io.sarl.util.JulPatternFormatter$1$AssertEvaluator$;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SarlSpecification(value="0.12")
@SarlElementType(value=10)
public class JulPatternFormatter
extends Formatter {
    private final String pattern;
    private final Date dat = new Date();

    public JulPatternFormatter(String pattern) {
        assert (new JulPatternFormatter$1$AssertEvaluator$((JulPatternFormatter)this, (String)pattern).$$result);
        this.pattern = pattern;
    }

    @Override
    public String format(LogRecord record) {
        this.dat.setTime(record.getMillis());
        StringBuilder source = new StringBuilder();
        String scn = record.getSourceClassName();
        String logName = record.getLoggerName();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)scn);
        if (!_isNullOrEmpty) {
            source.append(scn);
            String smn = record.getSourceMethodName();
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)smn);
            if (!_isNullOrEmpty_1) {
                source.append(" ");
                source.append(smn);
            }
        } else {
            source.append(logName);
        }
        String message = this.formatMessage(record);
        String throwable = null;
        Throwable _thrown = record.getThrown();
        if (_thrown != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                pw.println();
                record.getThrown().printStackTrace(pw);
            }
            throwable = sw.toString();
        } else {
            throwable = "";
        }
        return String.format(this.pattern, this.dat, source, this.filterLogName(logName), record.getLevel().getLocalizedName(), message, throwable);
    }

    @Pure
    protected String filterLogName(String logName) {
        return logName;
    }

    @Pure
    @SyntheticMember
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JulPatternFormatter other = (JulPatternFormatter)obj;
        if (!Objects.equals(this.pattern, other.pattern)) {
            return false;
        }
        return super.equals(obj);
    }

    @Pure
    @SyntheticMember
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + Objects.hashCode(this.pattern);
        return result;
    }
}

