/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.api.game.tgob;

import io.sarl.api.game.tgob.AbstractGob;
import io.sarl.api.game.tgob.Action;
import io.sarl.api.game.tgob.Goal;
import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.DefaultValueSource;
import io.sarl.lang.core.annotation.DefaultValueUse;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSourceCode;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@SarlSpecification(value="0.15")
@SarlElementType(value=10)
@XbaseGenerated
public class BaseAction
extends AbstractGob
implements Action {
    @Accessors
    private int duration;
    private final TreeMap<Goal, Double> insistences = CollectionLiterals.newTreeMap((a, b) -> {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int cmp = a.getName().compareTo(b.getName());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(System.identityHashCode(a), System.identityHashCode(b));
    });

    @DefaultValueSource
    public BaseAction(@DefaultValue(value="io.sarl.api.game.tgob.BaseAction#NEW_0") String name, @DefaultValue(value="io.sarl.api.game.tgob.BaseAction#NEW_1") int duration) {
        this.setName(name);
        this.setDuration(duration);
    }

    @Override
    @Pure
    public double getInsistenceChangeFor(Goal goal) {
        Double value;
        if (goal != null && (value = this.insistences.get(goal)) != null) {
            return value == null ? 0.0 : value;
        }
        return 0.0;
    }

    public void setInsistenceChangeFor(Goal goal, double insistence) {
        if (goal != null) {
            if (insistence != 0.0) {
                this.insistences.put(goal, insistence);
            } else {
                this.insistences.remove(goal);
            }
        }
    }

    @Pure
    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("Action: ").append(this.getName()).append("\t");
        boolean first = true;
        Set<Map.Entry<Goal, Double>> _entrySet = this.insistences.entrySet();
        for (Map.Entry<Goal, Double> entry : _entrySet) {
            Goal goal = entry.getKey();
            Double insistence = entry.getValue();
            if ((insistence == null ? 0.0 : insistence) == 0.0) continue;
            if (first) {
                first = false;
            } else {
                msg.append(", ");
            }
            msg.append(goal.getName()).append(": ").append(AbstractGob.formatNumber(insistence == null ? 0.0 : insistence));
        }
        msg.append("\t").append(AbstractGob.formatNumber(this.getDuration())).append(" unit(s)");
        return msg.toString();
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static String $DEFAULT_VALUE$NEW_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="0")
    private static int $DEFAULT_VALUE$NEW_1() {
        return 0;
    }

    @DefaultValueUse(value="java.lang.String,int")
    @SyntheticMember
    public BaseAction() {
        this(BaseAction.$DEFAULT_VALUE$NEW_0(), BaseAction.$DEFAULT_VALUE$NEW_1());
    }

    @DefaultValueUse(value="java.lang.String,int")
    @SyntheticMember
    public BaseAction(int duration) {
        this(BaseAction.$DEFAULT_VALUE$NEW_0(), duration);
    }

    @DefaultValueUse(value="java.lang.String,int")
    @SyntheticMember
    public BaseAction(String name) {
        this(name, BaseAction.$DEFAULT_VALUE$NEW_1());
    }

    @Override
    @Pure
    @SyntheticMember
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseAction other = (BaseAction)obj;
        if (other.duration != this.duration) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    @Pure
    @SyntheticMember
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + Integer.hashCode(this.duration);
        return result;
    }

    @Override
    @Pure
    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }
}

