/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.api.game.tgob;

import io.sarl.api.game.tgob.Action;
import io.sarl.api.game.tgob.Goal;
import io.sarl.api.game.tgob.SelectAction;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@SarlSpecification(value="0.15")
@SarlElementType(value=22)
@XbaseGenerated
public class StandardActionSelectionSkill
extends Skill
implements SelectAction {
    @Override
    public Action selectAction(List<? extends Action> actions, List<? extends Goal> goals) {
        Iterator<? extends Action> iterator = actions.iterator();
        Action bestAction = iterator.next();
        double bestValue = this.calculateDiscontentment(bestAction, goals);
        while (iterator.hasNext()) {
            Action action = iterator.next();
            double value = this.calculateDiscontentment(action, goals);
            if (!(value < bestValue)) continue;
            bestValue = value;
            bestAction = action;
        }
        return bestAction;
    }

    @Pure
    protected double calculateDiscontentment(Action action, List<? extends Goal> goals) {
        double discontentment = 0.0;
        for (Goal goal : goals) {
            double _insistence = goal.getInsistence();
            double _insistenceChangeFor = action.getInsistenceChangeFor(goal);
            double newInsistence = _insistence + _insistenceChangeFor;
            int _duration = action.getDuration();
            double _insistenceChangePerTimeUnit = goal.getInsistenceChangePerTimeUnit();
            double _discontentmentFor = goal.getDiscontentmentFor(newInsistence += (double)_duration * _insistenceChangePerTimeUnit);
            discontentment += _discontentmentFor;
        }
        return discontentment;
    }

    @SyntheticMember
    public StandardActionSelectionSkill() {
    }

    @SyntheticMember
    public StandardActionSelectionSkill(Agent arg0) {
        super(arg0);
    }
}

