/*
 * Decompiled with CFR 0.152.
 */
package io.scalaland.chimney.internal;

import io.scalaland.chimney.internal.AmbiguousCoproductInstance;
import io.scalaland.chimney.internal.CantFindCoproductInstanceTransformer;
import io.scalaland.chimney.internal.CantFindValueClassMember;
import io.scalaland.chimney.internal.DerivationError;
import io.scalaland.chimney.internal.IncompatibleSourceTuple;
import io.scalaland.chimney.internal.MissingAccessor;
import io.scalaland.chimney.internal.MissingJavaBeanSetterParam;
import io.scalaland.chimney.internal.MissingTransformer;
import io.scalaland.chimney.internal.NotSupportedDerivation;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;

public final class DerivationError$
implements Serializable {
    public static final DerivationError$ MODULE$ = new DerivationError$();

    public String printErrors(Seq<DerivationError> errors) {
        return ((IterableOnceOps)errors.groupBy((Function1 & Serializable)e -> new Tuple2((Object)e.targetTypeName(), (Object)e.sourceTypeName())).map((Function1 & Serializable)x0$1 -> {
            String string;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Seq errs = (Seq)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            String targetTypeName = (String)tuple22._1();
            String sourceTypeName = (String)tuple22._2();
            Seq errStrings = (Seq)((IterableOps)errs.distinct()).map((Function1 & Serializable)x0$2 -> {
                String string;
                DerivationError derivationError = x0$2;
                if (derivationError instanceof MissingAccessor) {
                    MissingAccessor missingAccessor = (MissingAccessor)derivationError;
                    String fieldName = missingAccessor.fieldName();
                    String fieldTypeName = missingAccessor.fieldTypeName();
                    String sourceTypeName = missingAccessor.sourceTypeName();
                    string = new StringBuilder(41).append("  ").append(fieldName).append(": ").append(fieldTypeName).append(" - no accessor named ").append(fieldName).append(" in source type ").append(sourceTypeName).toString();
                } else if (derivationError instanceof MissingJavaBeanSetterParam) {
                    MissingJavaBeanSetterParam missingJavaBeanSetterParam = (MissingJavaBeanSetterParam)derivationError;
                    String setterName = missingJavaBeanSetterParam.setterName();
                    String requiredTypeName = missingJavaBeanSetterParam.requiredTypeName();
                    String sourceTypeName = missingJavaBeanSetterParam.sourceTypeName();
                    string = new StringBuilder(46).append("  set").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(setterName))).append("(").append(setterName).append(": ").append(requiredTypeName).append(") - no accessor named ").append(setterName).append(" in source type ").append(sourceTypeName).toString();
                } else if (derivationError instanceof MissingTransformer) {
                    MissingTransformer missingTransformer = (MissingTransformer)derivationError;
                    String fieldName = missingTransformer.fieldName();
                    String sourceFieldTypeName = missingTransformer.sourceFieldTypeName();
                    String targetFieldTypeName = missingTransformer.targetFieldTypeName();
                    String sourceTypeName = missingTransformer.sourceTypeName();
                    string = new StringBuilder(58).append("  ").append(fieldName).append(": ").append(targetFieldTypeName).append(" - can't derive transformation from ").append(fieldName).append(": ").append(sourceFieldTypeName).append(" in source type ").append(sourceTypeName).toString();
                } else if (derivationError instanceof CantFindValueClassMember) {
                    CantFindValueClassMember cantFindValueClassMember = (CantFindValueClassMember)derivationError;
                    String sourceTypeName = cantFindValueClassMember.sourceTypeName();
                    string = new StringBuilder(35).append("  can't find member of value class ").append(sourceTypeName).toString();
                } else if (derivationError instanceof CantFindCoproductInstanceTransformer) {
                    CantFindCoproductInstanceTransformer cantFindCoproductInstanceTransformer = (CantFindCoproductInstanceTransformer)derivationError;
                    String instance = cantFindCoproductInstanceTransformer.instance();
                    string = new StringBuilder(41).append("  can't transform coproduct instance ").append(instance).append(" to ").append(targetTypeName).toString();
                } else if (derivationError instanceof AmbiguousCoproductInstance) {
                    AmbiguousCoproductInstance ambiguousCoproductInstance = (AmbiguousCoproductInstance)derivationError;
                    String instance = ambiguousCoproductInstance.instance();
                    string = new StringBuilder(38).append("  coproduct instance ").append(instance).append(" of ").append(targetTypeName).append(" is ambiguous").toString();
                } else if (derivationError instanceof IncompatibleSourceTuple) {
                    IncompatibleSourceTuple incompatibleSourceTuple = (IncompatibleSourceTuple)derivationError;
                    int sourceArity = incompatibleSourceTuple.sourceArity();
                    int targetArity = incompatibleSourceTuple.targetArity();
                    String sourceTypeName = incompatibleSourceTuple.sourceTypeName();
                    string = new StringBuilder(85).append("  source tuple ").append(sourceTypeName).append(" is of arity ").append(sourceArity).append(", while target type ").append(targetTypeName).append(" is of arity ").append(targetArity).append("; they need to be equal!").toString();
                } else if (derivationError instanceof NotSupportedDerivation) {
                    NotSupportedDerivation notSupportedDerivation = (NotSupportedDerivation)derivationError;
                    String fieldName = notSupportedDerivation.fieldName();
                    String sourceTypeName = notSupportedDerivation.sourceTypeName();
                    string = new StringBuilder(53).append("  derivation from ").append(fieldName).append(": ").append(sourceTypeName).append(" to ").append(targetTypeName).append(" is not supported in Chimney!").toString();
                } else {
                    throw new MatchError((Object)derivationError);
                }
                return string;
            });
            Seq fieldsWithMethodAccessor = (Seq)errors.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends DerivationError, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof MissingAccessor) {
                        MissingAccessor missingAccessor = (MissingAccessor)A1;
                        String fieldName = missingAccessor.fieldName();
                        boolean bl = missingAccessor.defAvailable();
                        if (bl) {
                            object = new StringBuilder(2).append("`").append(fieldName).append("`").toString();
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(DerivationError x1) {
                    MissingAccessor missingAccessor;
                    boolean bl;
                    DerivationError derivationError = x1;
                    boolean bl2 = derivationError instanceof MissingAccessor && (bl = (missingAccessor = (MissingAccessor)derivationError).defAvailable());
                    return bl2;
                }
            });
            if (fieldsWithMethodAccessor.nonEmpty()) {
                String first3Fields = ((IterableOnceOps)fieldsWithMethodAccessor.take(3)).mkString(", ");
                int otherFields = fieldsWithMethodAccessor.length() - 3;
                String fields = otherFields > 0 ? new StringBuilder(19).append(first3Fields).append(" and ").append(otherFields).append(" other methods").toString() : first3Fields;
                string = new StringBuilder(111).append("\nThere are methods in ").append(sourceTypeName).append(" that might be used as accessors for ").append(fields).append(" fields in ").append(targetTypeName).append(". Consider using `.enableMethodAccessors`").toString();
            } else {
                string = "";
            }
            String methodAccessorHint = string;
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(39).append(targetTypeName).append("\n           |").append(errStrings.mkString("\n")).append("\n           |").append(methodAccessorHint).append("\n           |").toString()));
        })).mkString("\n");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DerivationError$.class);
    }

    private DerivationError$() {
    }
}

