/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config;

import io.scalecube.config.PropertyCallback;
import io.scalecube.config.source.LoadedConfigProperty;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractConfigProperty<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigProperty.class);
    private static final String ERROR_VALIDATION_FAILED = "Validation failed on config property: '%s', failed value: %s";
    final String name;
    final Class<?> propertyClass;
    final Collection<Predicate<T>> validators = new CopyOnWriteArraySet<Predicate<T>>();
    final Collection<BiConsumer<T, T>> callbacks = new CopyOnWriteArraySet<BiConsumer<T, T>>();
    private PropertyCallback<T> propertyCallback;
    private volatile T value;
    private volatile List<LoadedConfigProperty> inputList;

    AbstractConfigProperty(String name, Class<?> propertyClass) {
        this.name = name;
        this.propertyClass = propertyClass;
    }

    public final String name() {
        return this.name;
    }

    public final Optional<T> value() {
        return Optional.ofNullable(this.value);
    }

    public final void addValidator(Predicate<T> validator) {
        if (!validator.test(this.value)) {
            throw new IllegalArgumentException(String.format(ERROR_VALIDATION_FAILED, this.name, this.value));
        }
        this.validators.add(validator);
    }

    public final void addCallback(BiConsumer<T, T> callback) {
        this.callbacks.add((t1, t2) -> this.invokeCallback(callback, t1, t2));
    }

    public final void addCallback(Executor executor, BiConsumer<T, T> callback) {
        this.callbacks.add((t1, t2) -> executor.execute(() -> this.invokeCallback(callback, t1, t2)));
    }

    final void setPropertyCallback(PropertyCallback<T> propertyCallback) {
        this.propertyCallback = propertyCallback;
        this.propertyCallback.addConfigProperty(this);
    }

    final void computeValue(List<LoadedConfigProperty> inputList) {
        this.propertyCallback.computeValue(inputList, this);
    }

    final void acceptValue(T value1, List<LoadedConfigProperty> inputList1, boolean invokeCallbacks) {
        if (this.value == null && value1 == null || this.isInputsEqual(inputList1)) {
            return;
        }
        if (!this.validators.stream().allMatch(input -> input.test(value1))) {
            throw new IllegalArgumentException(String.format(ERROR_VALIDATION_FAILED, this.name, this.value));
        }
        T t1 = this.value;
        this.value = value1;
        Object t2 = this.value;
        this.inputList = inputList1;
        if (invokeCallbacks) {
            for (BiConsumer<T, T> callback : this.callbacks) {
                callback.accept(t1, t2);
            }
        }
    }

    final Optional<String> mapToString(Function<List<LoadedConfigProperty>, String> mapper) {
        return Optional.ofNullable(this.inputList).map(mapper);
    }

    private void invokeCallback(BiConsumer<T, T> callback, T t1, T t2) {
        try {
            callback.accept(t1, t2);
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred on property-change callback: {}, property name: '{}', oldValue: {}, newValue: {}, cause: {}", new Object[]{callback, this.name, t1, t2, e, e});
        }
    }

    protected boolean isMyProperty(LoadedConfigProperty property) {
        return this.name.equals(property.name());
    }

    private boolean isInputsEqual(List<LoadedConfigProperty> inputList1) {
        if (this.inputList == null && inputList1 != null || this.inputList != null && inputList1 == null) {
            return false;
        }
        Map<String, Optional> inputMap = this.inputList.stream().collect(Collectors.toMap(LoadedConfigProperty::name, LoadedConfigProperty::valueAsString));
        Map<String, Optional> inputMap1 = inputList1.stream().collect(Collectors.toMap(LoadedConfigProperty::name, LoadedConfigProperty::valueAsString));
        return inputMap.equals(inputMap1);
    }
}

