/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config;

import io.scalecube.config.AbstractConfigProperty;
import io.scalecube.config.ConfigProperty;
import io.scalecube.config.PropertyCallback;
import io.scalecube.config.source.LoadedConfigProperty;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class AbstractSimpleConfigProperty<T>
extends AbstractConfigProperty<T>
implements ConfigProperty {
    AbstractSimpleConfigProperty(String name, Class<?> propertyClass, Map<String, LoadedConfigProperty> propertyMap, Map<String, Map<Class, PropertyCallback>> propertyCallbackMap, Function<String, T> valueParser) {
        super(name, propertyClass);
        this.setPropertyCallback(this.computePropertyCallback(valueParser, propertyCallbackMap));
        LoadedConfigProperty configProperty = propertyMap.get(name);
        this.computeValue(configProperty != null ? Collections.singletonList(configProperty) : null);
    }

    @Override
    public final Optional<String> source() {
        return this.mapToString(list -> ((LoadedConfigProperty)list.get(0)).source().orElse(null));
    }

    @Override
    public final Optional<String> origin() {
        return this.mapToString(list -> ((LoadedConfigProperty)list.get(0)).origin().orElse(null));
    }

    @Override
    public final Optional<String> valueAsString() {
        return this.mapToString(list -> ((LoadedConfigProperty)list.get(0)).valueAsString().orElse(null));
    }

    @Override
    public final String valueAsString(String defaultValue) {
        return this.valueAsString().orElse(defaultValue);
    }

    final NoSuchElementException newNoSuchElementException() {
        return new NoSuchElementException("Value is null for property '" + this.name + "'");
    }

    private PropertyCallback computePropertyCallback(Function<String, T> valueParser, Map<String, Map<Class, PropertyCallback>> propertyCallbackMap) {
        PropertyCallback<Object> propertyCallback = new PropertyCallback<Object>(list -> ((LoadedConfigProperty)list.get(0)).valueAsString().map(valueParser).orElse(null));
        propertyCallbackMap.putIfAbsent(this.name, new ConcurrentHashMap());
        Map<Class, PropertyCallback> callbackMap = propertyCallbackMap.get(this.name);
        callbackMap.putIfAbsent(this.propertyClass, propertyCallback);
        return callbackMap.get(this.propertyClass);
    }
}

