/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config;

import io.scalecube.config.BooleanConfigProperty;
import io.scalecube.config.ConfigPropertyInfo;
import io.scalecube.config.ConfigRegistryImpl;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.DoubleConfigProperty;
import io.scalecube.config.DurationConfigProperty;
import io.scalecube.config.IntConfigProperty;
import io.scalecube.config.ListConfigProperty;
import io.scalecube.config.LongConfigProperty;
import io.scalecube.config.MultimapConfigProperty;
import io.scalecube.config.ObjectConfigProperty;
import io.scalecube.config.StringConfigProperty;
import io.scalecube.config.audit.ConfigEvent;
import io.scalecube.config.source.ConfigSourceInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public interface ConfigRegistry {
    public static ConfigRegistry create(ConfigRegistrySettings settings) {
        ConfigRegistryImpl configRegistry = new ConfigRegistryImpl(settings);
        configRegistry.init();
        return configRegistry;
    }

    public <T> ObjectConfigProperty<T> objectProperty(String var1, Class<T> var2);

    public <T> ObjectConfigProperty<T> objectProperty(Map<String, String> var1, Class<T> var2);

    public <T> ObjectConfigProperty<T> objectProperty(String var1, Function<String, T> var2);

    public <T> T objectValue(String var1, Class<T> var2, T var3);

    public <T> T objectValue(Map<String, String> var1, Class<T> var2, T var3);

    public StringConfigProperty stringProperty(String var1);

    public String stringValue(String var1, String var2);

    public DoubleConfigProperty doubleProperty(String var1);

    public double doubleValue(String var1, double var2);

    public LongConfigProperty longProperty(String var1);

    public long longValue(String var1, long var2);

    public BooleanConfigProperty booleanProperty(String var1);

    public boolean booleanValue(String var1, boolean var2);

    public IntConfigProperty intProperty(String var1);

    public int intValue(String var1, int var2);

    public DurationConfigProperty durationProperty(String var1);

    public Duration durationValue(String var1, Duration var2);

    public ListConfigProperty<String> stringListProperty(String var1);

    public List<String> stringListValue(String var1, List<String> var2);

    public ListConfigProperty<Double> doubleListProperty(String var1);

    public List<Double> doubleListValue(String var1, List<Double> var2);

    public ListConfigProperty<Long> longListProperty(String var1);

    public List<Long> longListValue(String var1, List<Long> var2);

    public ListConfigProperty<Integer> intListProperty(String var1);

    public List<Integer> intListValue(String var1, List<Integer> var2);

    public ListConfigProperty<Duration> durationListProperty(String var1);

    public List<Duration> durationListValue(String var1, List<Duration> var2);

    public MultimapConfigProperty<String> stringMultimapProperty(String var1);

    public Map<String, List<String>> stringMultimapValue(String var1, Map<String, List<String>> var2);

    public MultimapConfigProperty<Double> doubleMultimapProperty(String var1);

    public Map<String, List<Double>> doubleMultimapValue(String var1, Map<String, List<Double>> var2);

    public MultimapConfigProperty<Long> longMultimapProperty(String var1);

    public Map<String, List<Long>> longMultimapValue(String var1, Map<String, List<Long>> var2);

    public MultimapConfigProperty<Integer> intMultimapProperty(String var1);

    public Map<String, List<Integer>> intMultimapValue(String var1, Map<String, List<Integer>> var2);

    public MultimapConfigProperty<Duration> durationMultimapProperty(String var1);

    public Map<String, List<Duration>> durationMultimapValue(String var1, Map<String, List<Duration>> var2);

    public Set<String> allProperties();

    public Collection<ConfigPropertyInfo> getConfigProperties();

    public Collection<ConfigEvent> getRecentConfigEvents();

    public Collection<ConfigSourceInfo> getConfigSources();

    public ConfigRegistrySettings getSettings();
}

