/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config;

import io.scalecube.config.BooleanConfigProperty;
import io.scalecube.config.BooleanConfigPropertyImpl;
import io.scalecube.config.ConfigProperty;
import io.scalecube.config.ConfigPropertyInfo;
import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.DoubleConfigProperty;
import io.scalecube.config.DoubleConfigPropertyImpl;
import io.scalecube.config.DurationConfigProperty;
import io.scalecube.config.DurationConfigPropertyImpl;
import io.scalecube.config.DurationParser;
import io.scalecube.config.IntConfigProperty;
import io.scalecube.config.IntConfigPropertyImpl;
import io.scalecube.config.ListConfigProperty;
import io.scalecube.config.ListConfigPropertyImpl;
import io.scalecube.config.LongConfigProperty;
import io.scalecube.config.LongConfigPropertyImpl;
import io.scalecube.config.MappedObjectConfigProperty;
import io.scalecube.config.MultimapConfigProperty;
import io.scalecube.config.MultimapConfigPropertyImpl;
import io.scalecube.config.ObjectConfigProperty;
import io.scalecube.config.ObjectConfigPropertyImpl;
import io.scalecube.config.PropertyCallback;
import io.scalecube.config.StringConfigProperty;
import io.scalecube.config.StringConfigPropertyImpl;
import io.scalecube.config.audit.ConfigEvent;
import io.scalecube.config.jmx.JmxConfigRegistry;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.ConfigSourceInfo;
import io.scalecube.config.source.LoadedConfigProperty;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigRegistryImpl
implements ConfigRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRegistryImpl.class);
    static final Function<String, String> STRING_PARSER = str -> str;
    static final Function<String, Double> DOUBLE_PARSER = Double::parseDouble;
    static final Function<String, Long> LONG_PARSER = Long::parseLong;
    static final Function<String, Boolean> BOOLEAN_PARSER = Boolean::parseBoolean;
    static final Function<String, Integer> INT_PARSER = Integer::parseInt;
    static final Function<String, Duration> DURATION_PARSER = DurationParser::parseDuration;
    private static final ScheduledExecutorService reloadExecutor;
    private final ConfigRegistrySettings settings;
    private final Map<String, Integer> configSourceStatusMap = new HashMap<String, Integer>();
    private volatile Map<String, LoadedConfigProperty> propertyMap;
    private final Map<String, Map<Class, PropertyCallback>> propertyCallbackMap = new ConcurrentHashMap<String, Map<Class, PropertyCallback>>();
    private final LinkedHashMap<ConfigEvent, Object> recentConfigEvents = new LinkedHashMap<ConfigEvent, Object>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ConfigEvent, Object> eldest) {
            return this.size() > ConfigRegistryImpl.this.settings.getRecentConfigEventsNum();
        }
    };

    ConfigRegistryImpl(ConfigRegistrySettings settings) {
        Objects.requireNonNull(settings, "ConfigRegistrySettings can't be null");
        this.settings = settings;
    }

    void init() {
        this.loadAndNotify();
        reloadExecutor.scheduleAtFixedRate(() -> {
            try {
                this.loadAndNotify();
            }
            catch (Exception e) {
                LOGGER.error("Exception on config reload, cause: {}", (Object)e, (Object)e);
            }
        }, this.settings.getReloadIntervalSec(), this.settings.getReloadIntervalSec(), TimeUnit.SECONDS);
        if (this.settings.isJmxEnabled()) {
            this.registerJmxMBean();
        }
    }

    private void registerJmxMBean() {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(this.settings.getJmxMBeanName());
            mbeanServer.registerMBean(new JmxConfigRegistry(this), objectName);
            MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            LOGGER.info("Registered JMX MBean: {}", (Object)mbeanInfo);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register JMX MBean '{}', cause: {}", (Object)this.settings.getJmxMBeanName(), (Object)e);
        }
    }

    @Override
    public <T> ObjectConfigProperty<T> objectProperty(String name, Function<String, T> mapper) {
        return new MappedObjectConfigProperty<T>(new StringConfigPropertyImpl(name, this.propertyMap, this.propertyCallbackMap), mapper);
    }

    @Override
    public <T> ObjectConfigProperty<T> objectProperty(String prefix, Class<T> cfgClass) {
        Map<String, String> bindingMap = Arrays.stream(cfgClass.getDeclaredFields()).collect(Collectors.toMap(Field::getName, field -> prefix + '.' + field.getName()));
        return new ObjectConfigPropertyImpl<T>(bindingMap, cfgClass, this.propertyMap, this.propertyCallbackMap);
    }

    @Override
    public <T> ObjectConfigProperty<T> objectProperty(Map<String, String> bindingMap, Class<T> cfgClass) {
        return new ObjectConfigPropertyImpl<T>(bindingMap, cfgClass, this.propertyMap, this.propertyCallbackMap);
    }

    @Override
    public <T> T objectValue(String prefix, Class<T> cfgClass, T defaultValue) {
        return this.objectProperty(prefix, cfgClass).value(defaultValue);
    }

    @Override
    public <T> T objectValue(Map<String, String> bindingMap, Class<T> cfgClass, T defaultValue) {
        return this.objectProperty(bindingMap, cfgClass).value(defaultValue);
    }

    @Override
    public StringConfigProperty stringProperty(String name) {
        return new StringConfigPropertyImpl(name, this.propertyMap, this.propertyCallbackMap);
    }

    @Override
    public String stringValue(String name, String defaultValue) {
        return this.stringProperty(name).value(defaultValue);
    }

    @Override
    public DoubleConfigProperty doubleProperty(String name) {
        return new DoubleConfigPropertyImpl(name, this.propertyMap, this.propertyCallbackMap);
    }

    @Override
    public double doubleValue(String name, double defaultValue) {
        return this.doubleProperty(name).value(defaultValue);
    }

    @Override
    public LongConfigProperty longProperty(String name) {
        return new LongConfigPropertyImpl(name, this.propertyMap, this.propertyCallbackMap);
    }

    @Override
    public long longValue(String name, long defaultValue) {
        return this.longProperty(name).value(defaultValue);
    }

    @Override
    public BooleanConfigProperty booleanProperty(String name) {
        return new BooleanConfigPropertyImpl(name, this.propertyMap, this.propertyCallbackMap);
    }

    @Override
    public boolean booleanValue(String name, boolean defaultValue) {
        return this.booleanProperty(name).value(defaultValue);
    }

    @Override
    public IntConfigProperty intProperty(String name) {
        return new IntConfigPropertyImpl(name, this.propertyMap, this.propertyCallbackMap);
    }

    @Override
    public int intValue(String name, int defaultValue) {
        return this.intProperty(name).value(defaultValue);
    }

    @Override
    public DurationConfigProperty durationProperty(String name) {
        return new DurationConfigPropertyImpl(name, this.propertyMap, this.propertyCallbackMap);
    }

    @Override
    public Duration durationValue(String name, Duration defaultValue) {
        return this.durationProperty(name).value(defaultValue);
    }

    @Override
    public ListConfigProperty<String> stringListProperty(String name) {
        return new ListConfigPropertyImpl<String>(name, this.propertyMap, this.propertyCallbackMap, STRING_PARSER);
    }

    @Override
    public List<String> stringListValue(String name, List<String> defaultValue) {
        return this.stringListProperty(name).value(defaultValue);
    }

    @Override
    public ListConfigProperty<Double> doubleListProperty(String name) {
        return new ListConfigPropertyImpl<Double>(name, this.propertyMap, this.propertyCallbackMap, DOUBLE_PARSER);
    }

    @Override
    public List<Double> doubleListValue(String name, List<Double> defaultValue) {
        return this.doubleListProperty(name).value(defaultValue);
    }

    @Override
    public ListConfigProperty<Long> longListProperty(String name) {
        return new ListConfigPropertyImpl<Long>(name, this.propertyMap, this.propertyCallbackMap, LONG_PARSER);
    }

    @Override
    public List<Long> longListValue(String name, List<Long> defaultValue) {
        return this.longListProperty(name).value(defaultValue);
    }

    @Override
    public ListConfigProperty<Integer> intListProperty(String name) {
        return new ListConfigPropertyImpl<Integer>(name, this.propertyMap, this.propertyCallbackMap, INT_PARSER);
    }

    @Override
    public List<Integer> intListValue(String name, List<Integer> defaultValue) {
        return this.intListProperty(name).value(defaultValue);
    }

    @Override
    public ListConfigProperty<Duration> durationListProperty(String name) {
        return new ListConfigPropertyImpl<Duration>(name, this.propertyMap, this.propertyCallbackMap, DURATION_PARSER);
    }

    @Override
    public List<Duration> durationListValue(String name, List<Duration> defaultValue) {
        return this.durationListProperty(name).value(defaultValue);
    }

    @Override
    public MultimapConfigProperty<String> stringMultimapProperty(String name) {
        return new MultimapConfigPropertyImpl<String>(name, this.propertyMap, this.propertyCallbackMap, STRING_PARSER);
    }

    @Override
    public Map<String, List<String>> stringMultimapValue(String name, Map<String, List<String>> defaultValue) {
        return this.stringMultimapProperty(name).value(defaultValue);
    }

    @Override
    public MultimapConfigProperty<Double> doubleMultimapProperty(String name) {
        return new MultimapConfigPropertyImpl<Double>(name, this.propertyMap, this.propertyCallbackMap, DOUBLE_PARSER);
    }

    @Override
    public Map<String, List<Double>> doubleMultimapValue(String name, Map<String, List<Double>> defaultValue) {
        return this.doubleMultimapProperty(name).value(defaultValue);
    }

    @Override
    public MultimapConfigProperty<Long> longMultimapProperty(String name) {
        return new MultimapConfigPropertyImpl<Long>(name, this.propertyMap, this.propertyCallbackMap, LONG_PARSER);
    }

    @Override
    public Map<String, List<Long>> longMultimapValue(String name, Map<String, List<Long>> defaultValue) {
        return this.longMultimapProperty(name).value(defaultValue);
    }

    @Override
    public MultimapConfigProperty<Integer> intMultimapProperty(String name) {
        return new MultimapConfigPropertyImpl<Integer>(name, this.propertyMap, this.propertyCallbackMap, INT_PARSER);
    }

    @Override
    public Map<String, List<Integer>> intMultimapValue(String name, Map<String, List<Integer>> defaultValue) {
        return this.intMultimapProperty(name).value(defaultValue);
    }

    @Override
    public MultimapConfigProperty<Duration> durationMultimapProperty(String name) {
        return new MultimapConfigPropertyImpl<Duration>(name, this.propertyMap, this.propertyCallbackMap, DURATION_PARSER);
    }

    @Override
    public Map<String, List<Duration>> durationMultimapValue(String name, Map<String, List<Duration>> defaultValue) {
        return this.durationMultimapProperty(name).value(defaultValue);
    }

    @Override
    public Set<String> allProperties() {
        return this.propertyMap.values().stream().map(LoadedConfigProperty::name).collect(Collectors.toSet());
    }

    @Override
    public Collection<ConfigPropertyInfo> getConfigProperties() {
        return this.propertyMap.values().stream().map(property -> {
            ConfigPropertyInfo info = new ConfigPropertyInfo();
            info.setName(property.name());
            info.setValue(property.valueAsString().orElse(null));
            info.setSource(property.source().orElse(null));
            info.setOrigin(property.origin().orElse(null));
            info.setHost(this.settings.getHost());
            return info;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<ConfigSourceInfo> getConfigSources() {
        ArrayList<ConfigSourceInfo> result = new ArrayList<ConfigSourceInfo>();
        int order = 0;
        for (Map.Entry<String, ConfigSource> entry : this.settings.getSources().entrySet()) {
            int priorityOrder = order++;
            String sourceName = entry.getKey();
            ConfigSource configSource = entry.getValue();
            ConfigSourceInfo info = new ConfigSourceInfo();
            info.setSourceName(sourceName);
            info.setPriorityOrder(priorityOrder);
            info.setConfigSourceString(configSource.toString());
            Integer status = this.configSourceStatusMap.get(sourceName);
            info.setHealthString(Optional.ofNullable(status).map(i -> i == 1 ? "Error" : "Ok").orElse("Unknown"));
            info.setHost(this.settings.getHost());
            result.add(info);
        }
        return result;
    }

    @Override
    public Collection<ConfigEvent> getRecentConfigEvents() {
        return new LinkedHashSet<ConfigEvent>(this.recentConfigEvents.keySet());
    }

    @Override
    public ConfigRegistrySettings getSettings() {
        return this.settings;
    }

    private void loadAndNotify() {
        ConcurrentHashMap<String, LoadedConfigProperty> loadedPropertyMap = new ConcurrentHashMap<String, LoadedConfigProperty>();
        Map<String, ConfigSource> sources = this.settings.getSources();
        for (String string : sources.keySet()) {
            ConfigSource source = sources.get(string);
            Exception loadException = null;
            Object configMap = null;
            try {
                configMap = source.loadConfig();
            }
            catch (Exception e) {
                loadException = e;
            }
            this.computeConfigLoadStatus(string, source, loadException);
            if (loadException != null) continue;
            configMap.forEach((key, configProperty) -> loadedPropertyMap.putIfAbsent((String)key, LoadedConfigProperty.withCopyFrom(configProperty).source(string).build()));
        }
        ArrayList<ConfigEvent> detectedChanges = new ArrayList<ConfigEvent>();
        if (this.propertyMap == null) {
            for (String propName : loadedPropertyMap.keySet()) {
                ConfigProperty newProp = (ConfigProperty)loadedPropertyMap.get(propName);
                detectedChanges.add(ConfigEvent.createAdded(propName, this.settings.getHost(), newProp));
            }
        } else {
            ConfigProperty oldProp;
            Set<String> set = this.propertyMap.keySet();
            Set keySet2 = loadedPropertyMap.keySet();
            Set updatedProps = Stream.concat(set.stream(), keySet2.stream()).filter(set::contains).filter(keySet2::contains).collect(Collectors.toSet());
            for (Object propName : updatedProps) {
                ConfigProperty newProp = (ConfigProperty)loadedPropertyMap.get(propName);
                oldProp = this.propertyMap.get(propName);
                detectedChanges.add(ConfigEvent.createUpdated((String)propName, this.settings.getHost(), oldProp, newProp));
            }
            Set removedProps = set.stream().filter(o -> !keySet2.contains(o)).collect(Collectors.toSet());
            for (String propName : removedProps) {
                oldProp = this.propertyMap.get(propName);
                if (oldProp == null) continue;
                detectedChanges.add(ConfigEvent.createRemoved(propName, this.settings.getHost(), oldProp));
            }
            Set addedProps = keySet2.stream().filter(o -> !keySet1.contains(o)).collect(Collectors.toSet());
            for (String propName : addedProps) {
                ConfigProperty newProp = (ConfigProperty)loadedPropertyMap.get(propName);
                detectedChanges.add(ConfigEvent.createAdded(propName, this.settings.getHost(), newProp));
            }
        }
        this.propertyMap = loadedPropertyMap;
        detectedChanges.forEach(input -> this.recentConfigEvents.put((ConfigEvent)input, null));
        this.reportChanges(detectedChanges.stream().filter(ConfigEvent::isChanged).collect(Collectors.toList()));
        detectedChanges.stream().filter(event -> this.propertyCallbackMap.containsKey(event.getName())).flatMap(event -> this.propertyCallbackMap.get(event.getName()).values().stream().map(callback -> new AbstractMap.SimpleImmutableEntry<PropertyCallback, ConfigEvent>((PropertyCallback)callback, (ConfigEvent)event))).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, Collectors.mapping(AbstractMap.SimpleImmutableEntry::getValue, Collectors.toList()))).forEach(PropertyCallback::computeValue);
    }

    private void reportChanges(Collection<ConfigEvent> events) {
        Collection<ConfigEvent> configEvents = Collections.unmodifiableCollection(events);
        this.settings.getListeners().forEach((key, eventListener) -> {
            try {
                eventListener.onEvents(configEvents);
            }
            catch (Exception e) {
                LOGGER.error("Exception on configEventListener: {}, events: {}, cause: {}", new Object[]{key, configEvents, e, e});
            }
        });
    }

    private void computeConfigLoadStatus(String name, ConfigSource source, Throwable throwable) {
        int status = throwable != null ? 1 : 0;
        Integer status0 = this.configSourceStatusMap.put(name, status);
        if (status0 == null || (status0 ^ status) == 1) {
            if (status == 1) {
                LOGGER.error("Exception at loadConfig on {}, source: {}, cause: {}", new Object[]{source, name, throwable});
            } else {
                LOGGER.debug("Loaded config properties from {}, source: {}", (Object)source, (Object)name);
            }
        }
    }

    static {
        ThreadFactory threadFactory = r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("config-reloader");
            thread.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Exception occurred: " + e, e));
            return thread;
        };
        reloadExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }
}

