/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;

class DurationParser {
    private DurationParser() {
    }

    static Duration parseDuration(String input) {
        ChronoUnit units;
        String originalUnitString;
        if (input.startsWith("P") || input.startsWith("-P") || input.startsWith("+P")) {
            return Duration.parse(input);
        }
        String[] parts = DurationParser.splitNumericAndChar(input);
        String numberString = parts[0];
        String unitString = originalUnitString = parts[1];
        if (numberString.length() == 0) {
            throw new IllegalArgumentException(String.format("No number in duration value '%s'", input));
        }
        if (unitString.length() > 2 && !unitString.endsWith("s")) {
            unitString = unitString + "s";
        }
        switch (unitString) {
            case "ns": {
                units = ChronoUnit.NANOS;
                break;
            }
            case "us": {
                units = ChronoUnit.MICROS;
                break;
            }
            case "": 
            case "ms": {
                units = ChronoUnit.MILLIS;
                break;
            }
            case "s": {
                units = ChronoUnit.SECONDS;
                break;
            }
            case "m": {
                units = ChronoUnit.MINUTES;
                break;
            }
            case "h": {
                units = ChronoUnit.HOURS;
                break;
            }
            case "d": {
                units = ChronoUnit.DAYS;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Could not parse time unit '%s' (try ns, us, ms, s, m, h, d)", originalUnitString));
            }
        }
        return Duration.of(Long.parseLong(numberString), units);
    }

    private static String[] splitNumericAndChar(String input) {
        char c;
        int i;
        for (i = input.length() - 1; i >= 0 && Character.isLetter(c = input.charAt(i)); --i) {
        }
        return new String[]{input.substring(0, i + 1).trim(), input.substring(i + 1).trim()};
    }
}

